/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.model;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseRepository
implements Iterable<License> {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseRepository.class);
    public static final String REPOSITORY_DEFINITION_FILE = "licenses.properties";
    public static final Pattern LICENSE_DESCRIPTION_PATTERN = Pattern.compile("(.*)\\s*~~\\s*license\\s*:\\s*(.*)\\s*~~\\s*header\\s*:\\s*(.*)\\s*");
    protected URL baseURL;
    protected List<License> licenses;
    protected boolean init;

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.checkNotInit("setBaseURL");
        this.baseURL = baseURL;
    }

    protected URL getDefinitionURL() {
        if (this.baseURL == null || StringUtils.isEmpty((CharSequence)this.baseURL.toString())) {
            throw new IllegalStateException("no baseURL defined in " + this);
        }
        URL definitionURL = MojoHelper.getUrl(this.getBaseURL(), REPOSITORY_DEFINITION_FILE);
        return definitionURL;
    }

    protected URL getLicenseBaseURL(String licenseName) {
        URL licenseBaseURL = MojoHelper.getUrl(this.baseURL, licenseName);
        return licenseBaseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        this.checkNotInit("load");
        try {
            URL definitionURL = this.getDefinitionURL();
            if (this.licenses != null) {
                this.licenses.clear();
            } else {
                this.licenses = new ArrayList<License>();
            }
            if (!this.checkExists(definitionURL)) {
                throw new IllegalArgumentException("no licenses.properties found with url [" + definitionURL + "] for resolver " + this);
            }
            Properties p = new Properties();
            p.load(definitionURL.openStream());
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String headerFile;
                String licenseFile;
                String licenseName = (String)entry.getKey();
                licenseName = licenseName.trim().toLowerCase();
                URL licenseBaseURL = this.getLicenseBaseURL(licenseName);
                License license = new License();
                license.setName(licenseName);
                license.setBaseURL(licenseBaseURL);
                String licenseDescription = (String)entry.getValue();
                Matcher matcher = LICENSE_DESCRIPTION_PATTERN.matcher(licenseDescription);
                if (matcher.matches()) {
                    licenseDescription = matcher.group(1).trim();
                    licenseFile = matcher.group(2).trim();
                    headerFile = matcher.group(3).trim();
                } else {
                    licenseFile = "license.txt";
                    headerFile = "header.txt";
                }
                URL licenseFileURL = this.getFileURL(license, licenseFile);
                license.setLicenseURL(licenseFileURL);
                URL headerFileURL = this.getFileURL(license, headerFile);
                license.setHeaderURL(headerFileURL);
                license.setDescription(licenseDescription);
                LOG.debug("register {}", (Object)license.getDescription());
                LOG.debug("{}", (Object)license);
                this.licenses.add(license);
            }
            this.licenses = Collections.unmodifiableList(this.licenses);
        }
        finally {
            this.init = true;
        }
    }

    public String[] getLicenseNames() {
        this.checkInit("getLicenseNames");
        ArrayList<String> result = new ArrayList<String>(this.licenses.size());
        for (License license : this) {
            result.add(license.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public License[] getLicenses() {
        this.checkInit("getLicenses");
        return this.licenses.toArray(new License[this.licenses.size()]);
    }

    public License getLicense(String licenseName) {
        this.checkInit("getLicense");
        if (StringUtils.isEmpty((CharSequence)licenseName)) {
            throw new IllegalArgumentException("licenceName can not be null, nor empty");
        }
        License license = null;
        for (License l : this) {
            if (!licenseName.equals(l.getName())) continue;
            license = l;
            break;
        }
        return license;
    }

    @Override
    public Iterator<License> iterator() {
        this.checkInit("iterator");
        return this.licenses.iterator();
    }

    protected boolean checkExists(URL url) throws IOException {
        URLConnection openConnection = url.openConnection();
        return openConnection.getContentLength() > 0;
    }

    protected void checkInit(String operation) {
        if (!this.init) {
            throw new IllegalStateException("repository " + this + " was not init, operation [" + operation + "] not possible.");
        }
    }

    protected void checkNotInit(String operation) {
        if (this.init) {
            throw new IllegalStateException("repository " + this + "was init, operation [" + operation + "+] not possible.");
        }
    }

    protected URL getFileURL(License license, String filename) throws IOException {
        URL licenseBaseURL = license.getBaseURL();
        URL result = MojoHelper.getUrl(licenseBaseURL, filename);
        if (!this.checkExists(result)) {
            URL resultWithFtlSuffix = MojoHelper.getUrl(licenseBaseURL, filename + ".ftl");
            if (this.checkExists(resultWithFtlSuffix)) {
                result = resultWithFtlSuffix;
            } else {
                throw new IllegalArgumentException("Could not find license (" + license + ") content file at [" + result + "], nor at [" + resultWithFtlSuffix + "] for resolver " + this);
            }
        }
        return result;
    }
}

