/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.utils;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequester {
    public static boolean isStringUrl(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return false;
        }
        try {
            new URL(data);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFromUrl(String url) throws MojoExecutionException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        CloseableHttpResponse response = null;
        String result = null;
        try {
            try {
                response = httpClient.execute((HttpUriRequest)get);
                result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.forName("UTF-8"));
            }
            catch (ClientProtocolException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            Object var7_5 = null;
            if (response == null) return result;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (response == null) throw throwable;
            try {
                response.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        try {}
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        response.close();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> downloadList(String url) throws MojoExecutionException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            try {
                String line;
                bufferedReader = new BufferedReader(new CharArrayReader(HttpRequester.getFromUrl(url).toCharArray()));
                while ((line = bufferedReader.readLine()) != null) {
                    if (!StringUtils.isNotBlank((CharSequence)line) || StringUtils.startsWith((CharSequence)line, (CharSequence)"#") || list.contains(line)) continue;
                    list.add(line);
                }
                Object var5_5 = null;
                if (bufferedReader == null) return list;
            }
            catch (IOException e) {
                throw new MojoExecutionException("could not open connection to URL: " + url, (Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        try {}
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        bufferedReader.close();
        return list;
    }
}

