/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.javacc.GrammarDirectoryScanner;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JavaCC;

public abstract class AbstractJavaCCMojo
extends AbstractMojo {
    private MavenProject project;
    private String jdkVersion;
    private Integer lookAhead;
    private Integer choiceAmbiguityCheck;
    private Integer otherAmbiguityCheck;
    private Boolean isStatic;
    private Boolean debugParser;
    private Boolean debugLookAhead;
    private Boolean debugTokenManager;
    private Boolean errorReporting;
    private Boolean javaUnicodeEscape;
    private Boolean unicodeInput;
    private Boolean ignoreCase;
    private Boolean commonTokenAction;
    private Boolean userTokenManager;
    private Boolean userCharStream;
    private Boolean buildParser;
    private Boolean buildTokenManager;
    private Boolean tokenManagerUsesParser;
    private Boolean sanityCheck;
    private Boolean forceLaCheck;
    private Boolean cacheTokens;
    private Boolean keepLineColumn;

    protected String getJdkVersion() {
        return this.jdkVersion;
    }

    protected Boolean getIsStatic() {
        return this.isStatic;
    }

    protected abstract File getSourceDirectory();

    protected abstract String[] getIncludes();

    protected abstract String[] getExcludes();

    protected abstract File getOutputDirectory();

    protected abstract int getStaleMillis();

    protected String getParserPackage() {
        return null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        GrammarInfo[] grammarInfos = this.scanForGrammars();
        if (grammarInfos == null) {
            this.getLog().info((CharSequence)("Skipping non-existing source directory: " + this.getSourceDirectory()));
            return;
        }
        if (grammarInfos.length <= 0) {
            this.getLog().info((CharSequence)"Skipping - all grammars up to date");
        } else {
            for (int i = 0; i < grammarInfos.length; ++i) {
                this.processGrammar(grammarInfos[i]);
            }
            this.getLog().info((CharSequence)("Processed " + grammarInfos.length + " grammar" + (grammarInfos.length != 1 ? "s" : "")));
        }
        this.addCompileSourceRoot(this.getOutputDirectory());
    }

    protected abstract void processGrammar(GrammarInfo var1) throws MojoExecutionException, MojoFailureException;

    private GrammarInfo[] scanForGrammars() throws MojoExecutionException {
        GrammarInfo[] grammarInfos;
        if (!this.getSourceDirectory().isDirectory()) {
            return null;
        }
        this.getLog().debug((CharSequence)("Scanning for grammars: " + this.getSourceDirectory()));
        try {
            GrammarDirectoryScanner scanner = new GrammarDirectoryScanner();
            scanner.setSourceDirectory(this.getSourceDirectory());
            scanner.setIncludes(this.getIncludes());
            scanner.setExcludes(this.getExcludes());
            scanner.setOutputDirectory(this.getOutputDirectory());
            scanner.setParserPackage(this.getParserPackage());
            scanner.setStaleMillis(this.getStaleMillis());
            scanner.scan();
            grammarInfos = scanner.getIncludedGrammars();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to scan for grammars: " + this.getSourceDirectory(), e);
        }
        this.getLog().debug((CharSequence)("Found grammars: " + Arrays.asList(grammarInfos)));
        return grammarInfos;
    }

    private void addCompileSourceRoot(File directory) {
        if (this.project != null) {
            this.getLog().debug((CharSequence)("Adding compile source root: " + directory));
            this.project.addCompileSourceRoot(directory.getAbsolutePath());
        }
    }

    protected JavaCC newJavaCC() {
        JavaCC javacc = new JavaCC();
        javacc.setLog(this.getLog());
        javacc.setJdkVersion(this.jdkVersion);
        javacc.setStatic(this.isStatic);
        javacc.setBuildParser(this.buildParser);
        javacc.setBuildTokenManager(this.buildTokenManager);
        javacc.setCacheTokens(this.cacheTokens);
        javacc.setChoiceAmbiguityCheck(this.choiceAmbiguityCheck);
        javacc.setCommonTokenAction(this.commonTokenAction);
        javacc.setDebugLookAhead(this.debugLookAhead);
        javacc.setDebugParser(this.debugParser);
        javacc.setDebugTokenManager(this.debugTokenManager);
        javacc.setErrorReporting(this.errorReporting);
        javacc.setForceLaCheck(this.forceLaCheck);
        javacc.setIgnoreCase(this.ignoreCase);
        javacc.setJavaUnicodeEscape(this.javaUnicodeEscape);
        javacc.setKeepLineColumn(this.keepLineColumn);
        javacc.setLookAhead(this.lookAhead);
        javacc.setOtherAmbiguityCheck(this.otherAmbiguityCheck);
        javacc.setSanityCheck(this.sanityCheck);
        javacc.setTokenManagerUsesParser(this.tokenManagerUsesParser);
        javacc.setUnicodeInput(this.unicodeInput);
        javacc.setUserCharStream(this.userCharStream);
        javacc.setUserTokenManager(this.userTokenManager);
        return javacc;
    }
}

