/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.idlj;

import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.idlj.BuiltInTranslator;
import org.codehaus.mojo.idlj.CompilerTranslator;
import org.codehaus.mojo.idlj.GlassfishTranslator;
import org.codehaus.mojo.idlj.JacorbTranslator;

enum TranslatorType {
    DEFAULT{

        @Override
        boolean select(String compilerSetting) {
            return compilerSetting == null;
        }

        @Override
        CompilerTranslator createTranslator() {
            if (TranslatorType.isJavaModuleSystemPresent()) {
                return new GlassfishTranslator();
            }
            return new BuiltInTranslator();
        }
    }
    ,
    BUILT_IN{

        @Override
        boolean select(String compilerSetting) {
            return compilerSetting.equals("idlj");
        }

        @Override
        CompilerTranslator createTranslator() {
            return new BuiltInTranslator();
        }
    }
    ,
    GLASSFISH{

        @Override
        boolean select(String compilerSetting) {
            return compilerSetting.equals("glassfish");
        }

        @Override
        CompilerTranslator createTranslator() {
            return new GlassfishTranslator();
        }
    }
    ,
    JACORB{

        @Override
        boolean select(String compilerSetting) {
            return compilerSetting.equals("jacorb");
        }

        @Override
        CompilerTranslator createTranslator() {
            return new JacorbTranslator();
        }
    };


    private static boolean isJavaModuleSystemPresent() {
        return !System.getProperty("java.version").startsWith("1.");
    }

    static CompilerTranslator selectTranslator(String compiler) throws MojoExecutionException {
        for (TranslatorType type : TranslatorType.values()) {
            if (!type.select(compiler)) continue;
            return type.createTranslator();
        }
        throw new MojoExecutionException("Compiler not supported: " + compiler);
    }

    abstract boolean select(String var1);

    abstract CompilerTranslator createTranslator();
}

