/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten.model.resolution;

import java.io.File;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.flatten.model.resolution.ReactorModelPool;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

public class FlattenModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final RepositorySystem repositorySystem;
    private final RequestTrace trace;
    private final String context;
    private final List<RemoteRepository> repositories;
    private final ReactorModelPool reactorModelPool;

    public FlattenModelResolver(RepositorySystemSession session, RepositorySystem repositorySystem, RequestTrace trace, String context, List<RemoteRepository> repositories, List<MavenProject> reactorModels) {
        this.session = session;
        this.repositorySystem = repositorySystem;
        this.trace = trace;
        this.context = context;
        this.repositories = repositories;
        this.reactorModelPool = new ReactorModelPool();
        this.reactorModelPool.addProjects(reactorModels);
    }

    private FlattenModelResolver(FlattenModelResolver other) {
        this.session = other.session;
        this.repositorySystem = other.repositorySystem;
        this.trace = other.trace;
        this.context = other.context;
        this.repositories = other.repositories;
        this.reactorModelPool = other.reactorModelPool;
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        File pomFile = this.reactorModelPool.find(groupId, artifactId, version);
        if (pomFile == null) {
            DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
            try {
                ArtifactRequest request = new ArtifactRequest((Artifact)pomArtifact, this.repositories, this.context);
                request.setTrace(this.trace);
                pomArtifact = this.repositorySystem.resolveArtifact(this.session, request).getArtifact();
            }
            catch (ArtifactResolutionException e) {
                throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, (Throwable)e);
            }
            pomFile = pomArtifact.getFile();
        }
        return new FileModelSource(pomFile);
    }

    public void addRepository(Repository repository) {
    }

    public ModelResolver newCopy() {
        return new FlattenModelResolver(this);
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        parent.setVersion(this.resolveVersion(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()));
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        dependency.setVersion(this.resolveVersion(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()));
        return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }

    private String resolveVersion(String groupId, String artifactId, String version) throws UnresolvableModelException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest((Artifact)artifact, this.repositories, this.context);
        versionRangeRequest.setTrace(this.trace);
        try {
            VersionRangeResult versionRangeResult = this.repositorySystem.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException("No versions matched the requested range '" + version + "'", groupId, artifactId, version);
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException("The requested version range '" + version + "' does not specify an upper bound", groupId, artifactId, version);
            }
            return versionRangeResult.getHighestVersion().toString();
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, (Throwable)e);
        }
    }

    public void addRepository(Repository repository, boolean replace) {
    }
}

