/*
 * Decompiled with CFR 0.152.
 */
package org.freebsd.file;

import java.util.Arrays;

public class FileEncoding {
    private String type = "text/plain";
    private String code = "unknown";
    private String codeMime = "binary";
    private static final byte F = 0;
    private static final byte T = 1;
    private static final byte I = 2;
    private static final byte X = 3;
    private byte[] text_chars = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static final char[] EBCDIC_TO_ASCII = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\u0085', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00d5', '.', '<', '(', '+', '|', '&', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '!', '$', '*', ')', ';', '~', '-', '/', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00cb', ',', '%', '_', '>', '?', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '`', ':', '#', '@', '\'', '=', '\"', '\u00c3', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '^', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00e5', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00d2', '\u00d3', '\u00d4', '[', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', ']', '\u00e6', '\u00e7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\\', '\u009f', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    private static final char[] EBCDIC_1047_TO_8859 = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00a2', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '[', '\u00de', '\u00ae', '\u00ac', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00dd', '\u00a8', '\u00af', ']', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

    public String getCodeMime() {
        return this.codeMime;
    }

    public String getType() {
        return this.type;
    }

    public String getCode() {
        return this.code;
    }

    public boolean guessFileEncoding(byte[] buf) {
        int nbytes = buf.length;
        if (this.looksAscii(buf, nbytes)) {
            if (this.looksUtf7(buf, nbytes)) {
                this.code = "UTF-7 Unicode";
                this.codeMime = "utf-7";
            } else {
                this.code = "ASCII";
                this.codeMime = "us-ascii";
            }
        } else if (this.looksUtf8WithBOM(buf, nbytes)) {
            this.code = "UTF-8 Unicode (with BOM)";
            this.codeMime = "utf-8";
        } else if (this.looksUtf8(buf, nbytes) > 1) {
            this.code = "UTF-8 Unicode";
            this.codeMime = "utf-8";
        } else {
            int ucsType = this.looksUcs16(buf, nbytes);
            if (ucsType != 0) {
                if (ucsType == 1) {
                    this.code = "Little-endian UTF-16 Unicode";
                    this.codeMime = "utf-16le";
                } else {
                    this.code = "Big-endian UTF-16 Unicode";
                    this.codeMime = "utf-16be";
                }
            } else if (this.looksLatin1(buf, nbytes)) {
                this.code = "ISO-8859";
                this.codeMime = "iso-8859-1";
            } else if (this.looksExtended(buf, nbytes)) {
                this.code = "Non-ISO extended-ASCII";
                this.codeMime = "unknown-8bit";
            } else {
                byte[] nbuf = this.fromEbcdic(buf, nbytes);
                if (this.looksAscii(nbuf, nbytes)) {
                    this.code = "EBCDIC";
                    this.codeMime = "ebcdic";
                } else if (this.looksLatin1(nbuf, nbytes)) {
                    this.code = "International EBCDIC";
                    this.codeMime = "ebcdic";
                } else {
                    this.type = "binary";
                    return false;
                }
            }
        }
        return true;
    }

    private boolean looksAscii(byte[] buf, int nbytes) {
        for (int i = 0; i < nbytes; ++i) {
            if (this.text_chars[this.unsignedByte(buf[i])] == 1) continue;
            return false;
        }
        return true;
    }

    private boolean looksLatin1(byte[] buf, int nbytes) {
        for (int i = 0; i < nbytes; ++i) {
            byte t = this.text_chars[this.unsignedByte(buf[i])];
            if (t == 1 || t == 2) continue;
            return false;
        }
        return true;
    }

    private boolean looksExtended(byte[] buf, int nbytes) {
        for (int i = 0; i < nbytes; ++i) {
            byte t = this.text_chars[this.unsignedByte(buf[i])];
            if (t == 1 || t == 2 || t == 3) continue;
            return false;
        }
        return true;
    }

    protected int looksUtf8(byte[] buf, int nbytes) {
        boolean gotone = false;
        for (int i = 0; i < nbytes; ++i) {
            int following;
            if ((this.unsignedByte(buf[i]) & 0x80) == 0) {
                if (this.text_chars[this.unsignedByte(buf[i])] == 1) continue;
                return 0;
            }
            if ((this.unsignedByte(buf[i]) & 0x40) == 0) {
                return -1;
            }
            if ((this.unsignedByte(buf[i]) & 0x20) == 0) {
                following = 1;
            } else if ((this.unsignedByte(buf[i]) & 0x10) == 0) {
                following = 2;
            } else if ((this.unsignedByte(buf[i]) & 8) == 0) {
                following = 3;
            } else if ((this.unsignedByte(buf[i]) & 4) == 0) {
                following = 4;
            } else if ((this.unsignedByte(buf[i]) & 2) == 0) {
                following = 5;
            } else {
                return -1;
            }
            for (int n = 0; n < following; ++n) {
                if (++i >= nbytes) {
                    return gotone ? 2 : 1;
                }
                if ((this.unsignedByte(buf[i]) & 0x80) != 0 && (this.unsignedByte(buf[i]) & 0x40) <= 0) continue;
                return -1;
            }
            gotone = true;
        }
        return gotone ? 2 : 1;
    }

    private boolean looksUtf8WithBOM(byte[] buf, int nbytes) {
        if (nbytes > 3 && this.unsignedByte(buf[0]) == 239 && this.unsignedByte(buf[1]) == 187 && this.unsignedByte(buf[2]) == 191) {
            return this.looksUtf8(Arrays.copyOfRange(buf, 3, nbytes), nbytes - 3) > 0;
        }
        return false;
    }

    private boolean looksUtf7(byte[] buf, int nbytes) {
        if (nbytes > 4 && buf[0] == 43 && buf[1] == 47 && buf[2] == 118) {
            switch (buf[3]) {
                case 43: 
                case 47: 
                case 56: 
                case 57: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private int looksUcs16(byte[] buf, int nbytes) {
        int bigend;
        char[] ubuf = new char[nbytes];
        if (nbytes < 2) {
            return 0;
        }
        if (this.unsignedByte(buf[0]) == 255 && this.unsignedByte(buf[1]) == 254) {
            bigend = 0;
        } else if (this.unsignedByte(buf[0]) == 254 && this.unsignedByte(buf[1]) == 255) {
            bigend = 1;
        } else {
            return 0;
        }
        int ulen = 0;
        int i = 2;
        while (i + 1 < nbytes) {
            ubuf[ulen++] = bigend == 1 ? (char)(this.unsignedByte(buf[i + 1]) + 256 * buf[i]) : (char)(this.unsignedByte(buf[i]) + 256 * buf[i + 1]);
            if (ubuf[ulen - 1] == '\ufffe') {
                return 0;
            }
            if (ubuf[ulen - 1] < '\u0080' && this.text_chars[ubuf[ulen - 1]] != 1) {
                return 0;
            }
            i += 2;
        }
        return 1 + bigend;
    }

    private byte[] fromEbcdic(byte[] buf, int nbytes) {
        byte[] out = new byte[nbytes];
        for (int i = 0; i < nbytes; ++i) {
            out[i] = (byte)EBCDIC_TO_ASCII[this.unsignedByte(buf[i])];
        }
        return out;
    }

    private int unsignedByte(byte value) {
        return value & 0xFF;
    }
}

