/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.extraenforcer.dependencies;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;

@Named(value="banCircularDependencies")
public class BanCircularDependencies
extends AbstractEnforcerRule {
    private final DependencyGraphBuilder graphBuilder;
    private final MavenProject project;
    private final MavenSession session;
    private String message;

    @Inject
    public BanCircularDependencies(DependencyGraphBuilder graphBuilder, MavenProject project, MavenSession session) {
        this.graphBuilder = graphBuilder;
        this.project = project;
        this.session = session;
    }

    public void execute() throws EnforcerRuleException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setProject(this.project);
        Set<Artifact> artifacts = this.getDependenciesToCheck((ProjectBuildingRequest)buildingRequest);
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                this.getLog().debug((CharSequence)("groupId: " + artifact.getGroupId() + this.project.getGroupId()));
                if (!artifact.getGroupId().equals(this.project.getGroupId())) continue;
                this.getLog().debug((CharSequence)("artifactId: " + artifact.getArtifactId() + " " + this.project.getArtifactId()));
                if (!artifact.getArtifactId().equals(this.project.getArtifactId())) continue;
                throw new EnforcerRuleException(this.getErrorMessage() + "\n  " + artifact.getGroupId() + ":" + artifact.getArtifactId() + "\n ");
            }
        }
    }

    protected Set<Artifact> getDependenciesToCheck(ProjectBuildingRequest buildingRequest) throws EnforcerRuleError {
        Set<Artifact> dependencies;
        try {
            DependencyNode node = this.graphBuilder.buildDependencyGraph(buildingRequest, null);
            dependencies = this.getAllDescendants(node);
        }
        catch (DependencyGraphBuilderException e) {
            throw new EnforcerRuleError((Throwable)e);
        }
        return dependencies;
    }

    private Set<Artifact> getAllDescendants(DependencyNode node) {
        HashSet<Artifact> children = null;
        if (node.getChildren() != null) {
            children = new HashSet<Artifact>();
            for (DependencyNode depNode : node.getChildren()) {
                children.add(depNode.getArtifact());
                Set<Artifact> subNodes = this.getAllDescendants(depNode);
                if (subNodes == null) continue;
                children.addAll(subNodes);
            }
        }
        return children;
    }

    private String getErrorMessage() {
        if (this.message == null) {
            return "Circular Dependency found. Your project's groupId:artifactId combination must not exist in the list of direct or transitive dependencies.";
        }
        return this.message;
    }
}

