/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.maven.plugin.logging.Log;

class URLClassLoaderBuilder {
    private Log logger;
    private Collection<Path> paths;
    private Collection<String> exclusions;

    private URLClassLoaderBuilder() {
    }

    static URLClassLoaderBuilder builder() {
        return new URLClassLoaderBuilder();
    }

    URLClassLoaderBuilder setLogger(Log logger) {
        this.logger = logger;
        return this;
    }

    URLClassLoaderBuilder setExclusions(Collection<String> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    URLClassLoaderBuilder setPaths(Collection<Path> paths) {
        this.paths = paths;
        return this;
    }

    URLClassLoader build() throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>(this.paths.size());
        for (Path dependency : this.paths) {
            if (this.exclusions != null && this.exclusions.contains(dependency.getFileName().toString())) {
                if (this.logger == null) continue;
                this.logger.debug((CharSequence)("Excluding as requested '" + dependency + "'"));
                continue;
            }
            try {
                urls.add(dependency.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new IOException("Error during setting up classpath", e);
            }
        }
        return new ExecJavaClassLoader(urls.toArray(new URL[0]));
    }

    private static class ExecJavaClassLoader
    extends URLClassLoader {
        private final String jre = this.getJre();

        public ExecJavaClassLoader(URL[] urls) {
            super(urls);
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name == null) {
                throw new ClassNotFoundException();
            }
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> clazz;
                if (this.isDirectJvmClass(name)) {
                    try {
                        clazz = ExecJavaClassLoader.getSystemClassLoader().loadClass(name);
                        if (this.postLoad(resolve, clazz)) {
                            return clazz;
                        }
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                        // empty catch block
                    }
                }
                if (this.postLoad(resolve, clazz = this.findLoadedClass(name))) {
                    return clazz;
                }
                try {
                    clazz = super.findClass(name);
                    if (clazz != null) {
                        if (this.postLoad(resolve, clazz)) {
                            return clazz;
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                    // empty catch block
                }
                ClassLoader parent = this.getParent();
                if (parent == null) {
                    parent = ExecJavaClassLoader.getSystemClassLoader();
                }
                try {
                    clazz = Class.forName(name, false, parent);
                    if (this.postLoad(resolve, clazz)) {
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                throw new ClassNotFoundException(name);
            }
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> selfResources = this.findResources(name);
            Enumeration<URL> parentResources = this.getParent().getResources(name);
            if (!parentResources.hasMoreElements()) {
                return selfResources;
            }
            if (!selfResources.hasMoreElements()) {
                return new FilteringUrlEnum(parentResources);
            }
            return new ChainedEnumerations(Arrays.asList(selfResources, new FilteringUrlEnum(parentResources)).iterator());
        }

        private boolean isInJvm(URL resource) {
            Path path = this.toPath(resource);
            if (path == null) {
                return false;
            }
            return path.normalize().toAbsolutePath().toString().startsWith(this.jre);
        }

        private String getJre() {
            Path home = new File(System.getProperty("java.home", "")).toPath();
            if ("jre".equals(home.getFileName().toString()) && home.getParent() != null && Files.exists(home.getParent().resolve("lib/tools.jar"), new LinkOption[0])) {
                return home.getParent().toAbsolutePath().toString();
            }
            return home.toAbsolutePath().toString();
        }

        private Path toPath(URL url) {
            if ("jar".equals(url.getProtocol())) {
                try {
                    String spec = url.getFile();
                    int separator = spec.indexOf(33);
                    if (separator == -1) {
                        return null;
                    }
                    return this.toPath(new URL(spec.substring(0, separator + 1)));
                }
                catch (MalformedURLException spec) {}
            } else if ("file".equals(url.getProtocol())) {
                String path = this.decode(url.getFile());
                if (path.endsWith("!")) {
                    path = path.substring(0, path.length() - 1);
                }
                return new File(path).getAbsoluteFile().toPath();
            }
            return null;
        }

        private String decode(String fileName) {
            if (fileName.indexOf(37) == -1) {
                return fileName;
            }
            StringBuilder result = new StringBuilder(fileName.length());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int i = 0;
            while (i < fileName.length()) {
                char c = fileName.charAt(i);
                if (c == '%') {
                    out.reset();
                    do {
                        if (i + 2 >= fileName.length()) {
                            throw new IllegalArgumentException("Incomplete % sequence at: " + i);
                        }
                        int d1 = Character.digit(fileName.charAt(i + 1), 16);
                        int d2 = Character.digit(fileName.charAt(i + 2), 16);
                        if (d1 == -1 || d2 == -1) {
                            throw new IllegalArgumentException("Invalid % sequence (" + fileName.substring(i, i + 3) + ") at: " + i);
                        }
                        out.write((byte)((d1 << 4) + d2));
                    } while ((i += 3) < fileName.length() && fileName.charAt(i) == '%');
                    result.append(out.toString());
                    continue;
                }
                result.append(c);
                ++i;
            }
            return result.toString();
        }

        private boolean postLoad(boolean resolve, Class<?> clazz) {
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return true;
            }
            return false;
        }

        private boolean isDirectJvmClass(String name) {
            String sub;
            if (name.startsWith("java.")) {
                return true;
            }
            if (name.startsWith("sun.")) {
                return true;
            }
            if (name.startsWith("jdk.")) {
                return true;
            }
            if (name.startsWith("oracle.")) {
                return true;
            }
            if (name.startsWith("javafx.")) {
                return true;
            }
            if (name.startsWith("netscape.")) {
                return true;
            }
            if (name.startsWith("org.")) {
                sub = name.substring("org.".length());
                if (sub.startsWith("w3c.dom.")) {
                    return true;
                }
                if (sub.startsWith("omg.")) {
                    return true;
                }
                if (sub.startsWith("xml.sax.")) {
                    return true;
                }
                if (sub.startsWith("ietf.jgss.")) {
                    return true;
                }
                if (sub.startsWith("jcp.xml.dsig.internal.")) {
                    return true;
                }
            }
            if (name.startsWith("com.")) {
                sub = name.substring("com.".length());
                if (sub.startsWith("oracle.")) {
                    return true;
                }
                if (sub.startsWith("sun.")) {
                    String subSun = sub.substring("sun.".length());
                    if (subSun.startsWith("accessibility.")) {
                        return true;
                    }
                    if (subSun.startsWith("activation.")) {
                        return true;
                    }
                    if (subSun.startsWith("awt.")) {
                        return true;
                    }
                    if (subSun.startsWith("beans.")) {
                        return true;
                    }
                    if (subSun.startsWith("corba.se.")) {
                        return true;
                    }
                    if (subSun.startsWith("demo.jvmti.")) {
                        return true;
                    }
                    if (subSun.startsWith("image.codec.jpeg.")) {
                        return true;
                    }
                    if (subSun.startsWith("imageio.")) {
                        return true;
                    }
                    if (subSun.startsWith("istack.internal.")) {
                        return true;
                    }
                    if (subSun.startsWith("java.")) {
                        return true;
                    }
                    if (subSun.startsWith("java_cup.")) {
                        return true;
                    }
                    if (subSun.startsWith("jmx.")) {
                        return true;
                    }
                    if (subSun.startsWith("jndi.")) {
                        return true;
                    }
                    if (subSun.startsWith("management.")) {
                        return true;
                    }
                    if (subSun.startsWith("media.sound.")) {
                        return true;
                    }
                    if (subSun.startsWith("naming.internal.")) {
                        return true;
                    }
                    if (subSun.startsWith("net.")) {
                        return true;
                    }
                    if (subSun.startsWith("nio.")) {
                        return true;
                    }
                    if (subSun.startsWith("org.")) {
                        return true;
                    }
                    if (subSun.startsWith("rmi.rmid.")) {
                        return true;
                    }
                    if (subSun.startsWith("rowset.")) {
                        return true;
                    }
                    if (subSun.startsWith("security.")) {
                        return true;
                    }
                    if (subSun.startsWith("swing.")) {
                        return true;
                    }
                    if (subSun.startsWith("tracing.")) {
                        return true;
                    }
                    return subSun.startsWith("xml.internal.");
                }
            }
            return false;
        }

        static {
            try {
                ExecJavaClassLoader.registerAsParallelCapable();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static class ChainedEnumerations
        implements Enumeration<URL> {
            private final Iterator<Enumeration<URL>> enumerations;
            private Enumeration<URL> current;

            private ChainedEnumerations(Iterator<Enumeration<URL>> enumerations) {
                this.enumerations = enumerations;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.current == null || !this.current.hasMoreElements()) {
                    if (!this.enumerations.hasNext()) {
                        return false;
                    }
                    this.current = this.enumerations.next();
                }
                return this.current.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                return this.current.nextElement();
            }
        }

        private class FilteringUrlEnum
        implements Enumeration<URL> {
            private final Enumeration<URL> delegate;
            private URL next;

            private FilteringUrlEnum(Enumeration<URL> delegate) {
                this.delegate = delegate;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.delegate.hasMoreElements()) {
                    this.next = this.delegate.nextElement();
                    if (!ExecJavaClassLoader.this.isInJvm(this.next)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                return this.next;
            }
        }
    }
}

