/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.MessageTranslator;
import net.sf.clirr.core.Severity;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.mojo.clirr.ClirrDiffListener;
import org.codehaus.mojo.clirr.Difference;
import org.codehaus.plexus.i18n.I18N;

public class ClirrReportGenerator {
    private static final int FIELD_TYPE_CHANGED = 6004;
    private static final int METHOD_ARGUMENT_TYPE_CHANGED = 7005;
    private static final int METHOD_RETURN_TYPE_CHANGED = 7006;
    private final I18N i18n;
    private final ResourceBundle bundle;
    private final Sink sink;
    private boolean enableSeveritySummary;
    private final Locale locale;
    private Severity minSeverity;
    private String xrefLocation;
    private String currentVersion;
    private String comparisonVersion;

    public ClirrReportGenerator(Sink sink, I18N i18n, ResourceBundle bundle, Locale locale) {
        this.i18n = i18n;
        this.bundle = bundle;
        this.sink = sink;
        this.enableSeveritySummary = true;
        this.locale = locale;
    }

    public void generateReport(ClirrDiffListener listener) {
        this.doHeading();
        if (this.enableSeveritySummary) {
            this.doSeveritySummary(listener);
        }
        this.doDetails(listener);
        this.doApiChanges(listener);
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    private void doHeading() {
        this.sink.head();
        this.sink.title();
        String title = this.bundle.getString("report.clirr.title");
        this.sink.text(title);
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(title);
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.bundle.getString("report.clirr.clirrlink") + " ");
        this.sink.link("http://clirr.sourceforge.net/");
        this.sink.text("Clirr");
        this.sink.link_();
        this.sink.text(".");
        this.sink.paragraph_();
        this.sink.list();
        this.sink.listItem();
        this.sink.text(this.bundle.getString("report.clirr.version.current") + " ");
        this.sink.text(this.getCurrentVersion());
        this.sink.listItem_();
        if (this.getComparisonVersion() != null) {
            this.sink.listItem();
            this.sink.text(this.bundle.getString("report.clirr.version.comparison") + " ");
            this.sink.text(this.getComparisonVersion());
            this.sink.listItem_();
        }
        this.sink.list_();
        this.sink.section1_();
    }

    private void iconInfo() {
        this.icon("report.clirr.level.info", "images/icon_info_sml.gif");
    }

    private void iconWarning() {
        this.icon("report.clirr.level.warning", "images/icon_warning_sml.gif");
    }

    private void iconError() {
        this.icon("report.clirr.level.error", "images/icon_error_sml.gif");
    }

    private void icon(String altText, String image) {
        this.sink.figure();
        this.sink.figureCaption();
        this.sink.text(this.bundle.getString(altText));
        this.sink.figureCaption_();
        this.sink.figureGraphics(image);
        this.sink.figure_();
    }

    private void doSeveritySummary(ClirrDiffListener listener) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.clirr.summary"));
        this.sink.sectionTitle1_();
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.severity"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.number"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        this.severityReportTableRow(listener, Severity.ERROR, "report.clirr.level.error", "images/icon_error_sml.gif");
        if (this.minSeverity == null || this.minSeverity.compareTo((Object)Severity.WARNING) <= 0) {
            this.severityReportTableRow(listener, Severity.WARNING, "report.clirr.level.warning", "images/icon_warning_sml.gif");
        }
        if (this.minSeverity == null || this.minSeverity.compareTo((Object)Severity.INFO) <= 0) {
            this.severityReportTableRow(listener, Severity.INFO, "report.clirr.level.info", "images/icon_info_sml.gif");
        }
        this.sink.table_();
        if (this.minSeverity == null || this.minSeverity.compareTo((Object)Severity.INFO) > 0) {
            this.sink.paragraph();
            this.sink.italic();
            this.sink.text(this.bundle.getString("report.clirr.filtered"));
            this.sink.italic_();
            this.sink.paragraph_();
        }
        this.sink.section1_();
    }

    private void severityReportTableRow(ClirrDiffListener listener, Severity severity, String altText, String image) {
        this.sink.tableRow();
        this.sink.tableCell();
        this.icon(altText, image);
        this.sink.nonBreakingSpace();
        this.sink.text(this.bundle.getString(altText));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(String.valueOf(listener.getSeverityCount(severity)));
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    private void doDetails(ClirrDiffListener listener) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.clirr.api.incompatibilities"));
        this.sink.sectionTitle1_();
        List<ApiDifference> differences = listener.getApiDifferences();
        if (!differences.isEmpty()) {
            this.doIncompatibilitiesTable(differences);
        } else {
            this.sink.paragraph();
            this.sink.text(this.bundle.getString("report.clirr.noresults"));
            this.sink.paragraph_();
        }
        this.sink.section1_();
    }

    private void doIncompatibilitiesTable(List<ApiDifference> differences) {
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.severity"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.message"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.class"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.methodorfield"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        MessageTranslator translator = new MessageTranslator();
        translator.setLocale(this.locale);
        for (ApiDifference difference : differences) {
            Severity maximumSeverity = difference.getMaximumSeverity();
            if (this.minSeverity != null && this.minSeverity.compareTo((Object)maximumSeverity) > 0) continue;
            this.sink.tableRow();
            this.sink.tableCell();
            this.levelIcon(maximumSeverity);
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(difference.getReport(translator));
            this.sink.tableCell_();
            this.sink.tableCell();
            if (this.xrefLocation != null) {
                String pathToClass = difference.getAffectedClass().replace('.', '/');
                int innerClassIndex = pathToClass.lastIndexOf(36);
                if (innerClassIndex != -1) {
                    pathToClass = pathToClass.substring(0, innerClassIndex);
                }
                this.sink.link(this.xrefLocation + "/" + pathToClass + ".html");
            }
            this.sink.text(difference.getAffectedClass());
            if (this.xrefLocation != null) {
                this.sink.link_();
            }
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(difference.getAffectedMethod() != null ? difference.getAffectedMethod() : difference.getAffectedField());
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.table_();
    }

    private void levelIcon(Severity level) {
        if (Severity.INFO.equals(level)) {
            this.iconInfo();
        } else if (Severity.WARNING.equals(level)) {
            this.iconWarning();
        } else if (Severity.ERROR.equals(level)) {
            this.iconError();
        }
    }

    private void doApiChanges(ClirrDiffListener listener) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.clirr.api.changes"));
        this.sink.sectionTitle1_();
        Map<Difference, List<ApiChange>> apiChangeReport = this.getApiChangeReport(listener);
        if (apiChangeReport.isEmpty()) {
            this.sink.paragraph();
            this.sink.text(this.bundle.getString("report.clirr.noresults"));
            this.sink.paragraph_();
        } else {
            this.doApiChangesTable(apiChangeReport);
        }
        this.sink.section1_();
    }

    private Map<Difference, List<ApiChange>> getApiChangeReport(ClirrDiffListener listener) {
        HashMap<String, List<ApiChange>> tmp = new HashMap<String, List<ApiChange>>();
        for (Map.Entry<Difference, List<ApiDifference>> ignoredDiff : listener.getIgnoredApiDifferences().entrySet()) {
            for (ApiDifference apiDiff : ignoredDiff.getValue()) {
                this.putApiChange(tmp, apiDiff, ignoredDiff.getKey());
            }
        }
        for (ApiDifference apiDiff : listener.getApiDifferences()) {
            this.putApiChange(tmp, apiDiff, null);
        }
        TreeMap<Difference, List<ApiChange>> results = new TreeMap<Difference, List<ApiChange>>(new JustificationComparator());
        for (List changes : tmp.values()) {
            for (ApiChange apiChange : changes) {
                LinkedList<ApiChange> changesForDifference = (LinkedList<ApiChange>)results.get(apiChange.difference);
                if (changesForDifference == null) {
                    changesForDifference = new LinkedList<ApiChange>();
                    results.put(apiChange.difference, changesForDifference);
                }
                changesForDifference.add(apiChange);
            }
        }
        return results;
    }

    private void putApiChange(Map<String, List<ApiChange>> results, ApiDifference ignoredDiff, Difference reason) {
        ApiChange apiChange7005;
        String apiChangeKey = this.getKey(ignoredDiff);
        List<ApiChange> apiChanges = results.get(apiChangeKey);
        if (apiChanges == null) {
            apiChanges = new LinkedList<ApiChange>();
            results.put(apiChangeKey, apiChanges);
        }
        if (reason != null && reason.getDifferenceType() == 7005 && (apiChange7005 = this.find7005ApiChange(apiChanges)) != null) {
            apiChange7005.apiDifferences.add(ignoredDiff);
            return;
        }
        ApiChange change = new ApiChange();
        change.difference = reason != null ? reason : this.createNullObject();
        if (change.difference.getJustification() == null) {
            change.difference.setJustification(this.bundle.getString("report.clirr.api.changes.unjustified"));
        }
        change.apiDifferences.add(ignoredDiff);
        apiChanges.add(change);
    }

    private Difference createNullObject() {
        Difference difference = new Difference();
        difference.setClassName("");
        difference.setMethod("");
        difference.setField("");
        difference.setFrom("");
        difference.setTo("");
        difference.setJustification(this.bundle.getString("report.clirr.api.changes.unjustified"));
        return difference;
    }

    private String getKey(ApiDifference apiDiff) {
        if (apiDiff.getAffectedMethod() != null) {
            return apiDiff.getAffectedClass() + " " + apiDiff.getAffectedMethod();
        }
        return apiDiff.getAffectedClass() + " " + apiDiff.getAffectedField();
    }

    private ApiChange find7005ApiChange(List<ApiChange> apiChanges) {
        for (ApiChange apiChange : apiChanges) {
            if (apiChange.difference.getDifferenceType() != 7005) continue;
            return apiChange;
        }
        return null;
    }

    private void doApiChangesTable(Map<Difference, List<ApiChange>> apiChangeReport) {
        if (this.comparisonVersion != null) {
            Object[] args = new String[]{this.comparisonVersion, this.currentVersion};
            String message = this.i18n.format("clirr-report", this.locale, "report.clirr.api.changes.listing.comparisonversion", args);
            this.sink.text(message);
        } else {
            this.sink.text(this.bundle.getString("report.clirr.api.changes.listing"));
        }
        this.sink.list();
        for (Map.Entry<Difference, List<ApiChange>> apiChanges : apiChangeReport.entrySet()) {
            this.sink.listItem();
            this.sink.text(apiChanges.getKey().getJustification());
            this.sink.paragraph();
            this.sink.table();
            this.sink.tableRow();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.clirr.api.changes.class"));
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.clirr.api.changes.from"));
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.clirr.api.changes.to"));
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            for (ApiChange apiChange : apiChanges.getValue()) {
                apiChange.computeFields();
            }
            Collections.sort(apiChanges.getValue(), new ApiChangeComparator());
            for (ApiChange apiChange : apiChanges.getValue()) {
                this.sink.tableRow();
                this.sink.tableCell();
                this.sink.text(apiChange.getAffectedClass());
                this.sink.tableCell_();
                this.sink.tableCell();
                this.sink.text(apiChange.getFrom());
                this.sink.tableCell_();
                this.sink.tableCell();
                this.sink.text(apiChange.getTo());
                this.sink.tableCell_();
                this.sink.tableRow_();
            }
            this.sink.table_();
            this.sink.paragraph_();
            this.sink.listItem_();
        }
        this.sink.list_();
    }

    public void setEnableSeveritySummary(boolean enableSeveritySummary) {
        this.enableSeveritySummary = enableSeveritySummary;
    }

    public void setMinSeverity(Severity minSeverity) {
        this.minSeverity = minSeverity;
    }

    public String getXrefLocation() {
        return this.xrefLocation;
    }

    public void setXrefLocation(String xrefLocation) {
        this.xrefLocation = xrefLocation;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getComparisonVersion() {
        return this.comparisonVersion;
    }

    public void setComparisonVersion(String comparisonVersion) {
        this.comparisonVersion = comparisonVersion;
    }

    private static class ApiChange {
        private Difference difference;
        private List<ApiDifference> apiDifferences = new LinkedList<ApiDifference>();
        private String from;
        private String to;

        private ApiChange() {
        }

        private String getAffectedClass() {
            return this.apiDifferences.get(0).getAffectedClass();
        }

        private String getFrom() {
            return this.from;
        }

        private String getTo() {
            return this.to;
        }

        private void computeFields() {
            ApiDifference apiDiff = this.apiDifferences.get(0);
            String methodSig = apiDiff.getAffectedMethod();
            this.from = apiDiff.getAffectedMethod() != null ? apiDiff.getAffectedMethod() : (apiDiff.getAffectedField() != null ? apiDiff.getAffectedField() : "");
            this.to = this.difference.getTo();
            switch (this.difference.getDifferenceType()) {
                case 6004: {
                    String clirrReport = apiDiff.getReport(new MessageTranslator());
                    Pattern p = Pattern.compile("Changed type of field ([^ ]+) from ([^ ]+) to ([^ ]+)");
                    Matcher m = p.matcher(clirrReport);
                    if (!m.find()) break;
                    this.from = m.group(2) + ' ' + m.group(1);
                    this.to = m.group(3) + ' ' + m.group(1);
                    break;
                }
                case 7005: {
                    this.to = Difference.getNewMethodSignature(methodSig, this.apiDifferences);
                    break;
                }
                case 7006: {
                    String clirrReport = apiDiff.getReport(new MessageTranslator());
                    Pattern p = Pattern.compile("Return type of method '[^']+' has been changed to (.+)");
                    Matcher m = p.matcher(clirrReport);
                    if (!m.find()) break;
                    int openParIdx = methodSig.indexOf(40);
                    int afterReturnTypeIdx = methodSig.lastIndexOf(32, openParIdx);
                    int beforeReturnTypeIdx = methodSig.lastIndexOf(32, afterReturnTypeIdx - 1);
                    this.to = new StringBuilder().append(methodSig, 0, beforeReturnTypeIdx + 1).append(m.group(1)).append(methodSig, afterReturnTypeIdx, methodSig.length()).toString();
                    break;
                }
            }
        }
    }

    private static final class ApiChangeComparator
    implements Comparator<ApiChange> {
        private ApiChangeComparator() {
        }

        @Override
        public int compare(ApiChange c1, ApiChange c2) {
            int cmp = c1.getAffectedClass().compareTo(c2.getAffectedClass());
            if (cmp == 0 && (cmp = c1.getFrom().compareTo(c2.getFrom())) == 0) {
                return c1.getTo().compareTo(c2.getTo());
            }
            return cmp;
        }
    }

    private static final class JustificationComparator
    implements Comparator<Difference> {
        private JustificationComparator() {
        }

        @Override
        public int compare(Difference o1, Difference o2) {
            return o1.getJustification().compareTo(o2.getJustification());
        }
    }
}

