/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="add-test-source", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, threadSafe=true)
public class AddTestSourceMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File[] sources;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="buildhelper.addtestsource.skip", defaultValue="false")
    private boolean skipAddTestSource;
    @Parameter(property="buildhelper.addtestsource.skipIfMissing", defaultValue="false")
    private boolean skipAddTestSourceIfMissing;

    public void execute() {
        if (this.skipAddTestSource) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Skipping plugin execution!");
            }
            return;
        }
        for (File source : this.sources) {
            if (this.skipAddTestSourceIfMissing && !source.exists()) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Skipping directory: " + source + ", because it does not exist."));
                continue;
            }
            this.project.addTestCompileSourceRoot(source.getAbsolutePath());
            if (!this.getLog().isInfoEnabled()) continue;
            this.getLog().info((CharSequence)("Test Source directory: " + source + " added."));
        }
    }
}

