/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.daemontools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerator;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public class DaemonToolsDaemonGenerator
extends AbstractLogEnabled
implements DaemonGenerator {
    @Override
    public void generate(DaemonGenerationRequest request) throws DaemonGeneratorException {
        Daemon daemon = request.getDaemon();
        try {
            FileUtils.forceMkdir((File)request.getOutputDirectory());
        }
        catch (IOException e) {
            throw new DaemonGeneratorException("Error creating output directory: " + request.getOutputDirectory(), e);
        }
        File envDir = new File(request.getOutputDirectory(), "env");
        envDir.mkdir();
        this.copyEnvFile("JAVA_HOME", envDir);
        this.copyEnvFile("USER", envDir);
        File logDir = new File(request.getOutputDirectory(), "logs");
        logDir.mkdir();
        File serviceDir = new File(request.getOutputDirectory(), "service");
        serviceDir.mkdir();
        InputStream in = this.getClass().getResourceAsStream("run.sh.template");
        if (in == null) {
            throw new DaemonGeneratorException("Could not load template.");
        }
        InputStreamReader reader = new InputStreamReader(in);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("MAINCLASS", daemon.getMainClass());
        context.put("NAME", daemon.getId());
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)reader, context, "@", "@");
        File runFile = new File(request.getOutputDirectory(), "run");
        FileWriter out = null;
        try {
            out = new FileWriter(runFile);
            IOUtil.copy((Reader)interpolationFilterReader, (Writer)out);
        }
        catch (IOException e) {
            throw new DaemonGeneratorException("Error writing output file: " + runFile.getAbsolutePath(), e);
        }
        finally {
            IOUtil.close((Reader)interpolationFilterReader);
            IOUtil.close((Writer)out);
        }
    }

    private void copyEnvFile(String envName, File envDir) throws DaemonGeneratorException {
        FileWriter out = null;
        InputStreamReader envReader = null;
        File envFile = new File(envDir, envName);
        try {
            envReader = new InputStreamReader(this.getClass().getResourceAsStream("env/" + envName), "UTF-8");
            out = new FileWriter(envFile);
            IOUtil.copy((Reader)envReader, (Writer)out);
        }
        catch (IOException e) {
            try {
                throw new DaemonGeneratorException("Error writing environment file: " + envFile, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(envReader);
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((Reader)envReader);
        IOUtil.close((Writer)out);
    }
}

