/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.appassembler.AbstractScriptGeneratorMojo;
import org.codehaus.mojo.appassembler.Daemon;
import org.codehaus.mojo.appassembler.GeneratorConfiguration;
import org.codehaus.mojo.appassembler.JvmSettings;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="generate-daemons", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class GenerateDaemonsMojo
extends AbstractScriptGeneratorMojo {
    @Parameter(defaultValue="${basedir}", required=true)
    private File basedir;
    @Parameter(required=true)
    private Set<Daemon> daemons;
    @Parameter
    private JvmSettings defaultJvmSettings;
    @Parameter(defaultValue="lib")
    private String repositoryName;
    @Parameter(defaultValue="${project.build.directory}/generated-resources/appassembler", required=true)
    private File target;
    @Parameter(defaultValue="false")
    private boolean useDaemonIdAsWrapperConfName;
    @Parameter(defaultValue="false")
    private boolean useDaemonIdAsWrapperExePrefixName;
    @Parameter(property="externalDeltaPackDirectory")
    private File externalDeltaPackDirectory;
    @Parameter(property="preWrapperConf")
    private File preWrapperConf;
    @Parameter
    private String binFileName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.useWildcardClassPath && !this.repositoryLayout.equalsIgnoreCase("flat")) {
            throw new MojoExecutionException("The useWildcardClassPath works only in combination with repositoryLayout flat.");
        }
        if (this.preClean) {
            this.removeDirectory(this.target);
        }
        for (Daemon daemon : this.daemons) {
            File descriptor = null;
            if (!StringUtils.isEmpty((String)daemon.getDescriptor())) {
                descriptor = new File(this.basedir, daemon.getDescriptor());
            }
            org.codehaus.mojo.appassembler.model.JvmSettings modelJvmSettings = null;
            if (this.defaultJvmSettings != null) {
                modelJvmSettings = this.convertJvmSettings(this.defaultJvmSettings);
            }
            ArtifactRepositoryLayout artifactRepositoryLayout = this.getArtifactRepositoryLayout();
            org.codehaus.mojo.appassembler.model.Daemon modelDaemon = this.convertDaemon(daemon, modelJvmSettings);
            if (this.licenseHeaderFile != null && modelDaemon.getLicenseHeaderFile() == null) {
                modelDaemon.setLicenseHeaderFile(this.licenseHeaderFile.toString());
            }
            modelDaemon.setConfigurationDirectory(this.configurationDirectory);
            modelDaemon.setEnvironmentSetupFileName(this.environmentSetupFileName);
            modelDaemon.setRepositoryName(this.repositoryName);
            modelDaemon.setUseTimestampInSnapshotFileName(this.useTimestampInSnapshotFileName);
            modelDaemon.setUseDaemonIdAsWrapperConfName(this.useDaemonIdAsWrapperConfName);
            modelDaemon.setUseDaemonIdAsWrapperExePrefixName(this.useDaemonIdAsWrapperExePrefixName);
            modelDaemon.setUseWildcardClassPath(this.useWildcardClassPath);
            if (this.endorsedDir != null) {
                modelDaemon.setEndorsedDir(this.endorsedDir);
            }
            if (this.preWrapperConf != null) {
                modelDaemon.setPreWrapperConf(this.preWrapperConf.getAbsolutePath());
            }
            if (this.unixScriptTemplate != null) {
                modelDaemon.setUnixScriptTemplate(this.unixScriptTemplate);
            }
            if (this.windowsScriptTemplate != null) {
                modelDaemon.setWindowsScriptTemplate(this.windowsScriptTemplate);
            }
            if (this.externalDeltaPackDirectory != null) {
                modelDaemon.setExternalDeltaPackDirectory(this.externalDeltaPackDirectory.getAbsolutePath());
            }
            for (String platform : daemon.getPlatforms()) {
                File output = new File(this.target, platform);
                DaemonGenerationRequest request = new DaemonGenerationRequest();
                request.setPlatform(platform);
                request.setStubDescriptor(descriptor);
                request.setStubDaemon(modelDaemon);
                request.setOutputDirectory(output);
                request.setMavenProject(this.mavenProject);
                request.setLocalRepository(this.localRepository);
                request.setRepositoryLayout(artifactRepositoryLayout);
                request.setOutputFileNameMapping(this.outputFileNameMapping);
                request.setBinScriptName(this.binFileName);
                try {
                    this.daemonGeneratorService.generateDaemon(request);
                }
                catch (DaemonGeneratorException e) {
                    throw new MojoExecutionException("Error while generating daemon.", (Exception)e);
                }
                File outputDirectory = new File(request.getOutputDirectory(), daemon.getId());
                super.installDependencies(outputDirectory.getAbsolutePath(), this.repositoryName);
                if (this.preAssembleDirectory != null && this.preAssembleDirectory.isDirectory()) {
                    this.doCopyPreAssembleDirectory(outputDirectory.getAbsolutePath());
                }
                if (this.copyConfigurationDirectory && this.configurationSourceDirectory.isDirectory()) {
                    this.doCopyConfigurationDirectory(outputDirectory.getAbsolutePath());
                }
                this.doCreateExtraDirectories(outputDirectory);
            }
        }
    }

    private org.codehaus.mojo.appassembler.model.Daemon convertDaemon(Daemon daemon, org.codehaus.mojo.appassembler.model.JvmSettings modelJvmSettings) {
        org.codehaus.mojo.appassembler.model.Daemon modelDaemon = new org.codehaus.mojo.appassembler.model.Daemon();
        modelDaemon.setId(daemon.getId());
        modelDaemon.setMainClass(daemon.getMainClass());
        modelDaemon.setWrapperMainClass(daemon.getWrapperMainClass());
        modelDaemon.setWrapperLogFile(daemon.getWrapperLogFile());
        modelDaemon.setCommandLineArguments(daemon.getCommandLineArguments());
        modelDaemon.setConfigurationDirectory(daemon.getConfigurationDirectory());
        modelDaemon.setLicenseHeaderFile(daemon.getLicenseHeaderFile());
        modelDaemon.setShowConsoleWindow(daemon.isShowConsoleWindow());
        modelDaemon.setEnvironmentSetupFileName(daemon.getEnvironmentSetupFileName());
        modelDaemon.setRepositoryName(daemon.getRepositoryName());
        modelDaemon.setEndorsedDir(daemon.getEndorsedDir());
        modelDaemon.setPreWrapperConf(daemon.getPreWrapperConf());
        modelDaemon.setName(daemon.getName());
        modelDaemon.setLongName(daemon.getLongName());
        if (daemon.getJvmSettings() != null) {
            modelDaemon.setJvmSettings(this.convertJvmSettings(daemon.getJvmSettings()));
        } else {
            modelDaemon.setJvmSettings(modelJvmSettings);
        }
        if (daemon.getGeneratorConfigurations() != null) {
            modelDaemon.setGeneratorConfigurations(this.convertGeneratorConfigurations(daemon.getGeneratorConfigurations()));
        }
        return modelDaemon;
    }

    private List<org.codehaus.mojo.appassembler.model.GeneratorConfiguration> convertGeneratorConfigurations(List<GeneratorConfiguration> generatorConfigurations) {
        ArrayList<org.codehaus.mojo.appassembler.model.GeneratorConfiguration> value = new ArrayList<org.codehaus.mojo.appassembler.model.GeneratorConfiguration>(generatorConfigurations.size());
        for (GeneratorConfiguration config : generatorConfigurations) {
            value.add(this.convertGeneratorConfiguration(config));
        }
        return value;
    }

    private org.codehaus.mojo.appassembler.model.GeneratorConfiguration convertGeneratorConfiguration(GeneratorConfiguration config) {
        org.codehaus.mojo.appassembler.model.GeneratorConfiguration value = new org.codehaus.mojo.appassembler.model.GeneratorConfiguration();
        value.setGenerator(config.getGenerator());
        value.setConfiguration(config.getConfiguration());
        value.setIncludes(config.getIncludes());
        return value;
    }

    private org.codehaus.mojo.appassembler.model.JvmSettings convertJvmSettings(JvmSettings jvmSettings) {
        org.codehaus.mojo.appassembler.model.JvmSettings modelJvmSettings = new org.codehaus.mojo.appassembler.model.JvmSettings();
        modelJvmSettings.setInitialMemorySize(jvmSettings.getInitialMemorySize());
        modelJvmSettings.setMaxMemorySize(jvmSettings.getMaxMemorySize());
        modelJvmSettings.setMaxStackSize(jvmSettings.getMaxStackSize());
        if (jvmSettings.getSystemProperties() == null) {
            modelJvmSettings.setSystemProperties(new ArrayList());
        } else {
            modelJvmSettings.setSystemProperties(Arrays.asList(jvmSettings.getSystemProperties()));
        }
        if (jvmSettings.getExtraArguments() == null) {
            modelJvmSettings.setExtraArguments(new ArrayList());
        } else {
            modelJvmSettings.setExtraArguments(Arrays.asList(jvmSettings.getExtraArguments()));
        }
        return modelJvmSettings;
    }
}

