/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.stax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Named;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JConstructor;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.stax.AbstractStaxGenerator;
import org.codehaus.plexus.util.StringUtils;

@Named(value="stax-serializer")
public class StaxSerializerGenerator
extends AbstractStaxGenerator {
    public void generate(Model model, Map<String, Object> parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateStaxSerializer();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating StAX serializer.", (Throwable)ex);
        }
    }

    private void generateStaxSerializer() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = objectModel.getDefaultPackageName(this.isPackageWithVersion(), this.getGeneratedVersion()) + ".io.stax";
        String className = "IndentingXMLStreamWriter";
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, className);
        JClass jClass = new JClass(packageName + '.' + className);
        jClass.getModifiers().makePackage();
        jClass.addInterface("XMLStreamWriter");
        this.initHeader(jClass);
        this.suppressAllWarnings(objectModel, (JStructure)jClass);
        jClass.addImport("javax.xml.namespace.NamespaceContext");
        jClass.addImport("javax.xml.stream.XMLStreamException");
        jClass.addImport("javax.xml.stream.XMLStreamWriter");
        this.addField(jClass, "XMLStreamWriter", "out", null, false);
        this.addField(jClass, "String", "NEW_LINE", "\"\\n\"", true);
        this.addField(jClass, "String", "newLine", "NEW_LINE", false);
        this.addField(jClass, "String", "indent", "\"  \"", false);
        this.addField(jClass, "char[]", "linePrefix", "\"                        \".toCharArray()", false);
        this.addField(jClass, "int", "depth", null, false);
        this.addField(jClass, "byte[]", "states", "{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }", false);
        this.addField(jClass, "int", "ELEMENT_HAS_DATA", "0x1", true);
        this.addField(jClass, "int", "ELEMENT_HAS_MARKUP", "0x2", true);
        JConstructor constructor = jClass.createConstructor();
        constructor.addParameter(new JParameter(new JType("XMLStreamWriter"), "out"));
        constructor.getSourceCode().add("this.out = out;");
        JMethod jMethod = new JMethod("setNewLine");
        jMethod.addParameter(new JParameter(new JType("String"), "newLine"));
        jMethod.getSourceCode().add("this.newLine = newLine;");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("getLineSeparator", new JType("String"), null);
        JSourceCode sc = jMethod.getSourceCode();
        sc.add("try");
        sc.add("{");
        sc.addIndented("return System.getProperty( \"line.separator\", NEW_LINE );");
        sc.add("}");
        sc.add("catch ( Exception e )");
        sc.add("{");
        sc.addIndented("return NEW_LINE;");
        sc.add("}");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("beforeMarkup");
        jMethod.getModifiers().makePrivate();
        sc = jMethod.getSourceCode();
        sc.add("int state = states[depth];");
        sc.add("if ( ( state & ELEMENT_HAS_DATA ) == 0 && ( depth > 0 || state != 0 ) )");
        sc.add("{");
        sc.indent();
        sc.add("newLine( depth );");
        sc.add("if ( depth > 0 && indent.length() > 0 )");
        sc.add("{");
        sc.addIndented("afterMarkup();");
        sc.add("}");
        sc.unindent();
        sc.add("}");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("afterMarkup");
        jMethod.getModifiers().makePrivate();
        jMethod.getSourceCode().add("states[depth] |= ELEMENT_HAS_MARKUP;");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("beforeStartElement");
        jMethod.getModifiers().makePrivate();
        sc = jMethod.getSourceCode();
        sc.add("beforeMarkup();");
        sc.add("if ( states.length <= depth + 1 )");
        sc.add("{");
        sc.indent();
        sc.add("byte[] tmp = new byte[states.length * 2];");
        sc.add("System.arraycopy( states, 0, tmp, 0, states.length );");
        sc.add("states = tmp;");
        sc.unindent();
        sc.add("}");
        sc.add("states[depth + 1] = 0;");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("afterStartElement");
        jMethod.getModifiers().makePrivate();
        sc = jMethod.getSourceCode();
        sc.add("afterMarkup();");
        sc.add("depth++;");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("beforeEndElement");
        jMethod.getModifiers().makePrivate();
        sc = jMethod.getSourceCode();
        sc.add("if ( depth > 0 && states[depth] == ELEMENT_HAS_MARKUP )");
        sc.add("{");
        sc.addIndented("newLine( depth - 1 );");
        sc.add("}");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("afterEndElement");
        jMethod.getModifiers().makePrivate();
        sc = jMethod.getSourceCode();
        sc.add("if ( depth > 0 )");
        sc.add("{");
        sc.indent();
        sc.add("depth--;");
        sc.add("if ( depth <= 0 )");
        sc.add("{");
        sc.addIndented("newLine( 0 );");
        sc.add("}");
        sc.unindent();
        sc.add("}");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("afterData");
        jMethod.getModifiers().makePrivate();
        jMethod.getSourceCode().add("states[depth] |= ELEMENT_HAS_DATA;");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("newLine");
        jMethod.addParameter(new JParameter(JType.INT, "depth"));
        jMethod.getModifiers().makePrivate();
        sc = jMethod.getSourceCode();
        sc.add("try");
        sc.add("{");
        sc.indent();
        sc.add("out.writeCharacters( newLine );");
        sc.add("int prefixLength = depth * indent.length();");
        sc.add("while ( linePrefix.length < prefixLength )");
        sc.add("{");
        sc.indent();
        sc.add("char[] tmp = new char[linePrefix.length * 2];");
        sc.add("System.arraycopy( linePrefix, 0, tmp, 0, linePrefix.length );");
        sc.add("System.arraycopy( linePrefix, 0, tmp, linePrefix.length, linePrefix.length );");
        sc.add("linePrefix = tmp;");
        sc.unindent();
        sc.add("}");
        sc.add("out.writeCharacters( linePrefix, 0, prefixLength );");
        sc.unindent();
        sc.add("}");
        sc.add("catch ( Exception e )");
        sc.add("{");
        sc.add("}");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("close");
        jMethod.addException(new JClass("XMLStreamException"));
        jMethod.getSourceCode().add("out.close();");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("flush");
        jMethod.addException(new JClass("XMLStreamException"));
        jMethod.getSourceCode().add("out.flush();");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("getNamespaceContext", new JType("NamespaceContext"), null);
        jMethod.getSourceCode().add("return out.getNamespaceContext();");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("getPrefix", new JType("String"), null);
        jMethod.addException(new JClass("XMLStreamException"));
        jMethod.addParameter(StaxSerializerGenerator.param("String", "uri"));
        jMethod.getSourceCode().add("return out.getPrefix( uri );");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("getProperty", new JType("Object"), null);
        jMethod.addException(new JClass("IllegalArgumentException"));
        jMethod.addParameter(StaxSerializerGenerator.param("String", "name"));
        jMethod.getSourceCode().add("return out.getProperty( name );");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("setDefaultNamespace");
        jMethod.addException(new JClass("XMLStreamException"));
        jMethod.addParameter(StaxSerializerGenerator.param("String", "uri"));
        jMethod.getSourceCode().add("out.setDefaultNamespace( uri );");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("setNamespaceContext");
        jMethod.addException(new JClass("XMLStreamException"));
        jMethod.addParameter(StaxSerializerGenerator.param("NamespaceContext", "context"));
        jMethod.getSourceCode().add("out.setNamespaceContext( context );");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("setPrefix");
        jMethod.addException(new JClass("XMLStreamException"));
        jMethod.addParameter(StaxSerializerGenerator.param("String", "prefix"));
        jMethod.addParameter(StaxSerializerGenerator.param("String", "uri"));
        jMethod.getSourceCode().add("out.setPrefix( prefix, uri );");
        jClass.addMethod(jMethod);
        this.add(jClass, "Attribute", null, null, StaxSerializerGenerator.param("String", "localName"), StaxSerializerGenerator.param("String", "value"));
        this.add(jClass, "Attribute", null, null, StaxSerializerGenerator.param("String", "namespaceURI"), StaxSerializerGenerator.param("String", "localName"), StaxSerializerGenerator.param("String", "value"));
        this.add(jClass, "Attribute", null, null, StaxSerializerGenerator.param("String", "prefix"), StaxSerializerGenerator.param("String", "namespaceURI"), StaxSerializerGenerator.param("String", "localName"), StaxSerializerGenerator.param("String", "value"));
        this.add(jClass, "CData", null, "Data", StaxSerializerGenerator.param("String", "data"));
        this.add(jClass, "Characters", null, "Data", StaxSerializerGenerator.param("String", "text"));
        this.add(jClass, "Characters", null, "Data", StaxSerializerGenerator.param("char[]", "text"), StaxSerializerGenerator.param("int", "start"), StaxSerializerGenerator.param("int", "len"));
        this.add(jClass, "Comment", "Markup", "Markup", StaxSerializerGenerator.param("String", "data"));
        this.add(jClass, "DTD", "Markup", "Markup", StaxSerializerGenerator.param("String", "dtd"));
        this.add(jClass, "DefaultNamespace", null, null, StaxSerializerGenerator.param("String", "namespaceURI"));
        this.add(jClass, "EmptyElement", "Markup", "Markup", StaxSerializerGenerator.param("String", "localName"));
        this.add(jClass, "EmptyElement", "Markup", "Markup", StaxSerializerGenerator.param("String", "namespaceURI"), StaxSerializerGenerator.param("String", "localName"));
        this.add(jClass, "EmptyElement", "Markup", "Markup", StaxSerializerGenerator.param("String", "prefix"), StaxSerializerGenerator.param("String", "namespaceURI"), StaxSerializerGenerator.param("String", "localName"));
        this.add(jClass, "EndDocument", null, null, new JParameter[0]);
        this.add(jClass, "EndElement", "EndElement", "EndElement", new JParameter[0]);
        this.add(jClass, "EntityRef", null, "Data", StaxSerializerGenerator.param("String", "name"));
        this.add(jClass, "Namespace", null, null, StaxSerializerGenerator.param("String", "prefix"), StaxSerializerGenerator.param("String", "namespaceURI"));
        this.add(jClass, "ProcessingInstruction", "Markup", "Markup", StaxSerializerGenerator.param("String", "target"));
        this.add(jClass, "ProcessingInstruction", "Markup", "Markup", StaxSerializerGenerator.param("String", "target"), StaxSerializerGenerator.param("String", "data"));
        this.add(jClass, "StartDocument", "Markup", "Markup", new JParameter[0]);
        this.add(jClass, "StartDocument", "Markup", "Markup", StaxSerializerGenerator.param("String", "version"));
        this.add(jClass, "StartDocument", "Markup", "Markup", StaxSerializerGenerator.param("String", "encoding"), StaxSerializerGenerator.param("String", "version"));
        this.add(jClass, "StartElement", "StartElement", "StartElement", StaxSerializerGenerator.param("String", "localName"));
        this.add(jClass, "StartElement", "StartElement", "StartElement", StaxSerializerGenerator.param("String", "namespaceURI"), StaxSerializerGenerator.param("String", "localName"));
        this.add(jClass, "StartElement", "StartElement", "StartElement", StaxSerializerGenerator.param("String", "prefix"), StaxSerializerGenerator.param("String", "localName"), StaxSerializerGenerator.param("String", "namespaceURI"));
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void addField(JClass jClass, String fieldType, String fieldName, String initializer, boolean constant) {
        JField jField = new JField(new JType(fieldType), fieldName);
        jField.setInitString(initializer);
        if (constant) {
            jField.getModifiers().setFinal(true);
            jField.getModifiers().setStatic(true);
        }
        jClass.addField(jField);
    }

    private void add(JClass jClass, String name, String before, String after, JParameter ... params) {
        ArrayList<String> names = new ArrayList<String>();
        JMethod jMethod = new JMethod("write" + name);
        jMethod.addException(new JClass("XMLStreamException"));
        for (JParameter param : params) {
            jMethod.addParameter(param);
            names.add(param.getName());
        }
        JSourceCode sc = jMethod.getSourceCode();
        if (before != null) {
            sc.add("before" + before + "();");
        }
        sc.add("out.write" + name + "( " + StringUtils.join(names.iterator(), (String)", ") + " );");
        if (after != null) {
            sc.add("after" + after + "();");
        }
        jClass.addMethod(jMethod);
    }

    private static JParameter param(String type, String name) {
        return new JParameter(new JType(type), name);
    }
}

