/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.jsonschema;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.ModelloGenerator;
import org.codehaus.modello.plugins.xml.AbstractXmlJavaGenerator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ModelloGenerator.class, hint="jsonschema")
public final class JsonSchemaGenerator
extends AbstractXmlJavaGenerator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateJsonSchema(parameters);
        }
        catch (IOException ioe) {
            throw new ModelloException("Exception while generating JSON Schema.", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateJsonSchema(Properties parameters) throws IOException, ModelloException {
        String schemaFileName;
        Model objectModel = this.getModel();
        File directory = this.getOutputDirectory();
        if (this.isPackageWithVersion()) {
            directory = new File(directory, this.getGeneratedVersion().toString());
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File schemaFile = (schemaFileName = parameters.getProperty("modello.output.jsonschema.file")) != null ? new File(directory, schemaFileName) : new File(directory, objectModel.getId() + "-" + this.getGeneratedVersion() + ".schema.json");
        JsonGenerator generator = new JsonFactory().enable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT).enable(JsonGenerator.Feature.AUTO_CLOSE_TARGET).enable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM).enable(JsonWriteFeature.ESCAPE_NON_ASCII.mappedFeature()).enable(JsonWriteFeature.QUOTE_FIELD_NAMES.mappedFeature()).enable(JsonWriteFeature.QUOTE_FIELD_NAMES.mappedFeature()).disable(JsonWriteFeature.WRITE_NUMBERS_AS_STRINGS.mappedFeature()).createGenerator(this.newWriter(schemaFile.toPath(), StandardCharsets.UTF_8));
        generator.useDefaultPrettyPrinter();
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        try {
            generator.writeStartObject();
            generator.writeStringField("$schema", "http://json-schema.org/draft-04/schema#");
            this.writeClassDocumentation(generator, root, true);
            generator.writeObjectFieldStart("definitions");
            for (ModelClass current : objectModel.getClasses(this.getGeneratedVersion())) {
                if (root.equals((Object)current)) continue;
                this.writeClassDocumentation(generator, current, false);
            }
            generator.writeEndObject();
            generator.writeEndObject();
        }
        finally {
            generator.close();
        }
    }

    private void writeClassDocumentation(JsonGenerator generator, ModelClass modelClass, boolean isRoot) throws IOException {
        if (!isRoot) {
            generator.writeObjectFieldStart(modelClass.getName());
        }
        generator.writeStringField("id", modelClass.getName() + '#');
        JsonSchemaGenerator.writeDescriptionField(generator, modelClass.getDescription());
        this.writeTypeField(generator, "object");
        generator.writeObjectFieldStart("properties");
        LinkedList<String> required = new LinkedList<String>();
        ModelClass reference = modelClass;
        while (reference != null) {
            for (ModelField modelField : reference.getFields(this.getGeneratedVersion())) {
                if (modelField.isRequired()) {
                    required.add(modelField.getName());
                }
                generator.writeObjectFieldStart(modelField.getName());
                JsonSchemaGenerator.writeDescriptionField(generator, modelField.getDescription());
                if (modelField instanceof ModelAssociation) {
                    ModelAssociation modelAssociation = (ModelAssociation)modelField;
                    if (modelAssociation.isOneMultiplicity()) {
                        this.writeTypeField(generator, modelAssociation.getType());
                    } else {
                        this.writeTypeField(generator, "array");
                        generator.writeObjectFieldStart("items");
                        String type = modelAssociation.getType();
                        String toType = modelAssociation.getTo();
                        if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                            this.writeTypeField(generator, toType);
                        } else {
                            this.writeTypeField(generator, "object");
                            generator.writeObjectFieldStart("properties");
                            XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)modelAssociation.getAssociationMetadata(XmlAssociationMetadata.ID);
                            if (xmlAssociationMetadata.isMapExplode()) {
                                generator.writeObjectFieldStart("key");
                                this.writeTypeField(generator, "string");
                                generator.writeEndObject();
                                generator.writeObjectFieldStart("value");
                                this.writeTypeField(generator, toType);
                                generator.writeEndObject();
                                generator.writeEndObject();
                                generator.writeArrayFieldStart("required");
                                generator.writeString("key");
                                generator.writeString("value");
                                generator.writeEndArray();
                            } else {
                                generator.writeObjectFieldStart("*");
                                this.writeTypeField(generator, toType);
                                generator.writeEndObject();
                            }
                        }
                        generator.writeEndObject();
                    }
                } else {
                    this.writeTypeField(generator, modelField.getType());
                }
                generator.writeEndObject();
            }
            if (reference.hasSuperClass()) {
                reference = reference.getModel().getClass(reference.getSuperClass(), this.getGeneratedVersion());
                continue;
            }
            reference = null;
        }
        generator.writeEndObject();
        if (!required.isEmpty()) {
            generator.writeArrayFieldStart("required");
            for (String requiredField : required) {
                generator.writeString(requiredField);
            }
            generator.writeEndArray();
        }
        if (!isRoot) {
            generator.writeEndObject();
        }
    }

    private static void writeDescriptionField(JsonGenerator generator, String description) throws IOException {
        if (!StringUtils.isEmpty((String)description)) {
            generator.writeStringField("description", description);
        }
    }

    private void writeTypeField(JsonGenerator generator, String type) throws IOException {
        if (this.isClassInModel(type, this.getModel())) {
            generator.writeStringField("$ref", "#/definitions/" + type);
            return;
        }
        if ("boolean".equals(type) || "Boolean".equals(type)) {
            type = "boolean";
        } else if ("int".equals(type) || "Integer".equals(type)) {
            type = "integer";
        } else if ("short".equals(type) || "Short".equals(type) || "long".equals(type) || "Long".equals(type) || "double".equals(type) || "Double".equals(type) || "float".equals(type) || "Float".equals(type)) {
            type = "number";
        } else if ("String".equals(type)) {
            type = "string";
        }
        generator.writeStringField("type", type);
    }
}

