/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.maven;

import java.io.File;
import java.util.Map;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.modello.maven.AbstractModelloGeneratorMojo;

@Mojo(name="xsd", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ModelloXsdMojo
extends AbstractModelloGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-site/resources/xsd", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean enforceMandatoryElements;
    @Parameter
    private String xsdFileName;

    @Override
    protected String getGeneratorType() {
        return "xsd";
    }

    @Override
    protected void customizeParameters(Map<String, Object> parameters) {
        super.customizeParameters(parameters);
        if (this.xsdFileName != null) {
            parameters.put("modello.output.xsd.file", this.xsdFileName);
        }
        parameters.put("modello.xsd.enforce.mandatory.element", Boolean.toString(this.enforceMandatoryElements));
    }

    @Override
    protected boolean producesCompilableResult() {
        return false;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

