/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config;

import com.izforge.izpack.api.config.Reg;
import com.izforge.izpack.util.config.SingleConfigurableTask;
import java.io.IOException;
import java.util.logging.Logger;

public class RegistryTask
extends SingleConfigurableTask {
    private static final Logger logger = Logger.getLogger(RegistryTask.class.getName());
    protected String key;
    protected String fromKey;

    public void setKey(String key) {
        this.key = key;
    }

    public void setFromKey(String key) {
        this.fromKey = key;
    }

    @Override
    protected void readSourceConfigurable() throws Exception {
        if (this.fromKey != null) {
            try {
                logger.fine("Loading from registry: " + this.fromKey);
                this.fromConfigurable = new Reg(this.fromKey);
            }
            catch (IOException ioe) {
                throw new Exception(ioe.toString());
            }
        }
    }

    @Override
    protected void readConfigurable() throws Exception {
        if (this.key != null) {
            try {
                logger.fine("Loading from registry: " + this.key);
                this.configurable = new Reg(this.key);
            }
            catch (IOException ioe) {
                throw new Exception(ioe.toString());
            }
        }
    }

    @Override
    protected void writeConfigurable() throws Exception {
        if (this.configurable == null) {
            logger.warning("Registry key " + this.key + " did not exist and is not allowed to be created");
            return;
        }
        try {
            Reg r = (Reg)this.configurable;
            r.store();
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
    }

    @Override
    protected void checkAttributes() throws Exception {
        if (this.key == null) {
            throw new Exception("Key attribute must be set");
        }
    }
}

