/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller.resource;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.resource.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;

public class InstallLog {
    private static final String INSTALL_LOG = "install.log";
    private final String installPath;
    private final List<File> files;

    public InstallLog(Resources resources) {
        InputStream in = null;
        InputStreamReader inReader = null;
        try {
            in = resources.getInputStream(INSTALL_LOG);
            inReader = new InputStreamReader(in);
            BufferedReader reader = new BufferedReader(inReader);
            this.installPath = InstallLog.getInstallPath(reader);
            this.files = this.getFiles(reader);
        }
        catch (IOException exception) {
            try {
                throw new IzPackException((Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inReader);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)inReader);
        IOUtils.closeQuietly((InputStream)in);
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public List<File> getInstalled() {
        return this.files;
    }

    public static String getInstallPath(Resources resources) {
        String installPath = null;
        BufferedReader reader = null;
        InputStream in = null;
        try {
            in = resources.getInputStream(INSTALL_LOG);
            reader = new BufferedReader(new InputStreamReader(in));
            installPath = InstallLog.getInstallPath(reader);
        }
        catch (IOException exception) {
            try {
                throw new IzPackException((Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)in);
        return installPath;
    }

    private static String getInstallPath(BufferedReader reader) throws IOException {
        String path = reader.readLine();
        if (path == null || path.trim().isEmpty()) {
            throw new IOException("Cannot determine installation path");
        }
        return path;
    }

    private List<File> getFiles(BufferedReader reader) throws IOException {
        TreeSet files = new TreeSet(Collections.reverseOrder());
        String read = reader.readLine();
        while (read != null) {
            files.add(new File(read));
            read = reader.readLine();
        }
        return new ArrayList<File>(files);
    }
}

