/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.rmic.KaffeRmic;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.taskdefs.rmic.SunRmic;
import org.apache.tools.ant.taskdefs.rmic.WLRmic;

public class RmicAdapterFactory {
    private RmicAdapterFactory() {
    }

    public static RmicAdapter getRmic(String rmicType, Task task) throws BuildException {
        if (rmicType.equalsIgnoreCase("sun")) {
            return new SunRmic();
        }
        if (rmicType.equalsIgnoreCase("kaffe")) {
            return new KaffeRmic();
        }
        if (rmicType.equalsIgnoreCase("weblogic")) {
            return new WLRmic();
        }
        return RmicAdapterFactory.resolveClassName(rmicType);
    }

    private static RmicAdapter resolveClassName(String className) throws BuildException {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            return (RmicAdapter)o;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException(className + " can't be found.", cnfe);
        }
        catch (ClassCastException cce) {
            throw new BuildException(className + " isn't the classname of " + "a rmic adapter.", cce);
        }
        catch (Throwable t) {
            throw new BuildException(className + " caused an interesting " + "exception.", t);
        }
    }
}

