/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.uninstaller.Destroyer;
import com.izforge.izpack.uninstaller.UninstallerFrame;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class UninstallerConsole {
    protected String installPath;
    protected static LocaleDatabase langpack;

    public UninstallerConsole() throws Exception {
        langpack = new LocaleDatabase(UninstallerFrame.class.getResourceAsStream("/langpack.xml"));
        this.getInstallPath();
    }

    private void getInstallPath() throws Exception {
        InputStream inputStream = UninstallerFrame.class.getResourceAsStream("/install.log");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.installPath = bufferedReader.readLine();
        bufferedReader.close();
    }

    public void runUninstall(boolean bl) {
        Destroyer destroyer = new Destroyer(this.installPath, bl, new DestroyerHandler());
        destroyer.start();
    }

    private final class DestroyerHandler
    implements AbstractUIProgressHandler {
        private int AUTO_ANSWER_MODE = -2;

        private DestroyerHandler() {
        }

        private void out(String string) {
            System.out.println(string);
        }

        private boolean askOKCancel(String string, int n) {
            if (n == this.AUTO_ANSWER_MODE) {
                return true;
            }
            boolean bl = n == 1;
            try {
                System.out.print(string + " (Ok/Cancel) [" + (bl ? "O" : "C") + "]:");
                String string2 = this.readln();
                if (string2.toLowerCase().startsWith("o")) {
                    return true;
                }
                if (string2.toLowerCase().startsWith("c")) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == -1) {
                return this.askOKCancel(string, n);
            }
            return bl;
        }

        private int askYesNoCancel(String string, int n) {
            if (n == this.AUTO_ANSWER_MODE) {
                return 47;
            }
            boolean bl = n == 1;
            try {
                System.out.print(string + " (Yes/No/Cancel) [" + (bl ? "Y" : "N") + "]:");
                String string2 = this.readln();
                if (string2.toLowerCase().equals("y")) {
                    return 47;
                }
                if (string2.toLowerCase().equals("n")) {
                    return 49;
                }
                if (string2.toLowerCase().equals("c")) {
                    return 45;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == -1) {
                return this.askYesNoCancel(string, n);
            }
            return n;
        }

        private int askYesNo(String string, int n) {
            if (n == this.AUTO_ANSWER_MODE) {
                return 47;
            }
            boolean bl = n == 1;
            try {
                System.out.print(string + " (Yes/No) [" + (bl ? "Y" : "N") + "]:");
                String string2 = this.readln();
                if (string2.toLowerCase().equals("y")) {
                    return 47;
                }
                if (string2.toLowerCase().equals("n")) {
                    return 49;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == -1) {
                return this.askYesNoCancel(string, n);
            }
            return n;
        }

        private String read() throws Exception {
            byte[] byArray = new byte[]{(byte)System.in.read()};
            return new String(byArray);
        }

        private String readln() throws Exception {
            String string = this.read();
            int n = System.in.available();
            if (n > 0) {
                byte[] byArray = new byte[n];
                System.in.read(byArray);
                string = string + new String(byArray);
            }
            return string.trim();
        }

        public void startAction(String string, int n) {
            this.out("Processing " + string);
        }

        public void stopAction() {
            this.out(langpack.getString("InstallPanel.finished"));
        }

        public void progress(int n, String string) {
            this.out(string);
        }

        public void nextStep(String string, int n, int n2) {
        }

        public void setSubStepNo(int n) {
        }

        public void emitNotification(String string) {
        }

        public boolean emitWarning(String string, String string2) {
            return this.askOKCancel(string + ": " + string2, this.AUTO_ANSWER_MODE);
        }

        public void emitError(String string, String string2) {
            this.out(string + ": " + string2);
        }

        public void emitErrorAndBlockNext(String string, String string2) {
            this.emitError(string, string2);
        }

        public int askQuestion(String string, String string2, int n) {
            return this.askQuestion(string, string2, n, this.AUTO_ANSWER_MODE);
        }

        public int askQuestion(String string, String string2, int n, int n2) {
            int n3 = 0;
            if (n == 37) {
                n3 = this.askYesNo(string + ": " + string2, n2);
            } else if (n == 38) {
                n3 = this.askYesNoCancel(string + ": " + string2, n2);
            }
            return n3;
        }
    }
}

