/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.rule;

import com.izforge.izpack.panels.userinput.field.rule.FieldSpec;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class RuleTextField
extends JTextField {
    private static final long serialVersionUID = 8291069586976953430L;
    private final FieldSpec spec;

    public RuleTextField(FieldSpec spec) {
        super(spec.getColumns() + 1);
        this.spec = spec;
        this.setColumns(spec.getColumns());
        Rule rule = new Rule(spec);
        this.setDocument(rule);
    }

    @Override
    protected Document createDefaultModel() {
        Rule rule = new Rule(this.spec);
        return rule;
    }

    @Override
    public int getColumns() {
        return this.spec.getColumns();
    }

    public int getEditLength() {
        return this.spec.getLength();
    }

    public boolean unlimitedEdit() {
        return this.spec.isUnlimitedLength();
    }

    @Override
    public void setColumns(int columns) {
        super.setColumns(columns + 1);
    }

    class Rule
    extends PlainDocument {
        private static final long serialVersionUID = 3258134643651063862L;
        private final FieldSpec spec;

        public Rule(FieldSpec spec) {
            this.spec = spec;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            int totalSize = this.getLength() + str.length();
            if (this.spec.isUnlimitedLength() || totalSize <= this.spec.getLength()) {
                if (this.spec.validate(str)) {
                    super.insertString(offs, str, a);
                } else {
                    RuleTextField.this.getToolkit().beep();
                }
            } else {
                RuleTextField.this.getToolkit().beep();
            }
        }
    }
}

