/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.rules.process.ExistsCondition;
import com.izforge.izpack.panels.userinput.field.FieldConfig;
import com.izforge.izpack.panels.userinput.field.FieldProcessor;
import com.izforge.izpack.panels.userinput.field.FieldValidator;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.processorclient.ValuesProcessingClient;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Field {
    private String variable;
    private final String summaryKey;
    private final String initialValue;
    private final String defaultValue;
    private final int size;
    private final List<String> packs;
    private final List<OsModel> models;
    private final List<FieldValidator> validators;
    private final List<FieldProcessor> processors;
    private final String label;
    private final String description;
    private final String tooltip;
    private final String condition;
    private final Boolean displayHidden;
    private final String displayHiddenCondition;
    private final Boolean readonly;
    private final String readonlyCondition;
    private final InstallData installData;
    private final boolean omitFromAuto;
    private String unprocessedValue;
    private boolean saving = false;
    private static final Logger logger = Logger.getLogger(Field.class.getName());

    public Field(FieldConfig config, InstallData installData) {
        this.variable = config.getVariable();
        this.summaryKey = config.getSummaryKey();
        this.initialValue = config.getInitialValue();
        this.defaultValue = config.getDefaultValue();
        this.size = config.getSize();
        this.packs = config.getPacks();
        this.models = config.getOsModels();
        this.validators = config.getValidators();
        this.processors = config.getProcessors();
        this.label = config.getLabel();
        this.description = config.getDescription();
        this.displayHidden = config.isDisplayHidden();
        this.displayHiddenCondition = config.getDisplayHiddenCondition();
        this.readonly = config.isReadonly();
        this.readonlyCondition = config.getReadonlyCondition();
        this.tooltip = config.getTooltip();
        this.omitFromAuto = config.getOmitFromAuto();
        this.condition = config.getCondition();
        this.installData = installData;
        if (this.variable != null) {
            this.addExistsCondition();
        }
    }

    public String getVariable() {
        return this.variable;
    }

    public boolean getOmitFromAuto() {
        return this.omitFromAuto;
    }

    public String getSummaryKey() {
        return this.summaryKey;
    }

    public boolean isEffectiveReadonly(boolean defaultFlag, RulesEngine rules) {
        boolean result = this.readonly != null ? this.readonly : (this.readonlyCondition != null && rules.isConditionTrue(this.readonlyCondition) ? rules.isConditionTrue(this.readonlyCondition) : defaultFlag);
        return result;
    }

    public boolean isEffectiveDisplayHidden(boolean defaultFlag, RulesEngine rules) {
        boolean result = this.displayHidden != null ? this.displayHidden : (this.displayHiddenCondition != null && rules.isConditionTrue(this.displayHiddenCondition) ? rules.isConditionTrue(this.displayHiddenCondition) : defaultFlag);
        return result;
    }

    public List<String> getPacks() {
        return this.packs;
    }

    public List<OsModel> getOsModels() {
        return this.models;
    }

    public String getDefaultValue() {
        return this.getDefaultValue(true);
    }

    private String getDefaultValue(boolean translated) {
        String value = this.wrapDefaultValue(this.defaultValue);
        if (translated && value != null) {
            return this.replaceVariables(value);
        }
        return value;
    }

    private String getForcedValue(boolean translated) {
        String value = this.wrapInitialValue(this.initialValue);
        if (translated && value != null) {
            return this.replaceVariables(value);
        }
        return value;
    }

    public String getInitialValue() {
        return this.getInitialValue(true);
    }

    private String getInitialValue(boolean resolve) {
        String result = null;
        if (!this.installData.getVariables().isBlockedVariableName(this.variable)) {
            result = this.getForcedValue(resolve);
        }
        if (result == null) {
            result = this.getValue();
            if (result != null) {
                if (resolve) {
                    result = this.replaceVariables(result);
                }
            } else {
                result = this.getDefaultValue(resolve);
            }
        }
        return result;
    }

    public String getValue() {
        String savedValue = this.installData.getVariable(this.variable);
        if (savedValue == null && this.unprocessedValue != null) {
            this.unprocessedValue = null;
        }
        return this.unprocessedValue == null ? savedValue : this.unprocessedValue;
    }

    public void setSaving(boolean flag) {
        this.saving = flag;
    }

    public void setValue(String value) {
        this.unprocessedValue = value;
        if (this.saving) {
            value = this.process(value);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Field setting variable=" + this.variable + " to value=" + value);
        }
        this.installData.setVariable(this.variable, value);
        this.saving = false;
    }

    public String wrapInitialValue(String originalValue) {
        return originalValue;
    }

    public String wrapDefaultValue(String originalValue) {
        return originalValue;
    }

    public int getSize() {
        return this.size;
    }

    public ValidationStatus validate(String ... values) {
        return this.validate(new ValuesProcessingClient(values));
    }

    public ValidationStatus validate(ValuesProcessingClient values) {
        try {
            for (FieldValidator validator : this.validators) {
                validator.setInstallData(this.installData);
                if (validator.validate(values)) continue;
                return ValidationStatus.failed(validator.getMessage());
            }
        }
        catch (Throwable exception) {
            return ValidationStatus.failed(exception.getMessage());
        }
        return ValidationStatus.success(values.getValues());
    }

    private String process(String ... values) {
        String result = null;
        if (this.processors != null && !this.processors.isEmpty()) {
            for (FieldProcessor processor : this.processors) {
                String toVariable;
                processor.setInstallData(this.installData);
                String processorResult = result == null ? processor.process(values) : processor.process(result);
                String backupVariable = processor.getBackupVariable();
                if (backupVariable != null) {
                    this.installData.setVariable(backupVariable, processor.getOriginalValue());
                }
                if ((toVariable = processor.getToVariable()) != null) {
                    this.installData.setVariable(toVariable, processorResult);
                    processorResult = processor.getOriginalValue();
                }
                result = processorResult;
            }
        } else if (values.length > 0) {
            result = values[0];
        }
        return result;
    }

    public List<FieldProcessor> getProcessors() {
        return this.processors;
    }

    public String getLabel() {
        return this.getLabel(false);
    }

    public String getLabel(boolean resolve) {
        return resolve && this.label != null ? this.replaceVariables(this.label) : this.label;
    }

    public String getDescription() {
        return this.getDescription(false);
    }

    public String getDescription(boolean resolve) {
        return resolve && this.description != null ? this.replaceVariables(this.description) : this.description;
    }

    public String getTooltip() {
        return this.getTooltip(false);
    }

    private String getTooltip(boolean resolve) {
        return resolve && this.tooltip != null ? this.replaceVariables(this.tooltip) : this.tooltip;
    }

    public boolean isConditionTrue() {
        RulesEngine rules = this.getRules();
        return this.condition == null || rules.isConditionTrue(this.condition, this.installData);
    }

    public InstallData getInstallData() {
        return this.installData;
    }

    private RulesEngine getRules() {
        return this.installData.getRules();
    }

    protected String replaceVariables(String value) {
        return this.installData.getVariables().replace(value);
    }

    private void addExistsCondition() {
        RulesEngine rules = this.getRules();
        String conditionId = "izpack.input." + this.variable;
        if (rules != null) {
            if (rules.getCondition(conditionId) == null) {
                ExistsCondition existsCondition = new ExistsCondition();
                existsCondition.setContentType(ExistsCondition.ContentType.VARIABLE);
                existsCondition.setContent(this.variable);
                existsCondition.setId(conditionId);
                existsCondition.setInstallData(this.installData);
                rules.addCondition((Condition)existsCondition);
            } else {
                logger.fine("Condition '" + conditionId + "' for variable '" + this.variable + "' already exists");
            }
        } else {
            logger.fine("Cannot add  condition '" + conditionId + "' for variable '" + this.variable + "'. Rules not supplied");
        }
    }

    public void setVariable(String newVariableName) {
        this.variable = newVariableName;
    }
}

