/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.treepacks;

import com.izforge.izpack.panels.treepacks.CheckBoxNode;
import com.izforge.izpack.panels.treepacks.TreePacksPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class CheckTreeController
extends MouseAdapter {
    JTree tree;
    TreePacksPanel treePacksPanel;
    int checkWidth;

    public CheckTreeController(TreePacksPanel treePacksPanel) {
        this.checkWidth = new JCheckBox().getPreferredSize().width;
        this.tree = treePacksPanel.getTree();
        this.treePacksPanel = treePacksPanel;
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        CheckBoxNode selectedNode = this.handleClick(me);
        if (selectedNode == null) {
            return;
        }
        this.treePacksPanel.setModelValue(selectedNode);
        this.treePacksPanel.updateViewFromModel(this.tree);
    }

    private CheckBoxNode handleClick(MouseEvent mouseEvent) {
        TreePath path = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (path == null) {
            return null;
        }
        CheckBoxNode selectedNode = (CheckBoxNode)path.getLastPathComponent();
        this.treePacksPanel.updateDescriptionArea(selectedNode.getId());
        this.treePacksPanel.updateDependencyArea(selectedNode.getId());
        if (mouseEvent.getX() > this.tree.getPathBounds((TreePath)path).x + this.checkWidth || selectedNode.getPack().isRequired()) {
            return null;
        }
        if (!selectedNode.isEnabled()) {
            return null;
        }
        return selectedNode;
    }
}

