/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.datacheck;

import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Container;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class DataCheckPanel
extends IzPanel {
    private static final long serialVersionUID = 3257848774955905587L;
    static int instanceCount = 0;
    protected int instanceNumber = 0;
    private GUIInstallData installDataGUI;
    JEditorPane staticText;

    public DataCheckPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources) {
        super(panel, parent, installData, resources);
        this.installDataGUI = installData;
        this.instanceNumber = instanceCount++;
        String sInfo = "Debugging installDataGUI.  All GUIInstallData variables and all packs (selected packs are marked).";
        BoxLayout bLayout = new BoxLayout((Container)((Object)this), 1);
        this.setLayout(bLayout);
        JLabel lInfo = new JLabel(sInfo);
        this.add(lInfo);
        this.staticText = new JEditorPane();
        this.staticText.setEditable(false);
        JScrollPane scrollText = new JScrollPane(this.staticText);
        this.add(new JLabel("  "));
        this.add(scrollText);
    }

    public void panelActivate() {
        this.printDebugInfo();
    }

    private String getPackNames(List<Pack> packList) {
        String sOutput = "";
        for (int i = 0; i < packList.size(); ++i) {
            Pack iPack = packList.get(i);
            String pStatus = this.installDataGUI.getSelectedPacks().indexOf(iPack) != -1 ? "Selected" : "Unselected";
            sOutput = sOutput + "\t" + i + ": " + iPack.getName() + " (" + pStatus + ")\n";
        }
        return sOutput;
    }

    private void printDebugInfo() {
        int i = 0;
        String sInfo = "GUIInstallData Variables:\n";
        System.out.println("------------------------Data Check Panel Instance " + this.instanceNumber + "------------------------");
        System.out.println("GUIInstallData Variables:");
        Properties varList = this.installDataGUI.getVariables().getProperties();
        Object[] alphaName = new String[varList.size()];
        Enumeration<?> varNames = varList.propertyNames();
        while (varNames.hasMoreElements()) {
            alphaName[i++] = (String)varNames.nextElement();
        }
        Arrays.sort(alphaName);
        for (i = 0; i < alphaName.length; ++i) {
            sInfo = sInfo + "\tName: " + (String)alphaName[i] + ", Value: " + varList.getProperty((String)alphaName[i]) + "\n";
        }
        sInfo = sInfo + "\nAvailable Packs: \n" + this.getPackNames(this.installDataGUI.getAllPacks()) + "\n";
        System.out.println(sInfo);
        this.staticText.setText(sInfo);
    }

    public boolean isValidated() {
        return true;
    }
}

