/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.event.AbstractProgressInstallerListener;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.util.SummaryProcessor;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class SummaryLoggerInstallerListener
extends AbstractProgressInstallerListener {
    public SummaryLoggerInstallerListener(InstallData installData) {
        super(installData);
    }

    public void afterPacks(List<Pack> packs, ProgressListener listener) {
        if (this.getInstallData() instanceof GUIInstallData) {
            GUIInstallData installData = (GUIInstallData)this.getInstallData();
            if (!installData.isInstallSuccess()) {
                return;
            }
            if (installData.getPanels().isEmpty()) {
                return;
            }
            String path = installData.getInfo().getSummaryLogFilePath();
            if (path == null) {
                return;
            }
            File parent = new File(path = IoHelper.translatePath((String)path, (Variables)installData.getVariables())).getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            String summary = SummaryProcessor.getSummary((GUIInstallData)installData);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(path);
                ((OutputStream)out).write(summary.getBytes("utf-8"));
            }
            catch (IOException exception) {
                try {
                    throw new IzPackException("Failed to write summary to path: " + path, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

