/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.util.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyGraph<Vertex> {
    private Map<Vertex, Set<Vertex>> st = new HashMap<Vertex, Set<Vertex>>();
    private DepthUtils<Vertex> depthUtils = new DepthUtils<Vertex>(this.st);

    public void addEdge(Vertex from, Vertex to) {
        if (!this.st.containsKey(from)) {
            this.addVertex(from);
        }
        if (!this.st.containsKey(to)) {
            this.addVertex(to);
        }
        this.st.get(from).add(to);
    }

    public void addVertex(Vertex v) {
        if (!this.st.containsKey(v)) {
            this.st.put(v, new HashSet());
        }
    }

    public List<Vertex> getOrderedList() {
        return ((DepthUtils)this.depthUtils).getOrderedList();
    }

    public String toString() {
        ((DepthUtils)this.depthUtils).computeDepths();
        StringBuilder s = new StringBuilder();
        for (Vertex v : this.st.keySet()) {
            s.append(String.format("%s: depth=%d [", v, ((DepthUtils)this.depthUtils).getDepth(v)));
            String sep = "";
            for (Vertex w : this.st.get(v)) {
                s.append(sep).append(w);
                sep = ",";
            }
            s.append("]\n");
        }
        return s.toString();
    }

    private class DepthUtils<T>
    implements Comparator<T> {
        private Map<T, Integer> depths = new HashMap<T, Integer>();
        private Map<T, Set<T>> graph;

        public DepthUtils(Map<T, Set<T>> graph) {
            this.graph = graph;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.getDepth(o2).compareTo(this.getDepth(o1));
        }

        private List<T> getOrderedList() {
            this.computeDepths();
            ArrayList<T> nodes = new ArrayList<T>(this.graph.keySet());
            Collections.sort(nodes, this);
            return nodes;
        }

        private void computeDepths() {
            HashSet visited = new HashSet();
            for (Object vertex : DependencyGraph.this.st.keySet()) {
                this.computeDepths(visited, vertex, 0);
            }
        }

        private void computeDepths(HashSet<Vertex> visited, Vertex vertex, int depth) {
            ++depth;
            if (!visited.contains(vertex)) {
                visited.add(vertex);
                DependencyGraph.this.depthUtils.ensureDepth(vertex, depth);
                for (Object descent : (Set)DependencyGraph.this.st.get(vertex)) {
                    this.computeDepths(visited, descent, depth);
                }
                visited.remove(vertex);
            }
        }

        private Integer getDepth(T o) {
            return this.depths.containsKey(o) ? this.depths.get(o) : 0;
        }

        private void ensureDepth(T o, int depth) {
            if (this.getDepth(o) < depth) {
                this.depths.put(o, new Integer(depth));
            }
        }
    }
}

