/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.util;

import com.izforge.izpack.api.exception.IzPackClassNotFoundException;
import com.izforge.izpack.compiler.util.ClassNameMapper;
import java.net.URL;
import java.net.URLClassLoader;

public class CompilerClassLoader
extends URLClassLoader {
    private final ClassNameMapper mapper;

    public CompilerClassLoader(ClassNameMapper mapper) {
        this(CompilerClassLoader.class.getClassLoader(), mapper);
    }

    public CompilerClassLoader(ClassLoader parent, ClassNameMapper mapper) {
        super(new URL[0], parent);
        this.mapper = mapper;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public <T> Class<T> loadClass(String name, Class<T> type) {
        Class<?> result;
        try {
            Class<?> loaded = this.loadClass(name);
            if (!type.isAssignableFrom(loaded)) {
                throw new ClassCastException("Class " + loaded.getName() + " is not a " + type.getName());
            }
            result = loaded;
        }
        catch (ClassNotFoundException exception) {
            throw new IzPackClassNotFoundException(name, exception);
        }
        return result;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String mapping = this.mapper.map(name);
        Class<?> result = mapping != null ? this.loadClass(mapping) : super.findClass(name);
        return result;
    }
}

