/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.resource;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.IXMLParser;
import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.data.PropertyManager;
import com.izforge.izpack.compiler.helper.AssertionHelper;
import com.izforge.izpack.compiler.helper.XmlCompilerHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ResourceFinder {
    private AssertionHelper assertionHelper;
    private CompilerData compilerData;
    private PropertyManager propertyManager;
    private XmlCompilerHelper xmlCompilerHelper;

    public ResourceFinder(AssertionHelper assertionHelper, CompilerData compilerData, PropertyManager propertyManager, XmlCompilerHelper xmlCompilerHelper) {
        this.assertionHelper = assertionHelper;
        this.compilerData = compilerData;
        this.propertyManager = propertyManager;
        this.xmlCompilerHelper = xmlCompilerHelper;
    }

    public URL findProjectResource(String path, String desc, IXMLElement parent) throws CompilerException {
        return this.findProjectResource(new File(this.compilerData.getBasedir()), path, desc, parent);
    }

    public URL findProjectResource(File basedir, String path, String desc, IXMLElement parent) throws CompilerException {
        URL url = null;
        File resource = new File(path);
        if (!resource.isAbsolute()) {
            resource = new File(basedir, path);
        }
        if (!resource.exists()) {
            this.assertionHelper.parseError(parent, desc + " not found: " + resource);
        }
        try {
            url = resource.toURI().toURL();
        }
        catch (MalformedURLException how) {
            this.assertionHelper.parseError(parent, desc + "(" + resource + ")", how);
        }
        return url;
    }

    public URL findIzPackResource(String path, String desc, IXMLElement parent, boolean ignoreWhenNotFound) throws CompilerException {
        URL url = this.getClass().getResource("/" + path);
        if (url == null) {
            File resource = new File(path);
            if (!resource.isAbsolute()) {
                resource = new File(CompilerData.IZPACK_HOME, path);
            }
            if (resource.exists()) {
                try {
                    url = resource.toURI().toURL();
                }
                catch (MalformedURLException how) {
                    this.assertionHelper.parseError(parent, desc + "(" + resource + ")", how);
                }
            } else if (ignoreWhenNotFound) {
                this.assertionHelper.parseWarn(parent, desc + " not found: " + resource);
            } else {
                this.assertionHelper.parseError(parent, desc + " not found: " + resource);
            }
        }
        return url;
    }

    public URL findIzPackResource(String path, String desc, IXMLElement parent) throws CompilerException {
        return this.findIzPackResource(path, desc, parent, false);
    }

    public IXMLElement getXMLTree(IXMLParser parser) throws IOException {
        IXMLElement data;
        if (this.compilerData.getInstallFile() != null) {
            File file = new File(this.compilerData.getInstallFile()).getAbsoluteFile();
            this.assertionHelper.assertIsNormalReadableFile(file, "Configuration file");
            FileInputStream inputStream = new FileInputStream(this.compilerData.getInstallFile());
            data = parser.parse((InputStream)inputStream, file.getAbsolutePath());
            inputStream.close();
            this.propertyManager.setProperty("izpack.file", file.toString());
        } else if (this.compilerData.getInstallText() != null) {
            data = parser.parse(this.compilerData.getInstallText());
        } else {
            throw new CompilerException("Neither install file nor text specified");
        }
        if (!"installation".equalsIgnoreCase(data.getElement().getLocalName())) {
            this.assertionHelper.parseError(data, "this is not an IzPack XML installation file");
        }
        if (!"5.0".equalsIgnoreCase(this.xmlCompilerHelper.requireAttribute(data, "version"))) {
            this.assertionHelper.parseError(data, "the file version is different from the compiler version");
        }
        return data;
    }
}

