/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.packager.impl;

import com.izforge.izpack.api.data.ConsolePrefs;
import com.izforge.izpack.api.data.DynamicInstallerRequirementValidator;
import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.GUIPrefs;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.InstallerRequirement;
import com.izforge.izpack.api.data.PackCompression;
import com.izforge.izpack.api.data.PackInfo;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.listener.PackagerListener;
import com.izforge.izpack.compiler.merge.CompilerPathResolver;
import com.izforge.izpack.compiler.merge.PanelMerge;
import com.izforge.izpack.compiler.packager.IPackager;
import com.izforge.izpack.compiler.util.graph.DependencyGraph;
import com.izforge.izpack.data.CustomData;
import com.izforge.izpack.merge.MergeManager;
import com.izforge.izpack.merge.resolve.MergeableResolver;
import com.izforge.izpack.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public abstract class PackagerBase
implements IPackager {
    public static final String RESOURCES_PATH = "resources/";
    protected static final String PACKSINFO_RESOURCE_PATH = "resources/packs.info";
    private final Properties properties;
    private final PackagerListener listener;
    private final JarOutputStream installerJar;
    private final MergeManager mergeManager;
    private final CompilerPathResolver pathResolver;
    private final MergeableResolver mergeableResolver;
    private final CompilerData compilerData;
    private final RulesEngine rulesEngine;
    private List<InstallerRequirement> installerRequirements;
    private Info info;
    private GUIPrefs guiPrefs;
    private ConsolePrefs consolePrefs;
    private final List<Panel> panelList = new ArrayList<Panel>();
    private final List<PackInfo> packsList = new ArrayList<PackInfo>();
    private final List<String> langpackNameList = new ArrayList<String>();
    private final List<CustomData> customDataList = new ArrayList<CustomData>();
    private final Map<String, URL> installerResourceURLMap = new HashMap<String, URL>();
    private final Map<String, Condition> rules = new HashMap<String, Condition>();
    private final Map<String, List<DynamicVariable>> dynamicVariables = new HashMap<String, List<DynamicVariable>>();
    private final List<DynamicInstallerRequirementValidator> dynamicInstallerRequirements = new ArrayList<DynamicInstallerRequirementValidator>();

    public PackagerBase(Properties properties, PackagerListener listener, JarOutputStream installerJar, MergeManager mergeManager, CompilerPathResolver pathResolver, MergeableResolver mergeableResolver, CompilerData compilerData, RulesEngine rulesEngine) {
        this.properties = properties;
        this.listener = listener;
        this.installerJar = installerJar;
        this.mergeManager = mergeManager;
        this.pathResolver = pathResolver;
        this.mergeableResolver = mergeableResolver;
        this.compilerData = compilerData;
        this.rulesEngine = rulesEngine;
    }

    @Override
    public void addCustomJar(CustomData ca, URL url) {
        if (ca != null) {
            this.customDataList.add(ca);
        }
        if (url != null) {
            this.addJarContent(url);
        }
    }

    @Override
    public void addJarContent(URL jarURL) {
        this.sendMsg("Adding content of jar: " + jarURL.getFile(), 3);
        this.mergeManager.addResourceToMerge(this.mergeableResolver.getMergeableFromURL(jarURL));
    }

    @Override
    public void addLangPack(String iso3, URL xmlURL, URL flagURL) {
        this.sendMsg("Adding langpack: " + iso3, 3);
        this.langpackNameList.add(iso3);
        this.addResource("flag." + iso3, flagURL);
        this.installerResourceURLMap.put("langpacks/" + iso3 + ".xml", xmlURL);
    }

    @Override
    public void addNativeLibrary(String name, URL url) {
        this.sendMsg("Adding native library: " + name, 3);
        this.installerResourceURLMap.put("native/" + name, url);
    }

    @Override
    public void addNativeUninstallerLibrary(CustomData data) {
        this.customDataList.add(data);
    }

    @Override
    public void addPack(PackInfo pack) {
        this.packsList.add(pack);
    }

    @Override
    public void addPanel(Panel panel) {
        this.sendMsg("Adding panel: " + panel.getPanelId() + " :: Classname : " + panel.getClassName());
        this.panelList.add(panel);
        PanelMerge mergeable = this.pathResolver.getPanelMerge(panel.getClassName());
        this.mergeManager.addResourceToMerge((Mergeable)mergeable);
    }

    @Override
    public void addResource(String resId, URL url) {
        this.sendMsg("Adding resource: " + resId, 3);
        URL oldUrl = this.installerResourceURLMap.put(resId, url);
        if (oldUrl != null) {
            throw new CompilerException("Resource '" + resId + "' has been already defined at URL '" + oldUrl + "'" + " and going to be overridden by URL '" + url + "'");
        }
    }

    @Override
    public List<PackInfo> getPacksList() {
        return this.packsList;
    }

    @Override
    public List<Panel> getPanelList() {
        return this.panelList;
    }

    @Override
    public Properties getVariables() {
        return this.properties;
    }

    @Override
    public void setGUIPrefs(GUIPrefs prefs) {
        this.sendMsg("Setting the GUI preferences", 3);
        this.guiPrefs = prefs;
    }

    @Override
    public void setConsolePrefs(ConsolePrefs prefs) {
        this.sendMsg("Setting the console preferences", 3);
        this.consolePrefs = prefs;
    }

    @Override
    public void setInfo(Info info) {
        this.sendMsg("Setting the installer information", 3);
        this.info = info;
    }

    public Info getInfo() {
        return this.info;
    }

    @Override
    public Map<String, Condition> getRules() {
        return this.rules;
    }

    @Override
    public Map<String, List<DynamicVariable>> getDynamicVariables() {
        return this.dynamicVariables;
    }

    @Override
    public List<DynamicInstallerRequirementValidator> getDynamicInstallerRequirements() {
        return this.dynamicInstallerRequirements;
    }

    @Override
    public void addInstallerRequirements(List<InstallerRequirement> conditions) {
        this.installerRequirements = conditions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createInstaller() throws Exception {
        this.info.setInstallerBase(this.compilerData.getOutput().replaceAll(".jar", ""));
        JarOutputStream jarOutputStream = this.getInstallerJar();
        try {
            this.sendStart();
            this.writeInstaller();
            this.sendStop();
            jarOutputStream.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)jarOutputStream);
        }
    }

    protected boolean packSeparateJars() {
        return this.info != null && this.info.getWebDirURL() != null;
    }

    private List<DynamicVariable> buildVariableList() {
        DependencyGraph<DynamicVariable> graph = new DependencyGraph<DynamicVariable>();
        for (List<DynamicVariable> dynVariables : this.dynamicVariables.values()) {
            for (DynamicVariable var : dynVariables) {
                graph.addVertex(var);
                for (String childName : var.getVarRefs(this.rulesEngine)) {
                    List<DynamicVariable> childVars = this.dynamicVariables.get(childName);
                    if (childVars == null) continue;
                    for (DynamicVariable childVar : childVars) {
                        graph.addEdge(var, childVar);
                    }
                }
            }
        }
        return graph.getOrderedList();
    }

    protected void writeInstaller() throws IOException {
        this.writeManifest();
        this.writeSkeletonInstaller();
        this.writeInstallerObject("info", this.info);
        this.writeInstallerObject("vars", this.properties);
        this.writeInstallerObject("ConsolePrefs", this.consolePrefs);
        this.writeInstallerObject("GUIPrefs", this.guiPrefs);
        this.writeInstallerObject("panelsOrder", this.panelList);
        this.writeInstallerObject("customData", this.customDataList);
        this.writeInstallerObject("langpacks.info", this.langpackNameList);
        this.writeInstallerObject("rules", this.rules);
        this.writeInstallerObject("dynvariables", this.buildVariableList());
        this.writeInstallerObject("dynconditions", this.dynamicInstallerRequirements);
        this.writeInstallerObject("installerrequirements", this.installerRequirements);
        this.writeInstallerResources();
        this.writePacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeManifest() throws IOException {
        Manifest manifest = new Manifest(PackagerBase.class.getResourceAsStream("MANIFEST.MF"));
        File tempManifest = File.createTempFile("MANIFEST", ".MF", FileUtils.getTempDirectory());
        tempManifest.deleteOnExit();
        FileOutputStream manifestOutputStream = FileUtils.openOutputStream((File)tempManifest);
        try {
            manifest.write(manifestOutputStream);
            this.mergeManager.addResourceToMerge(tempManifest.getAbsolutePath(), "META-INF/MANIFEST.MF");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)manifestOutputStream);
        }
    }

    protected void writeSkeletonInstaller() {
        this.sendMsg("Copying the skeleton installer", 3);
        this.mergeManager.addResourceToMerge("com/izforge/izpack/installer/");
        this.mergeManager.addResourceToMerge("org/picocontainer/");
        this.mergeManager.addResourceToMerge("com/izforge/izpack/img/");
        this.mergeManager.addResourceToMerge("com/izforge/izpack/bin/icons/");
        this.mergeManager.addResourceToMerge("com/izforge/izpack/api/");
        this.mergeManager.addResourceToMerge("com/izforge/izpack/event/");
        this.mergeManager.addResourceToMerge("com/izforge/izpack/core/");
        this.mergeManager.addResourceToMerge("com/izforge/izpack/data/");
        this.mergeManager.addResourceToMerge("com/izforge/izpack/gui/");
        this.mergeManager.addResourceToMerge("com/izforge/izpack/merge/");
        this.mergeManager.addResourceToMerge("com/izforge/izpack/util/");
        this.mergeManager.addResourceToMerge("com/izforge/izpack/logging/");
        this.mergeManager.addResourceToMerge("com/coi/tools/");
        this.mergeManager.addResourceToMerge("org/apache/commons/io/");
        this.mergeManager.addResourceToMerge("jline/");
        this.mergeManager.addResourceToMerge("org/fusesource/");
        PackCompression comprFormat = this.info.getCompressionFormat();
        switch (comprFormat) {
            case DEFAULT: {
                break;
            }
            default: {
                this.mergeManager.addResourceToMerge("org/apache/commons/compress");
            }
        }
        if (comprFormat == PackCompression.XZ || comprFormat == PackCompression.LZMA) {
            this.mergeManager.addResourceToMerge("org/tukaani/xz");
        }
        this.mergeManager.addResourceToMerge("META-INF/native/");
        this.mergeManager.merge((ZipOutputStream)this.installerJar);
    }

    protected void writeInstallerObject(String entryName, Object object) throws IOException {
        this.installerJar.putNextEntry(new ZipEntry(RESOURCES_PATH + entryName));
        ObjectOutputStream out = new ObjectOutputStream(this.installerJar);
        try {
            out.writeObject(object);
        }
        catch (IOException e) {
            throw new IOException("Error serializing instance of " + object.getClass().getName() + " as entry \"" + entryName + "\"", e);
        }
        finally {
            out.flush();
            this.installerJar.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInstallerResources() throws IOException {
        this.sendMsg("Copying " + this.installerResourceURLMap.size() + " files into installer");
        for (Map.Entry<String, URL> stringURLEntry : this.installerResourceURLMap.entrySet()) {
            URL url = stringURLEntry.getValue();
            InputStream in = null;
            try {
                in = url.openStream();
                ZipEntry newEntry = new ZipEntry(RESOURCES_PATH + stringURLEntry.getKey());
                long dateTime = FileUtil.getFileDateTime((URL)url);
                if (dateTime != -1L) {
                    newEntry.setTime(dateTime);
                }
                try {
                    this.installerJar.putNextEntry(newEntry);
                    IOUtils.copy((InputStream)in, (OutputStream)this.installerJar);
                }
                finally {
                    this.installerJar.closeEntry();
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    protected abstract void writePacks() throws IOException;

    protected JarOutputStream getInstallerJar() {
        return this.installerJar;
    }

    protected void sendMsg(String job) {
        this.sendMsg(job, 2);
    }

    protected void sendMsg(String job, int priority) {
        if (this.listener != null) {
            this.listener.packagerMsg(job, priority);
        }
    }

    protected void sendStart() {
        if (this.listener != null) {
            this.listener.packagerStart();
        }
    }

    protected void sendStop() {
        if (this.listener != null) {
            this.listener.packagerStop();
        }
    }
}

