/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.merge;

import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.installer.gui.IzPanel;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;

public class PanelMerge
implements Mergeable {
    private final List<Mergeable> packageMerge;
    private final Class<IzPanel> panelClass;
    private final FileFilter fileFilter;

    public PanelMerge(final Class<IzPanel> panelClass, List<Mergeable> packageMergeable) {
        this.panelClass = panelClass;
        this.packageMerge = packageMergeable;
        this.fileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getAbsolutePath().contains("/" + panelClass + ".class");
            }
        };
    }

    public List<File> recursivelyListFiles(FileFilter fileFilter) {
        ArrayList<File> result = new ArrayList<File>();
        for (Mergeable mergeable : this.packageMerge) {
            result.addAll(mergeable.recursivelyListFiles(fileFilter));
        }
        return result;
    }

    public File find(FileFilter fileFilter) {
        for (Mergeable mergeable : this.packageMerge) {
            File file = mergeable.find(fileFilter);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public void merge(ZipOutputStream outputStream) {
        for (Mergeable mergeable : this.packageMerge) {
            mergeable.merge(outputStream);
        }
    }

    public Class<IzPanel> getPanelClass() {
        return this.panelClass;
    }

    public String toString() {
        return "PanelMerge{packageMerge=" + this.packageMerge + ", panelClass=" + this.panelClass + ", fileFilter=" + this.fileFilter + '}';
    }
}

