/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.helper;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.lang3.StringUtils;

public class CompilerHelper {
    public String resolveCustomActionsJarPath(String name) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("bin/customActions/");
        stringBuilder.append("izpack");
        stringBuilder.append((CharSequence)this.convertNameToDashSeparated(name));
        stringBuilder.append(".jar");
        return stringBuilder.toString();
    }

    public StringBuilder convertNameToDashSeparated(String name) {
        StringBuilder res = new StringBuilder();
        for (String part : StringUtils.splitByCharacterTypeCamelCase((String)name)) {
            res.append('-');
            res.append(part.toLowerCase());
        }
        return res;
    }

    public List<String> getContainedFilePaths(URL url) throws IOException {
        ZipEntry zentry;
        JarInputStream jis = new JarInputStream(url.openStream());
        ArrayList<String> fullNames = new ArrayList<String>();
        while ((zentry = jis.getNextEntry()) != null) {
            String name = zentry.getName();
            if (zentry.isDirectory()) continue;
            fullNames.add(name);
        }
        jis.close();
        return fullNames;
    }
}

