/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.helper;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.exception.CompilerException;
import java.io.File;
import java.util.logging.Logger;

public class AssertionHelper {
    private static final Logger logger = Logger.getLogger(AssertionHelper.class.getName());
    private String parsedFile;

    public AssertionHelper(String parsedFile) {
        this.parsedFile = parsedFile;
    }

    public void parseError(String message) throws CompilerException {
        throw new CompilerException(this.parsedFile + ":" + message);
    }

    public void parseError(IXMLElement parent, String message) throws CompilerException {
        throw new CompilerException(this.parsedFile + ":" + parent.getLineNr() + ": " + message);
    }

    public void parseError(IXMLElement parent, String message, Throwable cause) throws CompilerException {
        throw new CompilerException(this.parsedFile + ":" + parent.getLineNr() + ": " + message, cause);
    }

    public void parseWarn(IXMLElement parent, String message) {
        logger.warning(this.parsedFile + ":" + parent.getLineNr() + ": " + message);
    }

    public void assertIsNormalReadableFile(File fileToCheck, String fileDescription) throws CompilerException {
        if (fileToCheck != null) {
            if (!fileToCheck.exists()) {
                throw new CompilerException(fileDescription + " does not exist: " + fileToCheck);
            }
            if (!fileToCheck.isFile()) {
                throw new CompilerException(fileDescription + " is not a regular file: " + fileToCheck);
            }
            if (!fileToCheck.canRead()) {
                throw new CompilerException(fileDescription + " is not readable by application: " + fileToCheck);
            }
        }
    }
}

