/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.container.provider;

import com.izforge.izpack.compiler.data.CompilerData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.picocontainer.injectors.Provider;

public class JarOutputStreamProvider
implements Provider {
    public JarOutputStream provide(CompilerData compilerData) {
        File file = new File(compilerData.getOutput());
        JarOutputStream jarOutputStream = null;
        FileOutputStream fileOutputStream = null;
        FileUtils.deleteQuietly((File)file);
        try {
            if (compilerData.isMkdirs()) {
                FileUtils.forceMkdirParent((File)file);
            }
            fileOutputStream = new FileOutputStream(file);
            jarOutputStream = new JarOutputStream(fileOutputStream);
            int level = compilerData.getComprLevel();
            if (level >= 0 && level < 10) {
                jarOutputStream.setLevel(level);
            } else {
                jarOutputStream.setLevel(9);
            }
        }
        catch (IOException e) {
            IOUtils.closeQuietly(fileOutputStream);
        }
        return jarOutputStream;
    }
}

