/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.cli;

import com.izforge.izpack.api.data.PackCompression;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.exception.HelpRequestedException;
import com.izforge.izpack.compiler.exception.NoArgumentException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CliAnalyzer {
    private static final String ARG_IZPACK_HOME = "h";
    private static final String ARG_BASEDIR = "b";
    private static final String ARG_KIND = "k";
    private static final String ARG_OUTPUT = "o";
    private static final String ARG_COMPRESSION_FORMAT = "c";
    private static final String ARG_COMPRESSION_LEVEL = "l";

    private Options getOptions() {
        Options options = new Options();
        options.addOption("?", false, "Print help");
        options.addOption(ARG_IZPACK_HOME, true, "IzPack home : the root path of IzPack. This will be needed if the compiler is not called in the root directory of IzPack.Do not forget quotations if there are blanks in the path.");
        options.addOption(ARG_BASEDIR, true, "base : indicates the base path that the compiler will use for filenames. of sources. Default is the current path. Attend to -h.");
        options.addOption(ARG_KIND, true, "kind : indicates the kind of installer to generate, default is standard");
        options.addOption(ARG_OUTPUT, true, "out  : indicates the output file name default is the xml file name\n");
        options.addOption(ARG_COMPRESSION_FORMAT, true, "compression : indicates the compression format to be used for packs default is the internal deflate compression\n");
        options.addOption(ARG_COMPRESSION_LEVEL, true, "compression-level : indicates the level for the used compression format if supported. Only integer are valid\n");
        return options;
    }

    public CompilerData printAndParseArgs(String[] args) throws ParseException {
        this.printHeader();
        CompilerData result = this.parseArgs(args);
        this.printTail(result);
        return result;
    }

    private void printHeader() {
        System.out.println("");
        System.out.println(".::  IzPack - Version " + CompilerData.IZPACK_VERSION + " ::.");
        System.out.println("");
        System.out.println("< compiler specifications version: 5.0 >");
        System.out.println("");
        System.out.println("- Copyright (c) 2001-2010 Julien Ponge and others. All Rights Reserved.");
        System.out.println("- Visit http://izpack.org/ for the latest releases");
        System.out.println("- Released under the terms of the Apache Software License version 2.0.");
        System.out.println("");
    }

    private void printTail(CompilerData result) {
        System.out.println("-> Processing  : " + result.getInstallFile());
        System.out.println("-> Output      : " + result.getOutput());
        System.out.println("-> Base path   : " + result.getBasedir());
        System.out.println("-> Kind        : " + result.getKind());
        System.out.println("-> Compression : " + result.getComprFormat());
        System.out.println("-> Compr. level: " + result.getComprLevel());
        System.out.println("-> IzPack home : " + CompilerData.IZPACK_HOME);
        System.out.println("");
    }

    public CompilerData parseArgs(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine commandLine = parser.parse(this.getOptions(), args);
        return this.analyzeCommandLine(commandLine);
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        String cmdLineUsage = "IzPack -> Command line parameters are : (xml file) [args]";
        String header = "(xml file): the xml file describing the installation";
        String footer = "When using vm option -DSTACKTRACE=true there is all kind of debug info ";
        formatter.printHelp(cmdLineUsage, header, this.getOptions(), footer);
    }

    private CompilerData analyzeCommandLine(CommandLine commandLine) {
        this.validateCommandLine(commandLine);
        String baseDir = ".";
        String output = "install.jar";
        String compression = PackCompression.DEFAULT.toName();
        if (commandLine.hasOption("?")) {
            this.printHelp();
            throw new HelpRequestedException();
        }
        List argList = commandLine.getArgList();
        String installFile = (String)argList.get(0);
        if (commandLine.hasOption(ARG_BASEDIR)) {
            baseDir = commandLine.getOptionValue(ARG_BASEDIR).trim();
        }
        if (commandLine.hasOption(ARG_OUTPUT)) {
            output = commandLine.getOptionValue(ARG_OUTPUT).trim();
        }
        if (commandLine.hasOption(ARG_COMPRESSION_FORMAT)) {
            compression = commandLine.getOptionValue(ARG_COMPRESSION_FORMAT).trim();
        }
        CompilerData compilerData = new CompilerData(compression, installFile, baseDir, output, false);
        if (commandLine.hasOption(ARG_COMPRESSION_LEVEL)) {
            compilerData.setComprLevel(Integer.parseInt(commandLine.getOptionValue(ARG_COMPRESSION_LEVEL).trim()));
        }
        if (commandLine.hasOption(ARG_IZPACK_HOME)) {
            CompilerData.setIzpackHome(commandLine.getOptionValue(ARG_IZPACK_HOME).trim());
        }
        if (commandLine.hasOption(ARG_KIND)) {
            compilerData.setKind(commandLine.getOptionValue(ARG_KIND).trim());
        }
        return compilerData;
    }

    private void validateCommandLine(CommandLine commandLine) {
        if (commandLine.getArgList().size() == 0) {
            this.printHelp();
            throw new NoArgumentException();
        }
    }
}

