/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.IXMLParser;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.adaptator.impl.XMLWriter;
import com.izforge.izpack.api.data.Blockable;
import com.izforge.izpack.api.data.Configurable;
import com.izforge.izpack.api.data.ConsolePrefs;
import com.izforge.izpack.api.data.DynamicInstallerRequirementValidator;
import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.ExecutableFile;
import com.izforge.izpack.api.data.GUIPrefs;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.InstallerRequirement;
import com.izforge.izpack.api.data.LookAndFeels;
import com.izforge.izpack.api.data.OverrideType;
import com.izforge.izpack.api.data.PackCompression;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.PackInfo;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.data.PanelValidator;
import com.izforge.izpack.api.data.ParsableFile;
import com.izforge.izpack.api.data.UpdateCheck;
import com.izforge.izpack.api.data.Value;
import com.izforge.izpack.api.data.ValueFilter;
import com.izforge.izpack.api.data.binding.Help;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.api.data.binding.Stage;
import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.data.PropertyManager;
import com.izforge.izpack.compiler.helper.AssertionHelper;
import com.izforge.izpack.compiler.helper.TargetFileSet;
import com.izforge.izpack.compiler.helper.XmlCompilerHelper;
import com.izforge.izpack.compiler.listener.CompilerListener;
import com.izforge.izpack.compiler.merge.CompilerPathResolver;
import com.izforge.izpack.compiler.packager.IPackager;
import com.izforge.izpack.compiler.resource.ResourceFinder;
import com.izforge.izpack.compiler.util.AntPathMatcher;
import com.izforge.izpack.compiler.util.CompilerClassLoader;
import com.izforge.izpack.compiler.util.compress.ArchiveStreamFactory;
import com.izforge.izpack.compiler.xml.AntActionSpecXmlParser;
import com.izforge.izpack.compiler.xml.ConfigurationActionSpecXmlParser;
import com.izforge.izpack.compiler.xml.IconsSpecXmlParser;
import com.izforge.izpack.compiler.xml.InstallationXmlParser;
import com.izforge.izpack.compiler.xml.LangPackXmlParser;
import com.izforge.izpack.compiler.xml.ProcessingSpecXmlParser;
import com.izforge.izpack.compiler.xml.RegistrySpecXmlParser;
import com.izforge.izpack.compiler.xml.ShortcutSpecXmlParser;
import com.izforge.izpack.compiler.xml.UserInputSpecXmlParser;
import com.izforge.izpack.core.data.DynamicInstallerRequirementValidatorImpl;
import com.izforge.izpack.core.data.DynamicVariableImpl;
import com.izforge.izpack.core.rules.process.PackSelectionCondition;
import com.izforge.izpack.core.variable.EnvironmentValue;
import com.izforge.izpack.core.variable.ExecValue;
import com.izforge.izpack.core.variable.JarEntryConfigValue;
import com.izforge.izpack.core.variable.PlainConfigFileValue;
import com.izforge.izpack.core.variable.PlainValue;
import com.izforge.izpack.core.variable.RegistryValue;
import com.izforge.izpack.core.variable.ZipEntryConfigFileValue;
import com.izforge.izpack.core.variable.filters.CaseStyleFilter;
import com.izforge.izpack.core.variable.filters.LocationFilter;
import com.izforge.izpack.core.variable.filters.RegularExpressionFilter;
import com.izforge.izpack.data.CustomData;
import com.izforge.izpack.data.DefaultConfigurationHandlerAdapter;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.logging.FileFormatter;
import com.izforge.izpack.merge.MergeManager;
import com.izforge.izpack.panels.treepacks.PackValidator;
import com.izforge.izpack.panels.userinput.UserInputPanel;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.OsConstraintHelper;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.file.DirectoryScanner;
import com.izforge.izpack.util.file.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class CompilerConfig
extends Thread {
    private static Logger logger;
    private static final File TEMP_DIR;
    private static final boolean YES;
    private static final Boolean NO;
    private static final String NATIVES_PATH = "com/izforge/izpack/bin/native/";
    private final Compiler compiler;
    private final CompilerData compilerData;
    private final List<CompilerListener> compilerListeners = new ArrayList<CompilerListener>();
    private final Map<String, List<IXMLElement>> referencedConditions = new HashMap<String, List<IXMLElement>>();
    private final Map<String, List<IXMLElement>> referencedConditionsUserInputSpec = new HashMap<String, List<IXMLElement>>();
    private final Map<String, List<IXMLElement>> referencedConditionsAntActionSpec = new HashMap<String, List<IXMLElement>>();
    private final Map<String, IXMLElement> referencedPacksAntActionSpec = new HashMap<String, IXMLElement>();
    private final Map<String, List<IXMLElement>> referencedConditionsConfigurationActionSpec = new HashMap<String, List<IXMLElement>>();
    private final Map<String, IXMLElement> referencedPacksConfigurationActionSpec = new HashMap<String, IXMLElement>();
    private Set<String> userInputPanelIds;
    private String unpackerClassname = "com.izforge.izpack.installer.unpacker.Unpacker";
    private String packagerClassname = "com.izforge.izpack.compiler.packager.impl.Packager";
    private final CompilerPathResolver pathResolver;
    private final VariableSubstitutor variableSubstitutor;
    private final XmlCompilerHelper xmlCompilerHelper;
    private final PropertyManager propertyManager;
    private IPackager packager;
    private final ResourceFinder resourceFinder;
    private final MergeManager mergeManager;
    private final AssertionHelper assertionHelper;
    private final RulesEngine rules;
    private final ObjectFactory factory;
    private final PlatformModelMatcher constraints;
    private final CompilerClassLoader classLoader;
    private static final String TEMP_DIR_ELEMENT_NAME = "tempdir";
    private static final String TEMP_DIR_PREFIX_ATTRIBUTE = "prefix";
    private static final String DEFAULT_TEMP_DIR_PREFIX = "IzPack";
    private static final String TEMP_DIR_SUFFIX_ATTRIBUTE = "suffix";
    private static final String DEFAULT_TEMP_DIR_SUFFIX = "Install";
    private static final String TEMP_DIR_VARIABLE_NAME_ATTRIBUTE = "variablename";
    private static final String TEMP_DIR_DEFAULT_PROPERTY_NAME = "TEMP_DIRECTORY";
    private static final String ISO3_ATTRIBUTE = "iso3";
    private static final String SRC_ATTRIBUTE = "src";
    private static final String DIR_ATTRIBUTE = "dir";
    private static final String HELP_TAG = "help";

    public CompilerConfig(CompilerData compilerData, VariableSubstitutor variableSubstitutor, Compiler compiler, XmlCompilerHelper xmlCompilerHelper, PropertyManager propertyManager, MergeManager mergeManager, AssertionHelper assertionHelper, RulesEngine rules, CompilerPathResolver pathResolver, ResourceFinder resourceFinder, ObjectFactory factory, PlatformModelMatcher constraints, CompilerClassLoader classLoader, Handler handler) {
        this.assertionHelper = assertionHelper;
        this.rules = rules;
        this.compilerData = compilerData;
        this.variableSubstitutor = variableSubstitutor;
        this.compiler = compiler;
        this.xmlCompilerHelper = xmlCompilerHelper;
        this.propertyManager = propertyManager;
        this.mergeManager = mergeManager;
        this.pathResolver = pathResolver;
        this.resourceFinder = resourceFinder;
        this.factory = factory;
        this.constraints = constraints;
        this.classLoader = classLoader;
        Logger rootLogger = Logger.getLogger("com.izforge.izpack");
        rootLogger.setUseParentHandlers(false);
        if (handler != null) {
            boolean found = false;
            for (Handler rootHandler : rootLogger.getHandlers()) {
                if (rootHandler.equals(handler)) {
                    found = true;
                    break;
                }
                rootLogger.removeHandler(rootHandler);
            }
            if (!found) {
                rootLogger.addHandler(handler);
            }
            rootLogger.setLevel(handler.getLevel());
        }
        logger = Logger.getLogger(CompilerConfig.class.getName());
        logger.info("Logging initialized at level '" + logger.getParent().getLevel() + "'");
    }

    @Override
    public void run() {
        try {
            this.executeCompiler();
        }
        catch (CompilerException ce) {
            logger.severe(ce.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void executeCompiler() throws Exception {
        File base = new File(this.compilerData.getBasedir()).getAbsoluteFile();
        if (!base.canRead() || !base.isDirectory()) {
            throw new CompilerException("Invalid base directory: " + base);
        }
        this.propertyManager.setProperty("basedir", base.toString());
        InstallationXmlParser parser = new InstallationXmlParser();
        IXMLElement data = this.resourceFinder.getXMLTree((IXMLParser)parser);
        this.addCompilerListeners(data);
        this.loadPackagingInformation(data);
        this.substituteProperties(data);
        this.addNativeLibraries(data);
        this.addInfoStrings(data);
        this.addJars(data);
        this.addVariables(data);
        this.addConditions(data);
        this.addDynamicVariables(data);
        this.addDynamicInstallerRequirement(data);
        this.addInfoConditional(data);
        this.addConsolePrefs(data);
        this.addGUIPrefs(data);
        this.addLangpacks(data);
        this.addLogging(data);
        this.addResources(data);
        this.addPanelJars(data);
        this.addListenerJars(data);
        this.addPanels(data);
        this.addListeners(data);
        this.addPacks(data);
        this.addInstallerRequirement(data);
        this.checkReferencedConditions();
        this.checkReferencedPacks();
        this.compiler.createInstaller();
    }

    protected void setPackager(IPackager packager) {
        this.packager = packager;
    }

    private void addInstallerRequirement(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addInstallerRequirement", 1, data);
        IXMLElement root = data.getFirstChildNamed("installerrequirements");
        ArrayList<InstallerRequirement> installerrequirements = new ArrayList<InstallerRequirement>();
        if (root != null) {
            List installerrequirementsels = root.getChildrenNamed("installerrequirement");
            for (IXMLElement installerrequirement : installerrequirementsels) {
                InstallerRequirement basicInstallerCondition = new InstallerRequirement();
                String conditionId = this.parseConditionAttribute(installerrequirement);
                if (conditionId == null) {
                    this.assertionHelper.parseError(installerrequirement, "Missing condition attribute");
                }
                basicInstallerCondition.setCondition(conditionId);
                String message = installerrequirement.getAttribute("message");
                if (message == null) {
                    this.assertionHelper.parseError(installerrequirement, "Missing message attribute");
                }
                basicInstallerCondition.setMessage(message);
                installerrequirements.add(basicInstallerCondition);
            }
        }
        this.packager.addInstallerRequirements(installerrequirements);
        this.notifyCompilerListener("addInstallerRequirement", 2, data);
    }

    private void loadPackagingInformation(IXMLElement data) throws CompilerException {
        IXMLElement options;
        this.notifyCompilerListener("loadPackager", 1, data);
        IXMLElement root = data.getFirstChildNamed("packaging");
        IXMLElement packagerElement = null;
        if (root != null) {
            IXMLElement unpacker;
            packagerElement = root.getFirstChildNamed("packager");
            if (packagerElement != null) {
                Class<IPackager> packagerClass = this.classLoader.loadClass(this.xmlCompilerHelper.requireAttribute(packagerElement, "class"), IPackager.class);
                this.packagerClassname = packagerClass.getName();
            }
            if ((unpacker = root.getFirstChildNamed("unpacker")) != null) {
                Class<IUnpacker> unpackerClass = this.classLoader.loadClass(this.xmlCompilerHelper.requireAttribute(unpacker, "class"), IUnpacker.class);
                this.unpackerClassname = unpackerClass.getName();
            }
        }
        this.packager = (IPackager)this.factory.create(this.packagerClassname, IPackager.class, new Object[0]);
        if (packagerElement != null && (options = packagerElement.getFirstChildNamed("options")) != null) {
            this.packager.addConfigurationInformation(options);
        }
        this.compiler.setPackager(this.packager);
        this.propertyManager.addProperty("UNPACKER_CLASS", this.unpackerClassname);
        this.notifyCompilerListener("loadPackager", 2, data);
    }

    public boolean wasSuccessful() {
        return this.compiler.wasSuccessful();
    }

    private void addConsolePrefs(IXMLElement data) throws CompilerException {
        IXMLElement detectTerminalTag;
        this.notifyCompilerListener("addConsolePrefs", 1, data);
        IXMLElement consolePrefsElement = data.getFirstChildNamed("consoleprefs");
        ConsolePrefs prefs = new ConsolePrefs();
        if (consolePrefsElement != null && (detectTerminalTag = consolePrefsElement.getFirstChildNamed("detectTerminal")) != null) {
            prefs.enableConsoleReader = Boolean.parseBoolean(this.xmlCompilerHelper.requireContent(detectTerminalTag));
        }
        this.packager.setConsolePrefs(prefs);
        this.notifyCompilerListener("addConsolePrefs", 2, data);
    }

    private void addGUIPrefs(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addGUIPrefs", 1, data);
        IXMLElement guiPrefsElement = data.getFirstChildNamed("guiprefs");
        GUIPrefs prefs = new GUIPrefs();
        if (guiPrefsElement != null) {
            String lafName;
            prefs.resizable = this.xmlCompilerHelper.requireYesNoAttribute(guiPrefsElement, "resizable");
            prefs.width = this.xmlCompilerHelper.requireIntAttribute(guiPrefsElement, "width");
            prefs.height = this.xmlCompilerHelper.requireIntAttribute(guiPrefsElement, "height");
            for (IXMLElement lafNode : guiPrefsElement.getChildrenNamed("laf")) {
                lafName = this.xmlCompilerHelper.requireAttribute(lafNode, "name");
                this.xmlCompilerHelper.requireChildNamed(lafNode, "os");
                GUIPrefs.LookAndFeel lookAndFeel = new GUIPrefs.LookAndFeel(lafName);
                for (IXMLElement parameterNode : lafNode.getChildrenNamed("param")) {
                    String name = this.xmlCompilerHelper.requireAttribute(parameterNode, "name");
                    String value = this.xmlCompilerHelper.requireAttribute(parameterNode, "value");
                    lookAndFeel.setParameter(name, value);
                }
                for (IXMLElement osNode : lafNode.getChildrenNamed("os")) {
                    String osName = this.xmlCompilerHelper.requireAttribute(osNode, "family");
                    prefs.lookAndFeelMapping.put(osName, lookAndFeel);
                }
            }
            for (IXMLElement ixmlElement : guiPrefsElement.getChildrenNamed("modifier")) {
                String key = this.xmlCompilerHelper.requireAttribute(ixmlElement, "key");
                String value = this.xmlCompilerHelper.requireAttribute(ixmlElement, "value");
                prefs.modifier.put(key, value);
            }
            for (GUIPrefs.LookAndFeel lookAndFeel : prefs.lookAndFeelMapping.values()) {
                lafName = lookAndFeel.getName();
                LookAndFeels feels = LookAndFeels.lookup((String)lafName);
                if (feels != null) {
                    List mergeableList = Collections.emptyList();
                    switch (feels) {
                        case KUNSTSTOFF: {
                            mergeableList = this.pathResolver.getMergeableFromPackageName("com/incors/plaf");
                            break;
                        }
                        case LOOKS: {
                            mergeableList = this.pathResolver.getMergeableFromPackageName("com/jgoodies/looks");
                            break;
                        }
                        case SUBSTANCE: {
                            mergeableList = this.pathResolver.getMergeableJarFromPackageName("org/pushingpixels");
                            break;
                        }
                        case NIMBUS: {
                            break;
                        }
                        default: {
                            this.assertionHelper.parseError(guiPrefsElement, "Unrecognized Look and Feel: " + lafName);
                        }
                    }
                    for (Mergeable mergeable : mergeableList) {
                        this.mergeManager.addResourceToMerge(mergeable);
                    }
                    continue;
                }
                this.assertionHelper.parseError(guiPrefsElement, "Unrecognized Look and Feel: " + lafName);
            }
        }
        this.packager.setGUIPrefs(prefs);
        this.notifyCompilerListener("addGUIPrefs", 2, data);
    }

    private void addJars(IXMLElement data) throws IOException {
        this.notifyCompilerListener("addJars", 1, data);
        String minimalJavaVersion = this.compilerData.getExternalInfo().getJavaVersion();
        boolean javaVersionStrict = this.compilerData.getExternalInfo().getJavaVersionStrict();
        for (IXMLElement ixmlElement : data.getChildrenNamed("jar")) {
            String src = this.getSrcSubstitutedAttributeValue(ixmlElement);
            String stage = ixmlElement.getAttribute("stage");
            URL url = this.resourceFinder.findProjectResource(src, "Jar file", ixmlElement);
            boolean uninstaller = "both".equalsIgnoreCase(stage) || "uninstall".equalsIgnoreCase(stage);
            this.compiler.checkJarVersions(new File(url.getFile()), minimalJavaVersion);
            if (!this.compiler.getJavaVersionCorrect()) {
                if (javaVersionStrict) {
                    throw new CompilerException(url.getFile() + " does not meet the minimal version requirements." + "\nRequired minimal target Java version: " + minimalJavaVersion + "\nFound class target Java version: 1." + this.compiler.getJavaVersionExpected());
                }
                logger.warning(url.getFile() + " does not meet the minimal version requirements which may cause issues during runtime." + "\nRequired minimal target Java version: " + minimalJavaVersion + "\nFound class target Java version: 1." + this.compiler.getJavaVersionExpected());
            }
            this.compiler.addJar(url, uninstaller);
        }
        this.notifyCompilerListener("addJars", 2, data);
    }

    private void addPanelJars(IXMLElement data) throws IOException {
        this.notifyCompilerListener("addPanelJars", 1, data);
        IXMLElement panels = this.xmlCompilerHelper.requireChildNamed(data, "panels");
        for (IXMLElement panel : panels.getChildrenNamed("panel")) {
            URL url = this.getPanelJarURL(panel);
            if (url == null) continue;
            this.compiler.addJar(url, false);
        }
        this.notifyCompilerListener("addPanelJars", 2, data);
    }

    private URL getPanelJarURL(IXMLElement panel) throws CompilerException {
        return this.getJarResourceURL(panel, "Panel jar file");
    }

    private URL getListenerJarURL(IXMLElement listener) throws CompilerException {
        return this.getJarResourceURL(listener, "Listener jar file");
    }

    private URL getJarResourceURL(IXMLElement element, String description) throws CompilerException {
        String value = element.getAttribute("jar");
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return this.resourceFinder.findIzPackResource(value, description, element, false);
        }
        return null;
    }

    private void addListenerJars(IXMLElement data) throws IOException {
        this.notifyCompilerListener("addListenerJars", 1, data);
        IXMLElement listeners = data.getFirstChildNamed("listeners");
        if (listeners != null) {
            for (IXMLElement listener : listeners.getChildrenNamed("listener")) {
                URL url;
                Stage stage = Stage.valueOf((String)this.xmlCompilerHelper.requireAttribute(listener, "stage"));
                if (!Stage.isInInstaller((Stage)stage) || (url = this.getListenerJarURL(listener)) == null) continue;
                this.compiler.addJar(url, stage == Stage.uninstall);
            }
        }
        this.notifyCompilerListener("addListenerJars", 2, data);
    }

    private void addNativeLibraries(IXMLElement data) {
        this.notifyCompilerListener("addNativeLibraries", 1, data);
        IXMLElement nativesElement = data.getFirstChildNamed("natives");
        if (nativesElement == null) {
            return;
        }
        for (IXMLElement ixmlElement : nativesElement.getChildrenNamed("native")) {
            String type = this.xmlCompilerHelper.requireAttribute(ixmlElement, "type");
            String name = this.xmlCompilerHelper.requireAttribute(ixmlElement, "name");
            String path = ixmlElement.getAttribute(SRC_ATTRIBUTE);
            if (path == null) {
                path = NATIVES_PATH + type + "/" + name;
            }
            String destination = NATIVES_PATH + type + "/" + name;
            this.mergeManager.addResourceToMerge(path, destination);
            String stage = ixmlElement.getAttribute("stage");
            if (stage != null) {
                this.assertionHelper.parseWarn(ixmlElement, "The 'stage' attribute is deprecated here and might be removed in future. Use the new attribute 'uninstaller' as replacement.");
            }
            if (!Boolean.parseBoolean(ixmlElement.getAttribute("uninstaller", Boolean.FALSE.toString())) && !"both".equalsIgnoreCase(stage) && !"uninstall".equalsIgnoreCase(stage)) continue;
            List constraints = OsConstraintHelper.getOsList((IXMLElement)ixmlElement);
            ArrayList<String> contents = new ArrayList<String>();
            contents.add(destination);
            CustomData customData = new CustomData(null, contents, constraints, 2);
            this.packager.addNativeUninstallerLibrary(customData);
        }
        this.notifyCompilerListener("addNativeLibraries", 2, data);
    }

    private void addPacks(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addPacks", 1, data);
        this.addPacksSingle(data, new File(this.compilerData.getBasedir()));
        this.compiler.checkDependencies();
        this.compiler.checkExcludes();
        this.notifyCompilerListener("addPacks", 2, data);
    }

    private void addPacksSingle(IXMLElement data, File baseDir) throws CompilerException {
        this.notifyCompilerListener("addPacksSingle", 1, data);
        IXMLElement root = this.xmlCompilerHelper.requireChildNamed(data, "packs");
        List packElements = root.getChildrenNamed("pack");
        List refPackElements = root.getChildrenNamed("refpack");
        List refPackSets = root.getChildrenNamed("refpackset");
        if (packElements.isEmpty() && refPackElements.isEmpty() && refPackSets.isEmpty()) {
            this.assertionHelper.parseError(root, "<packs> requires a <pack>, <refpack> or <refpackset>");
        }
        for (IXMLElement packElement : packElements) {
            String name = this.xmlCompilerHelper.requireAttribute(packElement, "name");
            String id = packElement.getAttribute("id");
            String packImgId = packElement.getAttribute("packImgId");
            boolean loose = Boolean.parseBoolean(packElement.getAttribute("loose", "false"));
            String description = this.xmlCompilerHelper.requireChildNamed(packElement, "description").getContent();
            boolean required = this.xmlCompilerHelper.requireYesNoAttribute(packElement, "required");
            String group = packElement.getAttribute("group");
            String installGroups = packElement.getAttribute("installGroups");
            String excludeGroup = packElement.getAttribute("excludeGroup");
            boolean uninstall = this.xmlCompilerHelper.validateYesNoAttribute(packElement, "uninstall", YES);
            long size = this.xmlCompilerHelper.getLong(packElement, "size", 0L);
            String parent = packElement.getAttribute("parent");
            boolean hidden = Boolean.parseBoolean(packElement.getAttribute("hidden", "false"));
            String conditionId = this.parseConditionAttribute(packElement);
            if (required && excludeGroup != null) {
                this.assertionHelper.parseError(packElement, "Pack, which has excludeGroup can not be required.", new Exception("Pack, which has excludeGroup can not be required."));
            }
            PackInfo pack = new PackInfo(name, id, description, required, loose, excludeGroup, uninstall, size);
            pack.setOsConstraints(OsConstraintHelper.getOsList((IXMLElement)packElement));
            pack.setParent(parent);
            if (conditionId != null) {
                pack.setCondition(conditionId);
            }
            pack.setHidden(hidden);
            if (excludeGroup == null) {
                pack.setPreselected(this.xmlCompilerHelper.validateYesNoAttribute(packElement, "preselected", YES));
            } else {
                pack.setPreselected(this.xmlCompilerHelper.validateYesNoAttribute(packElement, "preselected", NO));
            }
            if (group != null) {
                pack.setGroup(group);
            }
            if (installGroups != null) {
                StringTokenizer st = new StringTokenizer(installGroups, ",");
                while (st.hasMoreTokens()) {
                    String igroup = st.nextToken();
                    pack.addInstallGroup(igroup);
                }
            }
            if (packImgId != null) {
                pack.setPackImgId(packImgId);
            }
            this.processFileChildren(baseDir, packElement, pack);
            this.processSingleFileChildren(baseDir, packElement, pack);
            this.processFileSetChildren(baseDir, packElement, pack);
            this.processUpdateCheckChildren(packElement, pack);
            this.processOnSelect(packElement, pack);
            this.processOnDeselect(packElement, pack);
            List parsableChildren = packElement.getChildrenNamed("parsable");
            this.processParsableChildren(pack, parsableChildren);
            List executableChildren = packElement.getChildrenNamed("executable");
            this.processExecutableChildren(pack, executableChildren);
            for (IXMLElement dependsNode : packElement.getChildrenNamed("depends")) {
                String depName = this.xmlCompilerHelper.requireAttribute(dependsNode, "packname");
                pack.addDependency(depName);
            }
            for (IXMLElement validator : packElement.getChildrenNamed("validator")) {
                Class<PackValidator> type = this.classLoader.loadClass(this.xmlCompilerHelper.requireContent(validator), PackValidator.class);
                pack.addValidator(type.getName());
            }
            PackSelectionCondition selectionCondition = new PackSelectionCondition();
            selectionCondition.setId("izpack.selected." + name);
            selectionCondition.setPack(name);
            this.rules.addCondition((Condition)selectionCondition);
            this.logAddingPack(pack);
            this.packager.addPack(pack);
        }
        for (IXMLElement refPackElement : refPackElements) {
            String refFileName = this.xmlCompilerHelper.requireAttribute(refPackElement, "file");
            String selfcontained = refPackElement.getAttribute("selfcontained");
            boolean isselfcontained = Boolean.valueOf(selfcontained);
            File refFile = new File(refFileName);
            File packDir = new File(baseDir, refFile.getParent());
            IXMLElement refXMLData = this.readRefPackData(packDir, refFile.getName(), isselfcontained);
            logger.info("Reading refpack from " + refFile.getName() + " in dir " + packDir);
            this.addPacksSingle(refXMLData, packDir);
        }
        for (IXMLElement refPackSet : refPackSets) {
            String dir_attr = this.xmlCompilerHelper.requireAttribute(refPackSet, DIR_ATTRIBUTE);
            File dir = new File(dir_attr);
            if (!dir.isAbsolute()) {
                dir = new File(baseDir, dir_attr);
            }
            if (!dir.isDirectory()) {
                this.assertionHelper.parseError(refPackSet, "Invalid refpackset directory 'dir': " + dir_attr);
            }
            String includeString = this.xmlCompilerHelper.requireAttribute(refPackSet, "includes");
            String[] includes = includeString.split(", ");
            DirectoryScanner ds = new DirectoryScanner();
            ds.setIncludes(includes);
            ds.setBasedir(dir);
            ds.setCaseSensitive(true);
            try {
                String[] files;
                ds.scan();
                for (String file : files = ds.getIncludedFiles()) {
                    File refFile = new File(dir, file);
                    File packDir = new File(baseDir, refFile.getParent());
                    IXMLElement refXMLData = this.readRefPackData(packDir, refFile.getName(), false);
                    this.addPacksSingle(refXMLData, packDir);
                }
            }
            catch (Exception e) {
                throw new CompilerException(e.getMessage());
            }
        }
        this.notifyCompilerListener("addPacksSingle", 2, data);
    }

    private void processUpdateCheckChildren(IXMLElement packElement, PackInfo pack) throws CompilerException {
        for (IXMLElement updateNode : packElement.getChildrenNamed("updatecheck")) {
            ArrayList<String> includesList = new ArrayList<String>();
            ArrayList<String> excludesList = new ArrayList<String>();
            for (IXMLElement ixmlElement1 : updateNode.getChildrenNamed("include")) {
                includesList.add(this.xmlCompilerHelper.requireAttribute(ixmlElement1, "name"));
            }
            for (IXMLElement ixmlElement : updateNode.getChildrenNamed("exclude")) {
                excludesList.add(this.xmlCompilerHelper.requireAttribute(ixmlElement, "name"));
            }
            pack.addUpdateCheck(new UpdateCheck(includesList, excludesList));
        }
    }

    private void processFileSetChildren(File baseDir, IXMLElement packElement, PackInfo pack) throws CompilerException {
        try {
            for (TargetFileSet fs : this.readFileSets(packElement, baseDir)) {
                this.processFileSetChildren(fs, baseDir, null, pack);
            }
        }
        catch (Exception e) {
            this.assertionHelper.parseError(packElement, e.getMessage(), e);
        }
    }

    private void processFileSetChildren(TargetFileSet fs, File baseDir, List<OsModel> parentOsList, PackInfo pack) throws Exception {
        String[][] includedFilesAndDirs;
        for (String[] filesOrDirs : includedFilesAndDirs = new String[][]{fs.getDirectoryScanner().getIncludedDirectories(), fs.getDirectoryScanner().getIncludedFiles()}) {
            if (filesOrDirs == null) continue;
            for (String filePath : filesOrDirs) {
                if (filePath.isEmpty()) continue;
                File file = new File(fs.getDir(), filePath);
                String target = new File(fs.getTargetDir(), filePath).getPath();
                List osList = fs.getOsList();
                if (parentOsList != null && !parentOsList.isEmpty()) {
                    try {
                        osList = OsConstraintHelper.commonOsList(parentOsList, fs.getOsList());
                        this.logCombineOsLists(parentOsList, fs.getOsList(), osList);
                    }
                    catch (OsConstraintHelper.UnsatisfiableOsConstraintsException ex) {
                        throw new CompilerException(ex.getMessage());
                    }
                }
                this.logAddingFile(file.toString(), target);
                pack.addFile(baseDir, file, target, osList, fs.getOverride(), fs.getOverrideRenameTo(), fs.getBlockable(), fs.getAdditionals(), fs.getCondition(), fs.getPack200Properties());
            }
        }
    }

    private void processOnSelect(IXMLElement packElement, PackInfo pack) {
        for (IXMLElement selectNode : packElement.getChildrenNamed("onSelect")) {
            String name = this.xmlCompilerHelper.requireAttribute(selectNode, "name");
            String conditionId = this.parseConditionAttribute(selectNode);
            pack.addOnSelect(name, conditionId);
        }
    }

    private void processOnDeselect(IXMLElement packElement, PackInfo pack) {
        for (IXMLElement deselectNode : packElement.getChildrenNamed("onDeselect")) {
            String name = this.xmlCompilerHelper.requireAttribute(deselectNode, "name");
            String condition = this.parseConditionAttribute(deselectNode);
            pack.addOnDeselect(name, condition);
        }
    }

    private void processSingleFileChildren(File baseDir, IXMLElement packElement, PackInfo pack) throws CompilerException {
        for (IXMLElement singleFileNode : packElement.getChildrenNamed("singlefile")) {
            String src = this.getSrcSubstitutedAttributeValue(singleFileNode);
            String target = this.xmlCompilerHelper.requireAttribute(singleFileNode, "target");
            List osList = OsConstraintHelper.getOsList((IXMLElement)singleFileNode);
            OverrideType override = this.getOverrideValue(singleFileNode);
            String overrideRenameTo = this.getOverrideRenameToValue(singleFileNode);
            Blockable blockable = this.getBlockableValue(singleFileNode, osList);
            Map<String, ?> additionals = this.getAdditionals(singleFileNode);
            String conditionId = this.parseConditionAttribute(singleFileNode);
            File file = new File(src);
            if (!file.isAbsolute()) {
                file = new File(baseDir, src);
            }
            if (!file.exists()) {
                this.assertionHelper.parseWarn(singleFileNode, "Source file " + src + " (" + file + ") not found");
            }
            try {
                this.logAddingFile(file.toString(), target);
                pack.addFile(baseDir, file, target, osList, override, overrideRenameTo, blockable, additionals, conditionId, this.readPack200Properties(singleFileNode));
            }
            catch (IOException x) {
                this.assertionHelper.parseError(singleFileNode, x.getMessage(), x);
            }
        }
    }

    private void processFileChildren(File baseDir, IXMLElement packElement, PackInfo pack) throws CompilerException {
        for (IXMLElement fileNode : packElement.getChildrenNamed("file")) {
            String src = this.getSrcSubstitutedAttributeValue(fileNode);
            boolean unpack = Boolean.parseBoolean(fileNode.getAttribute("unpack"));
            TargetFileSet fs = new TargetFileSet();
            try {
                File relsrcfile = new File(src);
                File abssrcfile = FileUtil.getAbsoluteFile((String)src, (String)baseDir.getAbsolutePath());
                if (!abssrcfile.exists()) {
                    throw new FileNotFoundException("Source file " + relsrcfile + " (" + abssrcfile + ") not found");
                }
                if (relsrcfile.isDirectory()) {
                    fs.setDir(abssrcfile.getParentFile());
                    fs.createInclude().setName(relsrcfile.getName() + "/**");
                } else {
                    fs.setFile(abssrcfile);
                }
                fs.setTargetDir(fileNode.getAttribute("targetdir", "${INSTALL_PATH}"));
                List osList = OsConstraintHelper.getOsList((IXMLElement)fileNode);
                fs.setOsList(osList);
                fs.setOverride(this.getOverrideValue(fileNode));
                fs.setOverrideRenameTo(this.getOverrideRenameToValue(fileNode));
                fs.setBlockable(this.getBlockableValue(fileNode, osList));
                fs.setAdditionals(this.getAdditionals(fileNode));
                fs.setCondition(this.parseConditionAttribute(fileNode));
                String boolval = fileNode.getAttribute("casesensitive");
                if (boolval != null) {
                    fs.setCaseSensitive(Boolean.parseBoolean(boolval));
                }
                if ((boolval = fileNode.getAttribute("defaultexcludes")) != null) {
                    fs.setDefaultexcludes(Boolean.parseBoolean(boolval));
                }
                if ((boolval = fileNode.getAttribute("followsymlinks")) != null) {
                    fs.setFollowSymlinks(Boolean.parseBoolean(boolval));
                }
                Map<String, String> pack200Properties = this.readPack200Properties(fileNode);
                LinkedList srcfiles = new LinkedList();
                Collections.addAll(srcfiles, fs.getDirectoryScanner().getIncludedDirectories());
                Collections.addAll(srcfiles, fs.getDirectoryScanner().getIncludedFiles());
                for (String filePath : srcfiles) {
                    if (filePath.isEmpty()) continue;
                    abssrcfile = new File(fs.getDir(), filePath);
                    if (unpack) {
                        logger.info("Adding content from archive: " + abssrcfile);
                        this.addArchiveContent(fileNode, baseDir, abssrcfile, fs.getTargetDir(), fs.getOsList(), fs.getOverride(), fs.getOverrideRenameTo(), fs.getBlockable(), pack, fs.getAdditionals(), fs.getCondition(), pack200Properties);
                        continue;
                    }
                    String target = fs.getTargetDir() + "/" + filePath;
                    this.logAddingFile(abssrcfile.toString(), target);
                    pack.addFile(baseDir, abssrcfile, target, fs.getOsList(), fs.getOverride(), fs.getOverrideRenameTo(), fs.getBlockable(), fs.getAdditionals(), fs.getCondition(), pack200Properties);
                }
            }
            catch (Exception e) {
                throw new CompilerException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Map<String, String> readPack200Properties(IXMLElement element) {
        IXMLElement pack200Element = element.getFirstChildNamed("pack200");
        HashMap<String, String> pack200Properties = null;
        if (pack200Element != null) {
            pack200Properties = new HashMap<String, String>();
            this.addNotNullAttribute(pack200Properties, "pack.effort", pack200Element, "effort");
            this.addNotNullAttribute(pack200Properties, "pack.segment.limit", pack200Element, "segment-limit");
            this.addNotNullAttribute(pack200Properties, "pack.keep.file.order", pack200Element, "keep-file-order");
            this.addNotNullAttribute(pack200Properties, "pack.deflate.hint", pack200Element, "deflate-hint");
            this.addNotNullAttribute(pack200Properties, "pack.modification.time", pack200Element, "modification-time");
            this.addNotNullAttributeIfTrue(pack200Properties, "pack.code.attribute.LineNumberTable", "strip", pack200Element, "strip-line-numbers");
            this.addNotNullAttributeIfTrue(pack200Properties, "pack.code.attribute.LocalVariableTable", "strip", pack200Element, "strip-local-variables");
            this.addNotNullAttributeIfTrue(pack200Properties, "pack.code.attribute.SourceFile", "strip", pack200Element, "strip-source-files");
        }
        return pack200Properties;
    }

    private void addNotNullAttribute(Map<String, String> map, String key, IXMLElement element, String attrName) {
        String attr = element.getAttribute(attrName);
        if (attr != null) {
            map.put(key, attr);
        }
    }

    private void addNotNullAttributeIfTrue(Map<String, String> map, String key, String value, IXMLElement element, String attrName) {
        String attr = element.getAttribute(attrName);
        if (attr != null && Boolean.parseBoolean(attr)) {
            map.put(key, value);
        }
    }

    private void processExecutableChildren(PackInfo pack, List<IXMLElement> childrenNamed) throws CompilerException {
        for (IXMLElement executableNode : childrenNamed) {
            String target = executableNode.getAttribute("targetfile");
            String conditionId = this.parseConditionAttribute(executableNode);
            List osList = OsConstraintHelper.getOsList((IXMLElement)executableNode);
            int executionStage = 1;
            int type = 0;
            int onFailure = 2;
            String val = executableNode.getAttribute("stage", "never");
            if ("postinstall".equalsIgnoreCase(val)) {
                executionStage = 0;
            } else if ("uninstall".equalsIgnoreCase(val)) {
                executionStage = 2;
            }
            val = executableNode.getAttribute("type", "bin");
            String mainClass = executableNode.getAttribute("class");
            if ("jar".equalsIgnoreCase(val)) {
                type = 1;
                if (mainClass == null || mainClass.isEmpty()) {
                    throw new CompilerException("Attribute 'class' mandatory and must not be empty for type 'jar'");
                }
            } else if (mainClass != null) {
                throw new CompilerException("Attribute 'class' allowed for type 'jar' only");
            }
            if ("abort".equalsIgnoreCase(val = executableNode.getAttribute("failure", "ask"))) {
                onFailure = 0;
            } else if ("warn".equalsIgnoreCase(val)) {
                onFailure = 1;
            } else if ("ignore".equalsIgnoreCase(val)) {
                onFailure = 3;
            }
            val = executableNode.getAttribute("keep");
            boolean keepFile = Boolean.parseBoolean(val);
            IXMLElement args = executableNode.getFirstChildNamed("args");
            ArrayList<String> argsList = new ArrayList<String>();
            if (null != args) {
                for (IXMLElement ixmlElement : args.getChildrenNamed("arg")) {
                    argsList.add(this.xmlCompilerHelper.requireAttribute(ixmlElement, "value"));
                }
            }
            if (target != null) {
                this.addNewExecutableFile(pack, target, conditionId, osList, executionStage, type, mainClass, onFailure, keepFile, argsList);
                this.logMarkFileExecutable(target);
            }
            for (IXMLElement fileSetElement : executableNode.getChildrenNamed("fileset")) {
                String targetdir = fileSetElement.getAttribute("targetdir", "${INSTALL_PATH}");
                Set<String> includedFiles = this.getFilesetIncludedFiles(pack, fileSetElement, targetdir);
                for (String filePath : includedFiles) {
                    this.addNewExecutableFile(pack, filePath, conditionId, osList, executionStage, type, mainClass, onFailure, keepFile, argsList);
                    this.logMarkFileExecutable(filePath);
                }
            }
        }
    }

    private void addNewExecutableFile(PackInfo pack, String target, String condition, List<OsModel> osList, int executionStage, int type, String mainClass, int onFailure, boolean keepFile, List<String> argsList) throws CompilerException {
        ExecutableFile executable = new ExecutableFile();
        executable.path = target;
        executable.setCondition(condition);
        executable.osList = osList;
        executable.executionStage = executionStage;
        executable.type = type;
        executable.mainClass = mainClass;
        executable.onFailure = onFailure;
        executable.keepFile = keepFile;
        for (String arg : argsList) {
            executable.argList.add(arg);
        }
        pack.addExecutable(executable);
    }

    private void processParsableChildren(PackInfo pack, List<IXMLElement> parsableChildren) throws CompilerException {
        for (IXMLElement parsableNode : parsableChildren) {
            String target = parsableNode.getAttribute("targetfile");
            SubstitutionType type = SubstitutionType.lookup((String)parsableNode.getAttribute("type", "plain"));
            String encoding = parsableNode.getAttribute("encoding", null);
            List osList = OsConstraintHelper.getOsList((IXMLElement)parsableNode);
            String conditionId = this.parseConditionAttribute(parsableNode);
            if (target != null) {
                ParsableFile parsable = new ParsableFile(target, type, encoding, osList);
                if (conditionId != null) {
                    parsable.setCondition(conditionId);
                }
                pack.addParsable(parsable);
                this.logMarkFileParsable(target);
            }
            for (IXMLElement fileSetElement : parsableNode.getChildrenNamed("fileset")) {
                String targetdir = fileSetElement.getAttribute("targetdir", "${INSTALL_PATH}");
                Set<String> includedFiles = this.getFilesetIncludedFiles(pack, fileSetElement, targetdir);
                for (String filePath : includedFiles) {
                    ParsableFile parsable = new ParsableFile(filePath, type, encoding, osList);
                    if (conditionId != null) {
                        parsable.setCondition(conditionId);
                    }
                    pack.addParsable(parsable);
                    this.logMarkFileParsable(filePath);
                }
            }
        }
    }

    private Set<String> getFilesetIncludedFiles(PackInfo info, IXMLElement fileSetElement, String targetDir) throws CompilerException {
        String targetPath;
        boolean casesensitive = this.xmlCompilerHelper.validateYesNoAttribute(fileSetElement, "casesensitive", YES);
        String[] includes = null;
        List xcludesList = fileSetElement.getChildrenNamed("include");
        if (!xcludesList.isEmpty()) {
            includes = new String[xcludesList.size()];
            for (int j = 0; j < xcludesList.size(); ++j) {
                IXMLElement xclude = (IXMLElement)xcludesList.get(j);
                includes[j] = this.xmlCompilerHelper.requireAttribute(xclude, "name");
            }
        }
        String[] excludes = null;
        xcludesList = fileSetElement.getChildrenNamed("exclude");
        if (!xcludesList.isEmpty()) {
            excludes = new String[xcludesList.size()];
            for (int j = 0; j < xcludesList.size(); ++j) {
                IXMLElement xclude = (IXMLElement)xcludesList.get(j);
                excludes[j] = this.xmlCompilerHelper.requireAttribute(xclude, "name");
            }
        }
        String[] toDo = new String[]{"includes", "excludes"};
        String[][] containers = new String[][]{includes, excludes};
        for (int j = 0; j < toDo.length; ++j) {
            String inex = fileSetElement.getAttribute(toDo[j]);
            if (inex == null || inex.length() <= 0) continue;
            StringTokenizer tokenizer = new StringTokenizer(inex, ", ", false);
            int newSize = tokenizer.countTokens();
            String[] nCont = null;
            if (containers[j] != null && containers[j].length > 0) {
                nCont = new String[newSize += containers[j].length];
                System.arraycopy(containers[j], 0, nCont, 0, containers[j].length);
            }
            if (nCont == null) {
                nCont = new String[newSize];
            }
            for (int k = 0; k < newSize; ++k) {
                nCont[k] = tokenizer.nextToken();
            }
            containers[j] = nCont;
        }
        includes = containers[0];
        excludes = containers[1];
        HashSet<String> matches = new HashSet<String>();
        AntPathMatcher matcher = new AntPathMatcher();
        if (includes == null || includes.length == 0) {
            throw new CompilerException("At least one included file required in a fileset");
        }
        logger.fine("Fileset (targetDir=\"" + targetDir + "\"");
        for (String include : includes) {
            logger.fine("Processing include: \"" + include + "\"");
            for (PackFile s : info.getPackFiles()) {
                targetPath = s.getTargetPath();
                if (!matcher.match(targetDir + "/" + include, targetPath, casesensitive)) continue;
                matches.add(targetPath);
            }
        }
        if (excludes != null) {
            for (String exclude : excludes) {
                for (PackFile s : info.getPackFiles()) {
                    targetPath = s.getTargetPath();
                    if (!matcher.match(exclude, targetPath, casesensitive)) continue;
                    matches.remove(targetPath);
                }
            }
        }
        return matches;
    }

    private IXMLElement readRefPackData(File baseDir, String refFileName, boolean isselfcontained) throws CompilerException {
        InputStream specin;
        File refXMLFile = new File(refFileName);
        if (!refXMLFile.isAbsolute()) {
            refXMLFile = new File(baseDir, refFileName);
        }
        if (!refXMLFile.canRead()) {
            throw new CompilerException("Invalid file: " + refXMLFile);
        }
        if (isselfcontained) {
            if (!refXMLFile.getAbsolutePath().endsWith(".zip")) {
                throw new CompilerException("Invalid file: " + refXMLFile + ". Selfcontained files can only be of type zip.");
            }
            try {
                ZipFile zip = new ZipFile(refXMLFile, 1);
                ZipEntry specentry = zip.getEntry("META-INF/izpack.xml");
                specin = zip.getInputStream(specentry);
            }
            catch (IOException e) {
                throw new CompilerException("Error reading META-INF/izpack.xml in " + refXMLFile);
            }
        }
        try {
            specin = new FileInputStream(refXMLFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new CompilerException("FileNotFoundException exception while reading refXMLFile");
        }
        IXMLElement refXMLData = new InstallationXmlParser().parse(specin, refXMLFile.getAbsolutePath());
        if (!"izpack:installation".equalsIgnoreCase(refXMLData.getName()) && !"installation".equalsIgnoreCase(refXMLData.getName())) {
            this.assertionHelper.parseError(refXMLData, "this is not an IzPack XML installation file");
        }
        if (!"5.0".equalsIgnoreCase(this.xmlCompilerHelper.requireAttribute(refXMLData, "version"))) {
            this.assertionHelper.parseError(refXMLData, "the file version is different from the compiler version");
        }
        this.substituteProperties(refXMLData);
        this.addResources(refXMLData, baseDir);
        try {
            specin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return refXMLData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addArchiveContent(IXMLElement fileNode, File baseDir, File archive, String targetDir, List<OsModel> osList, OverrideType override, String overrideRenameTo, Blockable blockable, PackInfo pack, Map<String, ?> additionals, String condition, Map<String, String> pack200Properties) throws Exception {
        File baseTempDir;
        ArchiveInputStream archiveInputStream;
        BufferedInputStream uncompressedInputStream;
        BufferedInputStream originalInputStream;
        block18: {
            String archiveName = archive.getName();
            originalInputStream = IOUtils.buffer((InputStream)org.apache.commons.io.FileUtils.openInputStream((File)archive));
            try {
                uncompressedInputStream = IOUtils.buffer((InputStream)new CompressorStreamFactory().createCompressorInputStream((InputStream)originalInputStream));
            }
            catch (CompressorException e) {
                uncompressedInputStream = originalInputStream;
            }
            List filesetNodes = fileNode.getChildrenNamed("archivefileset");
            boolean hasNoFileSet = filesetNodes == null || filesetNodes.isEmpty();
            archiveInputStream = null;
            baseTempDir = null;
            try {
                ArchiveEntry entry;
                archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream(archive, uncompressedInputStream);
                baseTempDir = FileUtils.createTempDirectory((String)"izpack", (File)TEMP_DIR);
                while ((entry = archiveInputStream.getNextEntry()) != null) {
                    FileOutputStream tempFileStream;
                    block17: {
                        String target;
                        String entryName = entry.getName();
                        if (entry.isDirectory()) {
                            String dName = FilenameUtils.normalizeNoEndSeparator((String)entryName);
                            File tempDir = new File(baseTempDir, dName);
                            org.apache.commons.io.FileUtils.forceMkdir((File)tempDir);
                            if (!hasNoFileSet) continue;
                            target = targetDir + "/" + dName;
                            this.logAddingFile(dName + " (" + archiveName + ")", target);
                            pack.addFile(baseTempDir, tempDir, target, osList, override, overrideRenameTo, blockable, additionals, condition, null);
                            continue;
                        }
                        tempFileStream = null;
                        try {
                            File tempFile = new File(baseTempDir, entryName);
                            tempFileStream = org.apache.commons.io.FileUtils.openOutputStream((File)tempFile);
                            IOUtils.copy((InputStream)archiveInputStream, (OutputStream)tempFileStream);
                            tempFileStream.close();
                            if (!hasNoFileSet) break block17;
                            target = targetDir + "/" + entryName;
                            this.logAddingFile(entryName + " (" + archiveName + ")", target);
                            pack.addFile(baseTempDir, tempFile, target, osList, override, overrideRenameTo, blockable, additionals, condition, pack200Properties);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(tempFileStream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)tempFileStream);
                }
                if (hasNoFileSet) break block18;
                for (IXMLElement fileSetNode : filesetNodes) {
                    this.processFileSetChildren(this.readArchiveFileSet(fileSetNode, baseTempDir, targetDir), baseTempDir, osList, pack);
                }
            }
            catch (ArchiveException e) {
                try {
                    if (baseTempDir != null) {
                        org.apache.commons.io.FileUtils.deleteDirectory(baseTempDir);
                    }
                    if (uncompressedInputStream == originalInputStream) {
                        throw new Exception("No compression or archiving format detected for file " + archive + " marked to be unpacked");
                    }
                    if (!hasNoFileSet) {
                        throw new Exception("Nested archive filesets not applicable because " + archive + " is not an archive file");
                    }
                    File temp = File.createTempFile("izpack", null, TEMP_DIR);
                    org.apache.commons.io.FileUtils.forceDeleteOnExit((File)temp);
                    org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)uncompressedInputStream, (File)temp);
                    String uncompressedArchiveName = FilenameUtils.getBaseName((String)archiveName);
                    String target = targetDir + "/" + uncompressedArchiveName;
                    this.logAddingFile(uncompressedArchiveName + " (" + archiveName + ")", target);
                    pack.addFile(baseDir, temp, target, osList, override, overrideRenameTo, blockable, additionals, condition, pack200Properties);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(archiveInputStream);
                    IOUtils.closeQuietly((InputStream)uncompressedInputStream);
                    IOUtils.closeQuietly((InputStream)originalInputStream);
                    if (baseTempDir != null) {
                        org.apache.commons.io.FileUtils.forceDeleteOnExit((File)baseTempDir);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)archiveInputStream);
                IOUtils.closeQuietly((InputStream)uncompressedInputStream);
                IOUtils.closeQuietly((InputStream)originalInputStream);
                if (baseTempDir != null) {
                    org.apache.commons.io.FileUtils.forceDeleteOnExit((File)baseTempDir);
                }
            }
        }
        IOUtils.closeQuietly((InputStream)archiveInputStream);
        IOUtils.closeQuietly((InputStream)uncompressedInputStream);
        IOUtils.closeQuietly((InputStream)originalInputStream);
        if (baseTempDir != null) {
            org.apache.commons.io.FileUtils.forceDeleteOnExit((File)baseTempDir);
        }
    }

    private void addPanels(IXMLElement data) {
        this.notifyCompilerListener("addPanels", 1, data);
        IXMLElement root = this.xmlCompilerHelper.requireChildNamed(data, "panels");
        List panels = root.getChildrenNamed("panel");
        if (panels.isEmpty()) {
            this.assertionHelper.parseError(root, "<panels> requires a <panel>");
        }
        int panelCounter = 0;
        for (IXMLElement panelElement : panels) {
            Class<IzPanel> type;
            String allowCloseStr;
            String idAttr;
            ++panelCounter;
            Panel panel = new Panel();
            panel.setOsConstraints(OsConstraintHelper.getOsList((IXMLElement)panelElement));
            String className = this.xmlCompilerHelper.requireAttribute(panelElement, "classname");
            String panelId = idAttr = panelElement.getAttribute("id");
            if (idAttr == null) {
                panelId = className + "_" + (panelCounter - 1);
            }
            panel.setPanelId(panelId);
            String conditionId = this.parseConditionAttribute(panelElement);
            if (conditionId != null) {
                panel.setCondition(conditionId);
            }
            if ((allowCloseStr = panelElement.getAttribute("allowClose")) != null) {
                boolean allowClose = Boolean.parseBoolean(allowCloseStr);
                if (allowClose) {
                    panel.setConfirmQuitType(Panel.ConfirmQuitType.SILENT);
                } else {
                    panel.setConfirmQuitType(Panel.ConfirmQuitType.CONFIRM);
                }
                List<Panel> previousPanels = this.packager.getPanelList();
                for (Panel previousPanel : previousPanels) {
                    if (previousPanel.getConfirmQuitType() != Panel.ConfirmQuitType.DYNAMIC) continue;
                    previousPanel.setConfirmQuitType(Panel.ConfirmQuitType.CONFIRM);
                }
            }
            if ((type = this.classLoader.loadClass(className, IzPanel.class)).equals(UserInputPanel.class) && (this.userInputPanelIds == null || !this.userInputPanelIds.contains(panelId))) {
                this.assertionHelper.parseError(panelElement, "Referred user input panel '" + panelId + "' has not been defined in resource " + "userInputSpec.xml");
            }
            panel.setClassName(type.getName());
            panel.readParameters(panelElement);
            List validatorElements = panelElement.getChildrenNamed("validator");
            for (IXMLElement validatorElement : validatorElements) {
                String validator = validatorElement.getAttribute("classname");
                if (validator == null || validator.isEmpty()) continue;
                String validatorCondition = validatorElement.getAttribute("condition");
                Class<DataValidator> validatorType = this.classLoader.loadClass(validator, DataValidator.class);
                DefaultConfigurationHandlerAdapter configurable = null;
                if (PanelValidator.class.isAssignableFrom(validatorType)) {
                    configurable = new DefaultConfigurationHandlerAdapter();
                    configurable.readParameters(validatorElement);
                    logger.finer("Validator " + validatorType.getName() + " extends the " + PanelValidator.class.getSimpleName() + "interface and adds " + (configurable.getNames() != null ? Integer.valueOf(configurable.getNames().size()) : "no") + " parameters");
                }
                logger.fine("Adding validator '" + validator + "' to panel '" + panel.getPanelId() + "'");
                panel.addValidator(validatorType.getName(), validatorCondition, (Configurable)configurable);
            }
            List helpSpecs = panelElement.getChildrenNamed(HELP_TAG);
            if (helpSpecs != null) {
                ArrayList<Help> helps = new ArrayList<Help>();
                for (IXMLElement help : helpSpecs) {
                    String iso3 = help.getAttribute(ISO3_ATTRIBUTE);
                    String resourceId = idAttr == null ? className + "_" + panelCounter + "_help.html_" + iso3 : idAttr + "_" + panelCounter + "_help.html_" + iso3;
                    helps.add(new Help(iso3, resourceId));
                    URL originalUrl = this.resourceFinder.findProjectResource(help.getAttribute(SRC_ATTRIBUTE), "Help", help);
                    this.packager.addResource(resourceId, originalUrl);
                }
                panel.setHelps(helps);
            }
            this.addPanelActions(panelElement, panel);
            this.packager.addPanel(panel);
        }
        this.notifyCompilerListener("addPanels", 2, data);
    }

    private void addLogging(IXMLElement data) throws CompilerException {
        List logFiles;
        this.notifyCompilerListener("addLogging", 1, data);
        IXMLElement loggingElement = data.getFirstChildNamed("logging");
        if (loggingElement == null) {
            return;
        }
        List configFiles = loggingElement.getChildrenNamed("configuration-file");
        if (configFiles != null) {
            if (configFiles.size() > 1) {
                this.assertionHelper.parseError(loggingElement, "Logging configuration by external file may only be used once");
            } else if (configFiles.size() == 1) {
                IXMLElement configFileElement = (IXMLElement)configFiles.get(0);
                String fileName = this.xmlCompilerHelper.requireAttribute(configFileElement, "file");
                URL url = this.resourceFinder.findProjectResource(fileName, "Logging configuration from file", configFileElement);
                this.packager.addResource("logging.properties", url);
                return;
            }
        }
        Properties logConfig = null;
        String globalLevel = loggingElement.getAttribute("level", "INFO");
        if (globalLevel != null) {
            logConfig = new Properties();
            logConfig.setProperty(ConsoleHandler.class.getName() + ".level", globalLevel);
            if (Level.parse(globalLevel).intValue() > Level.INFO.intValue()) {
                logConfig.setProperty("java.awt.level", globalLevel);
                logConfig.setProperty("javax.swing.level", globalLevel);
                logConfig.setProperty("sun.awt.level", globalLevel);
                logConfig.setProperty("sun.awt.X11.level", globalLevel);
            }
        }
        if ((logFiles = loggingElement.getChildrenNamed("log-file")) != null) {
            if (configFiles != null && !configFiles.isEmpty() && !logFiles.isEmpty()) {
                this.assertionHelper.parseError(loggingElement, "Logging configuration by external file and log file specification cannot be mixed");
            }
            for (IXMLElement configFileElement : logFiles) {
                String mkdirs;
                String append;
                String count;
                String limit;
                String encoding;
                String filter;
                String level;
                String cname = FileHandler.class.getName();
                if (logConfig == null) {
                    logConfig = new Properties();
                }
                logConfig.setProperty("handlers", cname);
                String pattern = configFileElement.getAttribute("pattern");
                if (pattern != null) {
                    logConfig.setProperty(cname + ".pattern", pattern);
                }
                if ((level = configFileElement.getAttribute("level", "INFO")) != null) {
                    logConfig.setProperty(cname + ".level", level);
                }
                if ((filter = configFileElement.getAttribute("filter")) != null) {
                    logConfig.setProperty(cname + ".filter", filter);
                }
                if ((encoding = configFileElement.getAttribute("encoding")) != null) {
                    logConfig.setProperty(cname + ".encoding", encoding);
                }
                if ((limit = configFileElement.getAttribute("limit")) != null) {
                    logConfig.setProperty(cname + ".limit", limit);
                }
                if ((count = configFileElement.getAttribute("count")) != null) {
                    logConfig.setProperty(cname + ".count", count);
                }
                if ((append = configFileElement.getAttribute("append")) != null) {
                    logConfig.setProperty(cname + ".append", append);
                }
                if ((mkdirs = configFileElement.getAttribute("mkdirs")) != null) {
                    logConfig.setProperty(cname + ".mkdirs", Boolean.valueOf(mkdirs).toString());
                }
                logConfig.setProperty(cname + ".formatter", FileFormatter.class.getName());
            }
            if (logConfig != null) {
                FileOutputStream os = null;
                try {
                    File temp = File.createTempFile("install_logging", ".properties", TEMP_DIR);
                    temp.deleteOnExit();
                    os = org.apache.commons.io.FileUtils.openOutputStream((File)temp);
                    logConfig.store(os, null);
                    this.packager.addResource("logging.properties", temp.toURI().toURL());
                }
                catch (IOException e) {
                    try {
                        throw new CompilerException("Unable to handle temporary resource file: " + e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(os);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        this.notifyCompilerListener("addLogging", 2, data);
    }

    private void addResources(IXMLElement data) throws CompilerException {
        this.addResources(data, new File(this.compilerData.getBasedir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResources(IXMLElement data, File baseDir) throws CompilerException {
        this.notifyCompilerListener("addResources", 1, data);
        HashMap<String, List<URL>> packsLangUrlMap = new HashMap<String, List<URL>>();
        IXMLElement root = data.getFirstChildNamed("resources");
        if (root == null) {
            return;
        }
        for (IXMLElement resNode : root.getChildrenNamed("res")) {
            String packName;
            List<IXMLElement> elList;
            URL originalUrl;
            String id = this.xmlCompilerHelper.requireAttribute(resNode, "id");
            String src = this.xmlCompilerHelper.requireAttribute(resNode, SRC_ATTRIBUTE);
            boolean substitute = this.xmlCompilerHelper.validateYesNoAttribute(resNode, "parse", NO);
            boolean parsexml = this.xmlCompilerHelper.validateYesNoAttribute(resNode, "parsexml", NO);
            String encoding = resNode.getAttribute("encoding");
            if (encoding == null) {
                encoding = "";
            }
            URL url = originalUrl = this.resourceFinder.findProjectResource(baseDir, src, "Resource", resNode);
            InputStream is = null;
            OutputStream os = null;
            try {
                Object writer;
                if (parsexml || !encoding.isEmpty() || substitute && !this.packager.getVariables().isEmpty()) {
                    File parsedFile = File.createTempFile("izpp", null, TEMP_DIR);
                    parsedFile.deleteOnExit();
                    os = org.apache.commons.io.FileUtils.openOutputStream((File)parsedFile);
                    url = parsedFile.toURI().toURL();
                }
                if (!encoding.isEmpty()) {
                    int read;
                    File recodedFile = File.createTempFile("izenc", null, TEMP_DIR);
                    recodedFile.deleteOnExit();
                    InputStreamReader reader = new InputStreamReader(originalUrl.openStream(), encoding);
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(recodedFile), "UTF-8");
                    char[] buffer = new char[1024];
                    while ((read = reader.read(buffer)) != -1) {
                        ((OutputStreamWriter)writer).write(buffer, 0, read);
                    }
                    reader.close();
                    ((OutputStreamWriter)writer).close();
                    if (parsexml) {
                        originalUrl = recodedFile.toURI().toURL();
                    } else {
                        url = recodedFile.toURI().toURL();
                    }
                }
                if (parsexml) {
                    XMLParser parser = new XMLParser(false);
                    IXMLElement xml = parser.parse(originalUrl);
                    writer = new XMLWriter();
                    if (substitute && !this.packager.getVariables().isEmpty()) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        writer.setOutput((OutputStream)baos);
                        is = new ByteArrayInputStream(baos.toByteArray());
                    } else {
                        writer.setOutput(os);
                    }
                    writer.write(xml);
                }
                if (substitute) {
                    if (this.packager.getVariables().isEmpty()) {
                        url = originalUrl;
                        this.assertionHelper.parseWarn(resNode, "No variables defined. " + url.getPath() + " not parsed.");
                    } else {
                        SubstitutionType type = SubstitutionType.lookup((String)resNode.getAttribute("type"));
                        if (null == is) {
                            is = new BufferedInputStream(originalUrl.openStream());
                        }
                        this.variableSubstitutor.substitute(is, os, type, "UTF-8");
                    }
                }
            }
            catch (Exception e) {
                this.assertionHelper.parseError(resNode, e.getMessage(), e);
            }
            finally {
                if (null != os) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            IXMLElement userInputSpec = null;
            IXMLElement antActionSpec = null;
            IXMLElement configurationSpec = null;
            if (id.startsWith("CustomLangPack.xml") || id.startsWith("userInputLang.xml") || id.startsWith("packsLang.xml")) {
                new LangPackXmlParser().parse(url);
            } else if (id.endsWith("shortcutSpec.xml")) {
                new ShortcutSpecXmlParser().parse(url);
            } else if (id.equals("customicons.xml")) {
                new IconsSpecXmlParser().parse(url);
            } else if (id.startsWith("userInputSpec.xml")) {
                userInputSpec = new UserInputSpecXmlParser().parse(url);
            } else if (id.equals("AntActionsSpec.xml")) {
                antActionSpec = new AntActionSpecXmlParser().parse(url);
            } else if (id.equals("ConfigurationActionsSpec.xml")) {
                configurationSpec = new ConfigurationActionSpecXmlParser().parse(url);
            } else if (id.equals("RegistrySpec.xml")) {
                new RegistrySpecXmlParser().parse(url);
            } else if (id.equals("ProcessPanel.Spec.xml")) {
                new ProcessingSpecXmlParser().parse(url);
            }
            if (id.startsWith("packsLang.xml")) {
                List<URL> packsLangURLs;
                if (packsLangUrlMap.containsKey(id)) {
                    packsLangURLs = (List)packsLangUrlMap.get(id);
                } else {
                    packsLangURLs = new ArrayList();
                    packsLangUrlMap.put(id, packsLangURLs);
                }
                packsLangURLs.add(url);
                continue;
            }
            this.packager.addResource(id, url);
            if (id.startsWith("userInputSpec.xml")) {
                if (userInputSpec == null) {
                    userInputSpec = new XMLParser(false).parse(url);
                }
                for (IXMLElement userPanelDef : userInputSpec.getChildrenNamed("panel")) {
                    String userPanelId = this.xmlCompilerHelper.requireAttribute(userPanelDef, "id");
                    if (this.userInputPanelIds == null) {
                        this.userInputPanelIds = new HashSet<String>();
                    }
                    if (!this.userInputPanelIds.add(userPanelId)) {
                        this.assertionHelper.parseError(userInputSpec, "Resource userInputSpec.xml: Duplicate user input panel identifier '" + userPanelId + "'");
                    }
                    for (IXMLElement fieldDef : userPanelDef.getChildrenNamed("field")) {
                        String fieldConditionId = fieldDef.getAttribute("conditionid");
                        if (fieldConditionId != null) {
                            elList = this.referencedConditionsUserInputSpec.get(fieldConditionId);
                            if (elList == null) {
                                elList = new ArrayList<IXMLElement>();
                                this.referencedConditionsUserInputSpec.put(fieldConditionId, elList);
                            }
                            elList.add(fieldDef);
                        }
                        for (IXMLElement fieldSpecDef : fieldDef.getChildrenNamed("spec")) {
                            for (IXMLElement choiceDef : fieldSpecDef.getChildrenNamed("choice")) {
                                String choiceConditionId = choiceDef.getAttribute("conditionid");
                                if (choiceConditionId == null) continue;
                                List<IXMLElement> elList2 = this.referencedConditionsUserInputSpec.get(choiceConditionId);
                                if (elList2 == null) {
                                    elList2 = new ArrayList<IXMLElement>();
                                    this.referencedConditionsUserInputSpec.put(choiceConditionId, elList2);
                                }
                                elList2.add(choiceDef);
                            }
                            for (IXMLElement runDef : fieldSpecDef.getChildrenNamed("run")) {
                                String actionClassName = runDef.getAttribute("class");
                                if (actionClassName == null) continue;
                                try {
                                    Class.forName(actionClassName);
                                }
                                catch (ClassNotFoundException e) {
                                    this.assertionHelper.parseError(userInputSpec, "Resource userInputSpec.xml: Button action class '" + actionClassName + "' cannot be loaded");
                                }
                            }
                        }
                    }
                }
                continue;
            }
            if (id.equals("AntActionsSpec.xml")) {
                if (antActionSpec == null) {
                    antActionSpec = new XMLParser(false).parse(url);
                }
                for (IXMLElement packDef : antActionSpec.getChildrenNamed("pack")) {
                    packName = this.xmlCompilerHelper.requireAttribute(packDef, "name");
                    if (this.referencedPacksAntActionSpec.put(packName, packDef) != null) {
                        this.assertionHelper.parseError(antActionSpec, "Resource AntActionsSpec.xml: Duplicate pack identifier '" + packName + "'");
                    }
                    for (IXMLElement antCallSpecDef : packDef.getChildrenNamed("antcall")) {
                        String antCallConditionId = antCallSpecDef.getAttribute("condition");
                        if (antCallConditionId == null) continue;
                        elList = this.referencedConditionsAntActionSpec.get(antCallConditionId);
                        if (elList == null) {
                            elList = new ArrayList<IXMLElement>();
                            this.referencedConditionsAntActionSpec.put(antCallConditionId, elList);
                        }
                        elList.add(antCallSpecDef);
                    }
                }
                continue;
            }
            if (!id.equals("ConfigurationActionsSpec.xml")) continue;
            if (configurationSpec == null) {
                configurationSpec = new XMLParser(false).parse(url);
            }
            for (IXMLElement packDef : configurationSpec.getChildrenNamed("pack")) {
                packName = this.xmlCompilerHelper.requireAttribute(packDef, "name");
                if (this.referencedPacksConfigurationActionSpec.put(packName, packDef) != null) {
                    this.assertionHelper.parseError(configurationSpec, "Resource ConfigurationActionsSpec.xml: Duplicate pack identifier '" + packName + "'");
                }
                for (IXMLElement configurationactionDef : packDef.getChildrenNamed("configurationaction")) {
                    List<IXMLElement> elList3;
                    String configurationConditionId;
                    for (IXMLElement configurableDef : configurationactionDef.getChildrenNamed("configurable")) {
                        configurationConditionId = configurableDef.getAttribute("condition");
                        if (configurationConditionId == null) continue;
                        elList3 = this.referencedConditionsConfigurationActionSpec.get(configurationConditionId);
                        if (elList3 == null) {
                            elList3 = new ArrayList<IXMLElement>();
                            this.referencedConditionsConfigurationActionSpec.put(configurationConditionId, elList3);
                        }
                        elList3.add(configurableDef);
                    }
                    for (IXMLElement configurablesetDef : configurationactionDef.getChildrenNamed("configurableset")) {
                        configurationConditionId = configurablesetDef.getAttribute("condition");
                        if (configurationConditionId == null) continue;
                        elList3 = this.referencedConditionsConfigurationActionSpec.get(configurationConditionId);
                        if (elList3 == null) {
                            elList3 = new ArrayList<IXMLElement>();
                            this.referencedConditionsConfigurationActionSpec.put(configurationConditionId, elList3);
                        }
                        elList3.add(configurablesetDef);
                    }
                }
            }
        }
        this.addMergedTranslationResources(packsLangUrlMap);
        this.notifyCompilerListener("addResources", 2, data);
    }

    private void addLangpacks(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addLangpacks", 1, data);
        IXMLElement root = this.xmlCompilerHelper.requireChildNamed(data, "locale");
        List locals = root.getChildrenNamed("langpack");
        if (locals.isEmpty()) {
            this.assertionHelper.parseError(root, "<locale> requires a <langpack>");
        }
        for (IXMLElement localNode : locals) {
            String iso3 = this.xmlCompilerHelper.requireAttribute(localNode, ISO3_ATTRIBUTE);
            String path = "com/izforge/izpack/bin/langpacks/installer/" + iso3 + ".xml";
            URL iso3xmlURL = this.resourceFinder.findIzPackResource(path, "ISO3 file", localNode);
            path = "com/izforge/izpack/bin/langpacks/flags/" + iso3 + ".gif";
            URL iso3FlagURL = this.resourceFinder.findIzPackResource(path, "ISO3 flag image", localNode);
            this.packager.addLangPack(iso3, iso3xmlURL, iso3FlagURL);
        }
        this.notifyCompilerListener("addLangpacks", 2, data);
    }

    private void addInfoStrings(IXMLElement data) {
        List tempdirs;
        IXMLElement isSingleInstance;
        IXMLElement readInstallInfo;
        IXMLElement writeInstallInfo;
        IXMLElement slfPath;
        String kind;
        IXMLElement webDirURL;
        IXMLElement expiresDate;
        IXMLElement jdkRequired;
        IXMLElement javaVersion;
        IXMLElement authors;
        IXMLElement URLElem;
        this.notifyCompilerListener("addInfoStrings", 1, data);
        IXMLElement root = this.xmlCompilerHelper.requireChildNamed(data, "info");
        Info info = this.compilerData.getExternalInfo();
        info.setAppName(this.xmlCompilerHelper.requireContent(this.xmlCompilerHelper.requireChildNamed(root, "appname")));
        info.setAppVersion(this.xmlCompilerHelper.requireContent(this.xmlCompilerHelper.requireChildNamed(root, "appversion")));
        IXMLElement subpath = root.getFirstChildNamed("appsubpath");
        if (subpath != null) {
            info.setInstallationSubPath(this.xmlCompilerHelper.requireContent(subpath));
        }
        if ((URLElem = root.getFirstChildNamed("url")) != null) {
            URL appURL = this.xmlCompilerHelper.requireURLContent(URLElem);
            info.setAppURL(appURL.toString());
        }
        if ((authors = root.getFirstChildNamed("authors")) != null) {
            for (IXMLElement authorNode : authors.getChildrenNamed("author")) {
                String name = this.xmlCompilerHelper.requireAttribute(authorNode, "name");
                String email = this.xmlCompilerHelper.requireAttribute(authorNode, "email");
                info.addAuthor(new Info.Author(name, email));
            }
        }
        if ((javaVersion = root.getFirstChildNamed("javaversion")) != null) {
            info.setJavaVersion(this.xmlCompilerHelper.requireContent(javaVersion));
            if (this.xmlCompilerHelper.validateYesNoAttribute(javaVersion, "strict", YES)) {
                info.setJavaVersionStrict(true);
            }
        }
        if ((jdkRequired = root.getFirstChildNamed("requiresjdk")) != null) {
            info.setJdkRequired("yes".equals(jdkRequired.getContent()));
        }
        if ((expiresDate = root.getFirstChildNamed("expiresdate")) != null) {
            try {
                info.setExpiresDate(expiresDate.getContent());
            }
            catch (ParseException e) {
                throw new CompilerException("expiresdate must be in format 'yyyy-MM-dd'", (Throwable)e);
            }
        }
        if ((webDirURL = root.getFirstChildNamed("webdir")) != null) {
            info.setWebDirURL(this.xmlCompilerHelper.requireURLContent(webDirURL).toString());
        }
        if ((kind = this.compilerData.getKind()) != null) {
            if (kind.equalsIgnoreCase("web") && webDirURL == null) {
                this.assertionHelper.parseError(root, "<webdir> required when \"WEB\" installer requested");
            } else if (kind.equalsIgnoreCase("standard") && webDirURL != null) {
                info.setWebDirURL(null);
            }
        }
        String compressionName = this.compilerData.getComprFormat();
        IXMLElement compressionElement = root.getFirstChildNamed("pack-compression-format");
        if (compressionElement != null) {
            compressionName = this.xmlCompilerHelper.requireContent(compressionElement);
        }
        if (compressionName != null) {
            PackCompression compression = PackCompression.byName((String)compressionName);
            if (compression == null) {
                throw new CompilerException("Unknown compression format: " + compressionName);
            }
            info.setCompressionFormat(compression);
            logger.info("Pack compression method: " + compression.toName());
        }
        if ((slfPath = root.getFirstChildNamed("summarylogfilepath")) != null) {
            info.setSummaryLogFilePath(this.xmlCompilerHelper.requireContent(slfPath));
        }
        if ((writeInstallInfo = root.getFirstChildNamed("writeinstallationinformation")) != null) {
            String writeInstallInfoString = this.xmlCompilerHelper.requireContent(writeInstallInfo);
            info.setWriteInstallationInformation(this.validateYesNo(writeInstallInfoString));
        }
        if ((readInstallInfo = root.getFirstChildNamed("readinstallationinformation")) != null) {
            String readInstallInfoString = this.xmlCompilerHelper.requireContent(readInstallInfo);
            info.setReadInstallationInformation(this.validateYesNo(readInstallInfoString));
        }
        if ((isSingleInstance = root.getFirstChildNamed("singleinstance")) != null) {
            String isSingleInstanceString = this.xmlCompilerHelper.requireContent(isSingleInstance);
            info.setSingleInstance(this.validateYesNo(isSingleInstanceString));
        }
        if (null != (tempdirs = root.getChildrenNamed(TEMP_DIR_ELEMENT_NAME)) && tempdirs.size() > 0) {
            HashSet<String> tempDirAttributeNames = new HashSet<String>();
            for (IXMLElement tempdir : tempdirs) {
                String variableName;
                String prefix = tempdir.hasAttribute(TEMP_DIR_PREFIX_ATTRIBUTE) ? tempdir.getAttribute(TEMP_DIR_PREFIX_ATTRIBUTE) : DEFAULT_TEMP_DIR_PREFIX;
                String suffix = tempdir.hasAttribute(TEMP_DIR_SUFFIX_ATTRIBUTE) ? tempdir.getAttribute(TEMP_DIR_SUFFIX_ATTRIBUTE) : DEFAULT_TEMP_DIR_SUFFIX;
                if (tempdir.hasAttribute(TEMP_DIR_VARIABLE_NAME_ATTRIBUTE)) {
                    variableName = tempdir.getAttribute(TEMP_DIR_VARIABLE_NAME_ATTRIBUTE);
                } else {
                    if (tempDirAttributeNames.contains(TEMP_DIR_DEFAULT_PROPERTY_NAME)) {
                        throw new CompilerException("Only one temporary directory may be specified without a variablename attribute. (Line: " + tempdir.getLineNr() + ").");
                    }
                    variableName = TEMP_DIR_DEFAULT_PROPERTY_NAME;
                }
                if (tempDirAttributeNames.contains(variableName)) {
                    throw new CompilerException("Temporary directory variable names must be unique, the name " + variableName + " is used more than once. (Line: " + tempdir.getLineNr() + ").");
                }
                tempDirAttributeNames.add(variableName);
                info.addTempDir(new Info.TempDir(variableName, prefix, suffix));
            }
        }
        this.packager.setInfo(info);
        this.notifyCompilerListener("addInfoStrings", 2, data);
    }

    private void addInfoConditional(IXMLElement data) {
        IXMLElement uninstallInfo;
        IXMLElement reboot;
        this.notifyCompilerListener("addInfoConditional", 1, data);
        IXMLElement root = this.xmlCompilerHelper.requireChildNamed(data, "info");
        Info info = this.compilerData.getExternalInfo();
        IXMLElement privileged = root.getFirstChildNamed("run-privileged");
        info.setRequirePrivilegedExecution(privileged != null);
        if (privileged != null && privileged.hasAttribute("condition")) {
            info.setPrivilegedExecutionConditionID(this.parseConditionAttribute(privileged));
        }
        if ((reboot = root.getFirstChildNamed("rebootaction")) != null) {
            String content = reboot.getContent();
            if ("ignore".equalsIgnoreCase(content)) {
                info.setRebootAction(0);
            } else if ("notice".equalsIgnoreCase(content)) {
                info.setRebootAction(1);
            } else if ("ask".equalsIgnoreCase(content)) {
                info.setRebootAction(2);
            } else if ("always".equalsIgnoreCase(content)) {
                info.setRebootAction(3);
            } else {
                throw new CompilerException("Invalid value ''" + content + "'' of element ''reboot''");
            }
            String conditionId = this.parseConditionAttribute(reboot);
            if (conditionId != null) {
                info.setRebootActionConditionID(conditionId);
            }
        }
        if (this.xmlCompilerHelper.validateYesNoAttribute(uninstallInfo = root.getFirstChildNamed("uninstaller"), "write", YES)) {
            logger.info("Adding uninstaller");
            this.mergeManager.addResourceToMerge("com/izforge/izpack/uninstaller/");
            this.mergeManager.addResourceToMerge("uninstaller-META-INF/");
            if (privileged != null) {
                info.setRequirePrivilegedExecutionUninstaller(this.xmlCompilerHelper.validateYesNoAttribute(privileged, "uninstaller", YES));
            }
            if (uninstallInfo != null) {
                String conditionId;
                String uninstallerPath;
                String uninstallerName = uninstallInfo.getAttribute("name");
                if (uninstallerName != null && uninstallerName.length() > ".jar".length()) {
                    info.setUninstallerName(uninstallerName);
                }
                if ((uninstallerPath = uninstallInfo.getAttribute("path")) != null) {
                    info.setUninstallerPath(uninstallerPath);
                }
                if ((conditionId = this.parseConditionAttribute(uninstallInfo)) != null) {
                    info.setUninstallerCondition(conditionId);
                }
            }
        } else {
            logger.info("Disable uninstaller");
            info.setUninstallerPath(null);
        }
        String unpackerclass = this.propertyManager.getProperty("UNPACKER_CLASS");
        info.setUnpackerClassName(unpackerclass);
        this.packager.setInfo(info);
        this.notifyCompilerListener("addInfoConditional", 2, data);
    }

    protected void addVariables(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addVariables", 1, data);
        IXMLElement root = data.getFirstChildNamed("variables");
        if (root == null) {
            return;
        }
        Properties variables = this.packager.getVariables();
        for (IXMLElement variableNode : root.getChildrenNamed("variable")) {
            String name = this.xmlCompilerHelper.requireAttribute(variableNode, "name");
            String value = this.xmlCompilerHelper.requireAttribute(variableNode, "value");
            if (variables.contains(name)) {
                this.assertionHelper.parseWarn(variableNode, "Variable '" + name + "' being overwritten");
            }
            variables.setProperty(name, value);
            DynamicVariableImpl dynamicVariable = new DynamicVariableImpl(name, value);
            dynamicVariable.setCheckonce(true);
            this.addDynamicVariable(variableNode, 0, name, (DynamicVariable)dynamicVariable);
        }
        this.notifyCompilerListener("addVariables", 2, data);
    }

    private int getConfigFileType(String varname, String type) throws CompilerException {
        int filetype = 0;
        if (type != null) {
            if (type.equalsIgnoreCase("options")) {
                filetype = 0;
            } else if (type.equalsIgnoreCase("xml")) {
                filetype = 2;
            } else if (type.equalsIgnoreCase("ini")) {
                filetype = 1;
            } else {
                this.assertionHelper.parseError("Error in definition of dynamic variable " + varname + ": Unknown entry type " + type);
            }
        }
        return filetype;
    }

    protected void addDynamicVariables(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addDynamicVariables", 1, data);
        IXMLElement root = data.getFirstChildNamed("dynamicvariables");
        if (root == null) {
            return;
        }
        for (IXMLElement var : root.getChildrenNamed("variable")) {
            IXMLElement filters;
            boolean escape;
            String filekey;
            String filesection;
            String stype;
            String entryname;
            String name = this.xmlCompilerHelper.requireAttribute(var, "name");
            DynamicVariableImpl dynamicVariable = new DynamicVariableImpl();
            dynamicVariable.setName(name);
            String value = var.getAttribute("value");
            if (value != null) {
                dynamicVariable.setValue((Value)new PlainValue(value));
            } else {
                IXMLElement valueElement = var.getFirstChildNamed("value");
                if (valueElement != null) {
                    value = valueElement.getContent();
                    if (value == null) {
                        this.assertionHelper.parseError("Empty value element for dynamic variable " + name);
                    }
                    dynamicVariable.setValue((Value)new PlainValue(value));
                }
            }
            value = var.getAttribute("environment");
            if (value != null) {
                if (dynamicVariable.getValue() == null) {
                    dynamicVariable.setValue((Value)new EnvironmentValue(value));
                } else {
                    this.assertionHelper.parseError("Ambiguous environment value definition for dynamic variable " + name);
                }
            }
            if ((value = var.getAttribute("regkey")) != null) {
                String regvalue = var.getAttribute("regvalue");
                if (dynamicVariable.getValue() == null) {
                    dynamicVariable.setValue((Value)new RegistryValue(value, regvalue));
                } else {
                    this.assertionHelper.parseError("Ambiguous registry value definition for dynamic variable " + name);
                }
            }
            if ((value = var.getAttribute("file")) != null) {
                String stype2 = var.getAttribute("type");
                String filesection2 = var.getAttribute("section");
                String filekey2 = this.xmlCompilerHelper.requireAttribute(var, "key");
                String escapeVal = var.getAttribute("escape");
                boolean escape2 = true;
                if (escapeVal != null) {
                    escape2 = Boolean.parseBoolean(escapeVal);
                }
                if (dynamicVariable.getValue() == null) {
                    dynamicVariable.setValue((Value)new PlainConfigFileValue(value, this.getConfigFileType(name, stype2), filesection2, filekey2, escape2));
                } else {
                    this.assertionHelper.parseError("Ambiguous file value definition for dynamic variable " + name);
                }
            }
            if ((value = var.getAttribute("zipfile")) != null) {
                entryname = this.xmlCompilerHelper.requireAttribute(var, "entry");
                stype = var.getAttribute("type");
                filesection = var.getAttribute("section");
                filekey = this.xmlCompilerHelper.requireAttribute(var, "key");
                String escapeVal = var.getAttribute("escape");
                escape = true;
                if (escapeVal != null) {
                    escape = Boolean.parseBoolean(escapeVal);
                }
                if (dynamicVariable.getValue() == null) {
                    dynamicVariable.setValue((Value)new ZipEntryConfigFileValue(value, entryname, this.getConfigFileType(name, stype), filesection, filekey, escape));
                } else {
                    this.assertionHelper.parseError("Ambiguous file value definition for dynamic variable " + name);
                }
            }
            if ((value = var.getAttribute("jarfile")) != null) {
                entryname = this.xmlCompilerHelper.requireAttribute(var, "entry");
                stype = var.getAttribute("type");
                filesection = var.getAttribute("section");
                filekey = this.xmlCompilerHelper.requireAttribute(var, "key");
                String escapeVal = var.getAttribute("escape");
                escape = true;
                if (escapeVal != null) {
                    escape = Boolean.parseBoolean(escapeVal);
                }
                if (dynamicVariable.getValue() == null) {
                    dynamicVariable.setValue((Value)new JarEntryConfigValue(value, entryname, this.getConfigFileType(name, stype), filesection, filekey, escape));
                } else {
                    this.assertionHelper.parseError("Ambiguous file value definition for dynamic variable " + name);
                }
            }
            if ((value = var.getAttribute("executable")) != null) {
                if (dynamicVariable.getValue() == null) {
                    String dir = var.getAttribute(DIR_ATTRIBUTE);
                    String exectype = var.getAttribute("type");
                    String boolval = var.getAttribute("stderr");
                    boolean stderr = true;
                    if (boolval != null) {
                        stderr = Boolean.parseBoolean(boolval);
                    }
                    if (value.length() <= 0) {
                        this.assertionHelper.parseError("No command given in definition of dynamic variable " + name);
                    }
                    Vector<String> cmd = new Vector<String>();
                    cmd.add(value);
                    List args = var.getChildrenNamed("arg");
                    if (args != null) {
                        for (IXMLElement arg : args) {
                            String content = arg.getContent();
                            if (content == null) continue;
                            cmd.add(content);
                        }
                    }
                    String[] cmdarr = new String[cmd.size()];
                    if (exectype == null || exectype.equalsIgnoreCase("process")) {
                        dynamicVariable.setValue((Value)new ExecValue(cmd.toArray(cmdarr), dir, false, stderr));
                    } else if (exectype.equalsIgnoreCase("shell")) {
                        dynamicVariable.setValue((Value)new ExecValue(cmd.toArray(cmdarr), dir, true, stderr));
                    } else {
                        this.assertionHelper.parseError("Bad execution type " + exectype + " given for dynamic variable " + name);
                    }
                } else {
                    this.assertionHelper.parseError("Ambiguous execution output value definition for dynamic variable " + name);
                }
            }
            if (dynamicVariable.getValue() == null) {
                this.assertionHelper.parseError("No value specified at all for dynamic variable " + name);
            }
            if ((value = var.getAttribute("checkonce")) != null) {
                dynamicVariable.setCheckonce(Boolean.valueOf(value).booleanValue());
            }
            if ((value = var.getAttribute("unset")) != null) {
                dynamicVariable.setAutoUnset(Boolean.valueOf(value).booleanValue());
            }
            if ((value = var.getAttribute("ignorefailure")) != null) {
                dynamicVariable.setIgnoreFailure(Boolean.valueOf(value).booleanValue());
            }
            if ((filters = var.getFirstChildNamed("filters")) != null) {
                List filterList = filters.getChildren();
                for (IXMLElement filterElement : filterList) {
                    String filterName = filterElement.getName();
                    if (filterName.equals("regex")) {
                        String expression = filterElement.getAttribute("regexp");
                        String selectexpr = filterElement.getAttribute("select");
                        String replaceexpr = filterElement.getAttribute("replace");
                        String defaultvalue = filterElement.getAttribute("defaultvalue");
                        String scasesensitive = filterElement.getAttribute("casesensitive");
                        String sglobal = filterElement.getAttribute("global");
                        dynamicVariable.addFilter((ValueFilter)new RegularExpressionFilter(expression, selectexpr, replaceexpr, defaultvalue, Boolean.valueOf(scasesensitive != null ? scasesensitive : "true"), Boolean.valueOf(sglobal != null ? sglobal : "false")));
                        continue;
                    }
                    if (filterName.equals("location")) {
                        String basedir = filterElement.getAttribute("basedir");
                        dynamicVariable.addFilter((ValueFilter)new LocationFilter(basedir));
                        continue;
                    }
                    if (filterName.equals("case")) {
                        String style = filterElement.getAttribute("style");
                        dynamicVariable.addFilter((ValueFilter)new CaseStyleFilter(style));
                        continue;
                    }
                    this.assertionHelper.parseError(String.format("Unknown filter '%s'", filterName));
                }
            }
            try {
                dynamicVariable.validate();
            }
            catch (Exception e) {
                this.assertionHelper.parseError("Error in definition of dynamic variable " + name + ": " + e.getMessage());
            }
            String conditionId = this.parseConditionAttribute(var);
            if (conditionId != null) {
                dynamicVariable.setConditionid(conditionId);
            }
            this.addDynamicVariable(var, name, (DynamicVariable)dynamicVariable);
        }
        this.notifyCompilerListener("addDynamicVariables", 2, data);
    }

    private void addDynamicVariable(IXMLElement varXml, int index, String name, DynamicVariable dynamicVariable) {
        List<Object> dynamicValues;
        Map<String, List<DynamicVariable>> dynamicvariables = this.packager.getDynamicVariables();
        if (dynamicvariables.containsKey(name)) {
            dynamicValues = dynamicvariables.get(name);
        } else {
            dynamicValues = new ArrayList();
            dynamicvariables.put(name, dynamicValues);
        }
        if (dynamicValues.remove(dynamicVariable)) {
            this.assertionHelper.parseWarn(varXml, "Variable definition '" + dynamicVariable.toString() + "' will be overwritten");
        }
        if (index < 0) {
            dynamicValues.add(dynamicVariable);
        } else {
            dynamicValues.add(index, dynamicVariable);
        }
    }

    private void addDynamicVariable(IXMLElement varXml, String name, DynamicVariable dynamicVariable) {
        this.addDynamicVariable(varXml, -1, name, dynamicVariable);
    }

    private void addDynamicInstallerRequirement(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addDynamicInstallerRequirements", 1, data);
        IXMLElement root = data.getFirstChildNamed("dynamicinstallerrequirements");
        List<DynamicInstallerRequirementValidator> dynamicReq = this.packager.getDynamicInstallerRequirements();
        if (root != null) {
            List installerRequirementList = root.getChildrenNamed("installerrequirement");
            for (IXMLElement installerrequirement : installerRequirementList) {
                DataValidator.Status severity = DataValidator.Status.valueOf((String)this.xmlCompilerHelper.requireAttribute(installerrequirement, "severity"));
                if (severity == DataValidator.Status.OK) {
                    this.assertionHelper.parseError(installerrequirement, "invalid value for attribute \"severity\"");
                }
                dynamicReq.add((DynamicInstallerRequirementValidator)new DynamicInstallerRequirementValidatorImpl(this.xmlCompilerHelper.requireAttribute(installerrequirement, "condition"), severity, this.xmlCompilerHelper.requireAttribute(installerrequirement, "messageid")));
            }
        }
        this.notifyCompilerListener("addDynamicInstallerRequirements", 2, data);
    }

    private void addConditions(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addConditions", 1, data);
        IXMLElement root = data.getFirstChildNamed("conditions");
        Map<String, Condition> conditions = this.packager.getRules();
        if (root != null) {
            for (IXMLElement conditionNode : root.getChildrenNamed("condition")) {
                try {
                    String className = this.rules.getClassName(conditionNode.getAttribute("type"));
                    Class<Condition> conditionClass = this.classLoader.loadClass(className, Condition.class);
                    Condition condition = this.rules.createCondition(conditionNode, conditionClass);
                    if (condition != null) {
                        String conditionid = condition.getId();
                        if (conditions.put(conditionid, condition) == null) continue;
                        this.assertionHelper.parseWarn(conditionNode, "Condition with id '" + conditionid + "' has been overwritten");
                        continue;
                    }
                    this.assertionHelper.parseError(conditionNode, "Error instantiating condition");
                }
                catch (Exception e) {
                    throw new CompilerException("Error reading condition at line " + conditionNode.getLineNr() + ": " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.rules.resolveConditions();
            }
            catch (Exception e) {
                throw new CompilerException("Conditions check failed: " + e.getMessage(), (Throwable)e);
            }
        }
        this.notifyCompilerListener("addConditions", 2, data);
    }

    private void substituteProperties(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("substituteProperties", 1, data);
        IXMLElement root = data.getFirstChildNamed("properties");
        if (root != null) {
            for (IXMLElement propertyNode : root.getChildrenNamed("property")) {
                this.propertyManager.execute(propertyNode);
            }
        }
        if (root != null) {
            data.removeChild(root);
        }
        this.substituteAllProperties(data);
        if (root != null) {
            data.addChild(root);
        }
        this.notifyCompilerListener("substituteProperties", 2, data);
    }

    private void substituteAllProperties(IXMLElement element) throws CompilerException {
        Enumeration attributes = element.enumerateAttributeNames();
        while (attributes.hasMoreElements()) {
            String name = (String)attributes.nextElement();
            try {
                String value = this.variableSubstitutor.substitute(element.getAttribute(name), SubstitutionType.TYPE_AT);
                element.setAttribute(name, value);
            }
            catch (Exception e) {
                this.assertionHelper.parseWarn(element, "Value of attribute \"" + name + "\" could not be substituted (" + e.getMessage() + ")");
            }
        }
        String content = element.getContent();
        if (content != null) {
            try {
                element.setContent(this.variableSubstitutor.substitute(content, SubstitutionType.TYPE_AT));
            }
            catch (Exception e) {
                this.assertionHelper.parseWarn(element, "Embedded content could not be substituted (" + e.getMessage() + ")");
            }
        }
        for (int i = 0; i < element.getChildren().size(); ++i) {
            IXMLElement child = (IXMLElement)element.getChildren().get(i);
            this.substituteAllProperties(child);
        }
    }

    private OverrideType getOverrideValue(IXMLElement fileElement) throws CompilerException {
        String override_val = fileElement.getAttribute("override");
        if (override_val == null) {
            return OverrideType.OVERRIDE_UPDATE;
        }
        OverrideType override = OverrideType.getOverrideTypeFromAttribute((String)override_val);
        if (override == null) {
            this.assertionHelper.parseError(fileElement, "invalid value for attribute \"override\"");
        }
        return override;
    }

    private String getOverrideRenameToValue(IXMLElement f) throws CompilerException {
        String override_val = f.getAttribute("override");
        String overrideRenameTo = f.getAttribute("overrideRenameTo");
        if (overrideRenameTo != null && override_val == null) {
            this.assertionHelper.parseError(f, "Attribute \"overrideRenameTo\" requires attribute \"override\" to be set");
        }
        return overrideRenameTo;
    }

    private Blockable getBlockableValue(IXMLElement blockableElement, List<OsModel> osList) throws CompilerException {
        String blockable_val = blockableElement.getAttribute("blockable");
        if (blockable_val == null) {
            return Blockable.BLOCKABLE_NONE;
        }
        Blockable blockable = Blockable.getBlockableFromAttribute((String)blockable_val);
        if (blockable == null) {
            this.assertionHelper.parseError(blockableElement, "invalid value for attribute \"blockable\"");
        }
        if (blockable != Blockable.BLOCKABLE_NONE) {
            boolean found = false;
            for (OsModel anOsList : osList) {
                if (!"windows".equals(anOsList.getFamily())) continue;
                found = true;
            }
            if (!found) {
                this.assertionHelper.parseWarn(blockableElement, "'blockable' will apply only on Windows target systems");
            }
        }
        return blockable;
    }

    private boolean validateYesNo(String value) {
        boolean result = "yes".equalsIgnoreCase(value) ? true : ("no".equalsIgnoreCase(value) ? false : Boolean.valueOf(value));
        return result;
    }

    private void addListeners(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addListeners", 1, data);
        IXMLElement listeners = data.getFirstChildNamed("listeners");
        if (listeners != null) {
            for (IXMLElement listener : listeners.getChildrenNamed("listener")) {
                String className = this.xmlCompilerHelper.requireAttribute(listener, "classname");
                Stage stage = Stage.valueOf((String)this.xmlCompilerHelper.requireAttribute(listener, "stage"));
                if (!Stage.isInInstaller((Stage)stage)) continue;
                List constraints = OsConstraintHelper.getOsList((IXMLElement)listener);
                this.compiler.addListener(className, stage, constraints);
            }
        }
        this.notifyCompilerListener("addListeners", 2, data);
    }

    private void addCompilerListeners(IXMLElement data) throws CompilerException {
        IXMLElement listeners = data.getFirstChildNamed("listeners");
        if (listeners != null) {
            for (IXMLElement listener : listeners.getChildrenNamed("listener")) {
                String className = this.xmlCompilerHelper.requireAttribute(listener, "classname");
                Stage stage = Stage.valueOf((String)this.xmlCompilerHelper.requireAttribute(listener, "stage"));
                if (!Stage.compiler.equals((Object)stage)) continue;
                List osConstraints = OsConstraintHelper.getOsList((IXMLElement)listener);
                boolean matchesCurrentSystem = false;
                if (osConstraints.isEmpty()) {
                    matchesCurrentSystem = true;
                } else if (this.constraints.matchesCurrentPlatform(osConstraints)) {
                    matchesCurrentSystem = true;
                }
                if (!matchesCurrentSystem) continue;
                Class<CompilerListener> clazz = this.classLoader.loadClass(className, CompilerListener.class);
                CompilerListener l = (CompilerListener)this.factory.create(clazz, new Object[]{CompilerListener.class});
                this.compilerListeners.add(l);
            }
        }
    }

    private void notifyCompilerListener(String callerName, int state, IXMLElement data) {
        for (CompilerListener compilerListener : this.compilerListeners) {
            compilerListener.notify(callerName, state, data, this.packager);
        }
    }

    private Map<String, ?> getAdditionals(IXMLElement fileElement) throws CompilerException {
        Map<String, ?> retval = null;
        try {
            for (CompilerListener compilerListener : this.compilerListeners) {
                retval = compilerListener.reviseAdditionalDataMap(retval, fileElement);
            }
        }
        catch (CompilerException ce) {
            this.assertionHelper.parseError(fileElement, ce.getMessage());
        }
        return retval;
    }

    private void addMergedTranslationResources(Map<String, List<URL>> resourceUrlMap) throws CompilerException {
        if (resourceUrlMap.size() <= 0) {
            return;
        }
        OutputStream os = null;
        try {
            for (String id : resourceUrlMap.keySet()) {
                URL mergedPackLangFileURL;
                List<URL> packsLangURLs = resourceUrlMap.get(id);
                if (packsLangURLs.size() == 0) continue;
                if (packsLangURLs.size() == 1) {
                    mergedPackLangFileURL = packsLangURLs.get(0);
                } else {
                    IXMLElement mergedPacksLang = null;
                    for (URL packslangURL : packsLangURLs) {
                        IXMLElement xml = new XMLParser(false).parse(packslangURL);
                        if (mergedPacksLang == null) {
                            mergedPacksLang = xml;
                            continue;
                        }
                        List langStrings = xml.getChildrenNamed("str");
                        for (IXMLElement langString : langStrings) {
                            mergedPacksLang.addChild(langString);
                        }
                    }
                    File mergedPackLangFile = File.createTempFile("izpp", null, TEMP_DIR);
                    mergedPackLangFile.deleteOnExit();
                    os = org.apache.commons.io.FileUtils.openOutputStream((File)mergedPackLangFile);
                    XMLWriter xmlWriter = new XMLWriter(os);
                    xmlWriter.write(mergedPacksLang);
                    os.close();
                    os = null;
                    mergedPackLangFileURL = mergedPackLangFile.toURI().toURL();
                }
                this.packager.addResource(id, mergedPackLangFileURL);
            }
        }
        catch (Exception e) {
            throw new CompilerException("Unable to merge multiple packsLang.xml files: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void addPanelActions(IXMLElement xmlPanel, Panel panel) throws CompilerException {
        IXMLElement xmlActions = xmlPanel.getFirstChildNamed("actions");
        if (xmlActions != null) {
            List actionList = xmlActions.getChildrenNamed("action");
            if (actionList != null) {
                for (IXMLElement action : actionList) {
                    String stage = this.xmlCompilerHelper.requireAttribute(action, "stage");
                    String actionName = this.xmlCompilerHelper.requireAttribute(action, "classname");
                    Class<PanelAction> actionType = this.classLoader.loadClass(actionName, PanelAction.class);
                    List params = action.getChildrenNamed("param");
                    PanelActionConfiguration config = new PanelActionConfiguration(actionType.getName());
                    for (IXMLElement param : params) {
                        String name = this.xmlCompilerHelper.requireAttribute(param, "name");
                        String value = this.xmlCompilerHelper.requireAttribute(param, "value");
                        logger.fine("Adding configuration property " + name + " with value " + value + " for action " + actionName);
                        config.addProperty(name, value);
                    }
                    try {
                        PanelAction.ActionStage actionStage = PanelAction.ActionStage.valueOf((String)stage);
                        switch (actionStage) {
                            case preconstruct: {
                                panel.addPreConstructionAction(config);
                                break;
                            }
                            case preactivate: {
                                panel.addPreActivationAction(config);
                                break;
                            }
                            case prevalidate: {
                                panel.addPreValidationAction(config);
                                break;
                            }
                            case postvalidate: {
                                panel.addPostValidationAction(config);
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.assertionHelper.parseError(action, "Invalid value [" + stage + "] for attribute : " + "stage");
                    }
                }
            } else {
                this.assertionHelper.parseError(xmlActions, "<actions> requires a <action>");
            }
        }
    }

    private List<TargetFileSet> readFileSets(IXMLElement parent, File baseDir) throws CompilerException {
        ArrayList<TargetFileSet> fslist = new ArrayList<TargetFileSet>();
        for (IXMLElement fileSetNode : parent.getChildrenNamed("fileset")) {
            try {
                fslist.add(this.readFileSet(fileSetNode, baseDir));
            }
            catch (Exception e) {
                throw new CompilerException(e.getMessage());
            }
        }
        return fslist;
    }

    private TargetFileSet readFileSet(IXMLElement fileSetNode, File baseDir) throws CompilerException {
        String dir_attr = this.getDirSubstitutedAttributeValue(fileSetNode);
        File extractedBaseDir = baseDir;
        if (dir_attr != null) {
            extractedBaseDir = FileUtil.getAbsoluteFile((String)dir_attr, (String)baseDir.getAbsolutePath());
        }
        String targetDir = fileSetNode.getAttribute("targetdir", "${INSTALL_PATH}");
        return this.readFileSet(fileSetNode, extractedBaseDir, targetDir);
    }

    private TargetFileSet readArchiveFileSet(IXMLElement fileSetNode, File baseDir, String targetDir) throws CompilerException {
        String dir_attr = this.getDirSubstitutedAttributeValue(fileSetNode);
        File extractedBaseDir = baseDir;
        if (dir_attr != null && !(extractedBaseDir = new File(baseDir, dir_attr)).exists()) {
            this.assertionHelper.parseError(fileSetNode, "Archive does not contain a base directory " + dir_attr);
        }
        return this.readFileSet(fileSetNode, extractedBaseDir, targetDir);
    }

    private TargetFileSet readFileSet(IXMLElement fileSetNode, File baseDir, String targetDir) throws CompilerException {
        String boolval;
        TargetFileSet fs = new TargetFileSet();
        fs.setTargetDir(targetDir);
        List osList = OsConstraintHelper.getOsList((IXMLElement)fileSetNode);
        fs.setOsList(osList);
        fs.setOverride(this.getOverrideValue(fileSetNode));
        fs.setOverrideRenameTo(this.getOverrideRenameToValue(fileSetNode));
        fs.setBlockable(this.getBlockableValue(fileSetNode, osList));
        fs.setAdditionals(this.getAdditionals(fileSetNode));
        String conditionId = this.parseConditionAttribute(fileSetNode);
        if (conditionId != null) {
            fs.setCondition(conditionId);
        }
        try {
            fs.setDir(baseDir);
        }
        catch (Exception e) {
            throw new CompilerException(e.getMessage());
        }
        String attr = fileSetNode.getAttribute("includes");
        if (attr != null) {
            fs.setIncludes(attr);
        }
        if ((attr = fileSetNode.getAttribute("excludes")) != null) {
            fs.setExcludes(attr);
        }
        if ((boolval = fileSetNode.getAttribute("casesensitive")) != null) {
            fs.setCaseSensitive(Boolean.parseBoolean(boolval));
        }
        if ((boolval = fileSetNode.getAttribute("defaultexcludes")) != null) {
            fs.setDefaultexcludes(Boolean.parseBoolean(boolval));
        }
        if ((boolval = fileSetNode.getAttribute("followsymlinks")) != null) {
            fs.setFollowSymlinks(Boolean.parseBoolean(boolval));
        }
        fs.setPack200Properties(this.readPack200Properties(fileSetNode));
        this.readAndAddIncludes(fileSetNode, fs);
        this.readAndAddExcludes(fileSetNode, fs);
        return fs;
    }

    private void readAndAddIncludes(IXMLElement parent, TargetFileSet fileset) throws CompilerException {
        for (IXMLElement f : parent.getChildrenNamed("include")) {
            fileset.createInclude().setName(this.variableSubstitutor.substitute(this.xmlCompilerHelper.requireAttribute(f, "name")));
        }
    }

    private void readAndAddExcludes(IXMLElement parent, TargetFileSet fileset) throws CompilerException {
        for (IXMLElement f : parent.getChildrenNamed("exclude")) {
            fileset.createExclude().setName(this.variableSubstitutor.substitute(this.xmlCompilerHelper.requireAttribute(f, "name")));
        }
    }

    private String parseConditionAttribute(IXMLElement element) {
        String conditionId = element.getAttribute("condition");
        if (conditionId != null) {
            List<IXMLElement> elList = this.referencedConditions.get(conditionId);
            if (elList == null) {
                elList = new ArrayList<IXMLElement>();
                this.referencedConditions.put(conditionId, elList);
            }
            elList.add(element);
        }
        return conditionId;
    }

    private boolean checkReferencedConditions(Map<String, List<IXMLElement>> referringElements, AssertionHelper assertionHelper) {
        boolean failure = false;
        for (String conditionId : referringElements.keySet()) {
            if (this.rules.getCondition(conditionId) != null) continue;
            List<IXMLElement> elList = referringElements.get(conditionId);
            for (IXMLElement element : elList) {
                assertionHelper.parseWarn(element, "Expression '" + conditionId + "' contains reference(s) to undefined condition(s)");
                failure = true;
            }
        }
        return failure;
    }

    private void checkReferencedConditions() {
        boolean failure = this.checkReferencedConditions(this.referencedConditions, this.assertionHelper);
        failure |= this.checkReferencedConditions(this.referencedConditionsUserInputSpec, new AssertionHelper("Resource userInputSpec.xml"));
        failure |= this.checkReferencedConditions(this.referencedConditionsAntActionSpec, new AssertionHelper("Resource AntActionsSpec.xml"));
        if (failure |= this.checkReferencedConditions(this.referencedConditionsConfigurationActionSpec, new AssertionHelper("Resource ConfigurationActionsSpec.xml"))) {
            throw new CompilerException("Cannot recover from reference(s) to undefined condition(s) listed above");
        }
    }

    private void checkReferencedPacks() {
        IXMLElement element;
        AssertionHelper antActionSpecAssertionHelper = new AssertionHelper("Resource AntActionsSpec.xml");
        AssertionHelper configurationSpecAssertionHelper = new AssertionHelper("Resource ConfigurationActionsSpec.xml");
        List<PackInfo> packs = this.packager.getPacksList();
        HashSet<String> definedPackNames = new HashSet<String>(packs.size());
        for (PackInfo packInfo : packs) {
            definedPackNames.add(packInfo.getPack().getName());
        }
        for (String packName : this.referencedPacksAntActionSpec.keySet()) {
            if (definedPackNames.contains(packName)) continue;
            element = this.referencedPacksAntActionSpec.get(packName);
            antActionSpecAssertionHelper.parseError(element, "Expression '" + packName + "' refers to undefined pack");
        }
        for (String packName : this.referencedPacksConfigurationActionSpec.keySet()) {
            if (definedPackNames.contains(packName)) continue;
            element = this.referencedPacksConfigurationActionSpec.get(packName);
            configurationSpecAssertionHelper.parseError(element, "Expression '" + packName + "' refers to undefined pack");
        }
    }

    private String getSrcSubstitutedAttributeValue(IXMLElement node) {
        return this.getSubstitutedAttributeValue(node, SRC_ATTRIBUTE);
    }

    private String getDirSubstitutedAttributeValue(IXMLElement node) {
        return this.getSubstitutedAttributeValue(node, DIR_ATTRIBUTE);
    }

    private String getSubstitutedAttributeValue(IXMLElement node, String attribute) {
        String attributeValue = this.xmlCompilerHelper.requireAttribute(node, attribute);
        return this.variableSubstitutor.substitute(attributeValue);
    }

    private void logAddingFile(String source, String target) {
        logger.log(Level.FINE, "Adding file {0} => {1}", new String[]{source, target.replaceFirst("\\$\\{*INSTALL_PATH}*[/\\\\]+", "")});
    }

    private void logMarkFileExecutable(String target) {
        logger.log(Level.INFO, "Marked target file executable: {0}", new String[]{target.replaceFirst("\\$\\{*INSTALL_PATH}*[/\\\\]+", "")});
    }

    private void logMarkFileParsable(String target) {
        logger.log(Level.INFO, "Marked target file parsable: {0}", new String[]{target.replaceFirst("\\$\\{*INSTALL_PATH}*[/\\\\]+", "")});
    }

    private void logAddingPack(PackInfo packInfo) {
        logger.log(Level.INFO, "Adding pack {0} containing {1} files", new String[]{packInfo.getPack().getName(), Integer.toString(packInfo.getPackFiles().size())});
    }

    private void logCombineOsLists(List<OsModel> parentOsList, List<OsModel> osList, List<OsModel> commonOsList) {
        logger.log(Level.INFO, "Combined parent''s OS constraints:\n\t{0}\nwith node''s:\n\t{1}\ninto:\n\t{2}", new String[]{OsConstraintHelper.toOsContraintsString(parentOsList), OsConstraintHelper.toOsContraintsString(osList), OsConstraintHelper.toOsContraintsString(commonOsList)});
    }

    static {
        TEMP_DIR = org.apache.commons.io.FileUtils.getTempDirectory();
        YES = Boolean.TRUE;
        NO = Boolean.FALSE;
    }
}

