/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;

public class WideningCategories {
    public static boolean isIntCategory(ClassNode type) {
        return type == ClassHelper.byte_TYPE || type == ClassHelper.Byte_TYPE || type == ClassHelper.char_TYPE || type == ClassHelper.Character_TYPE || type == ClassHelper.int_TYPE || type == ClassHelper.Integer_TYPE || type == ClassHelper.short_TYPE || type == ClassHelper.Short_TYPE;
    }

    public static boolean isLongCategory(ClassNode type) {
        return type == ClassHelper.long_TYPE || type == ClassHelper.Long_TYPE || WideningCategories.isIntCategory(type);
    }

    public static boolean isBigIntCategory(ClassNode type) {
        return type == ClassHelper.BigInteger_TYPE || WideningCategories.isLongCategory(type);
    }

    public static boolean isBigDecCategory(ClassNode type) {
        return type == ClassHelper.BigDecimal_TYPE || WideningCategories.isBigIntCategory(type);
    }

    public static boolean isDoubleCategory(ClassNode type) {
        return type == ClassHelper.float_TYPE || type == ClassHelper.Float_TYPE || type == ClassHelper.double_TYPE || type == ClassHelper.Double_TYPE || WideningCategories.isBigDecCategory(type);
    }

    public static boolean isNumberCategory(ClassNode type) {
        return WideningCategories.isBigDecCategory(type) || type.isDerivedFrom(ClassHelper.Number_TYPE);
    }
}

