/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.codehaus.gmaven.plugin.util.VersionHelper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=GroovyVersionHelper.class)
public class GroovyVersionHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private VersionHelper versionHelper;

    public GroovyVersionHelper() {
    }

    @VisibleForTesting
    public GroovyVersionHelper(VersionHelper versionHelper) {
        this.versionHelper = (VersionHelper)Preconditions.checkNotNull((Object)versionHelper);
    }

    @Nullable
    public Version detectVersion(ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)classLoader);
        this.log.trace("Detecting Groovy version; class-loader: {}", (Object)classLoader);
        String raw = this.getVersion(classLoader, "groovy.lang.GroovySystem", "getVersion");
        if (raw == null) {
            raw = this.getVersion(classLoader, "org.codehaus.groovy.runtime.InvokerHelper", "getVersion");
        }
        this.log.trace("Raw version: {}", (Object)raw);
        if (raw == null) {
            return null;
        }
        Version version = this.versionHelper.parseVersion(raw);
        this.log.trace("Version: {}", (Object)version);
        return version;
    }

    private String getVersion(ClassLoader classLoader, String className, String methodName) {
        this.log.trace("Getting version; class-loader: {}, class-name: {}, method-name: {}", new Object[]{classLoader, className, methodName});
        try {
            Class<?> type = classLoader.loadClass(className);
            Method method = type.getMethod(methodName, new Class[0]);
            Object result = method.invoke(null, new Object[0]);
            if (result != null) {
                return result.toString();
            }
        }
        catch (Throwable e) {
            this.log.trace("Unable determine version from: {}", (Object)className);
        }
        return null;
    }
}

