/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.codehaus.gmaven.adapter.GroovyRuntime;
import org.codehaus.plexus.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=GroovyRuntimeFactory.class)
public class GroovyRuntimeFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public GroovyRuntime create(ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)classLoader);
        Iterator<GroovyRuntime> services = this.findServices(classLoader);
        Preconditions.checkState((boolean)services.hasNext(), (Object)"No GroovyRuntime service found");
        GroovyRuntime runtime = services.next();
        Preconditions.checkState((!services.hasNext() ? 1 : 0) != 0, (Object)"Multiple GroovyRuntime services found");
        this.log.debug("Runtime: {}", (Object)runtime);
        return runtime;
    }

    @VisibleForTesting
    protected Iterator<GroovyRuntime> findServices(ClassLoader classLoader) {
        ServiceLoader<GroovyRuntime> serviceLoader = ServiceLoader.load(GroovyRuntime.class, classLoader);
        this.log.debug("Loader: {}", serviceLoader);
        return serviceLoader.iterator();
    }
}

