/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.adapter.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyResourceLoader;
import groovy.util.AntBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.apache.tools.ant.BuildLogger;
import org.codehaus.gmaven.adapter.ClassSource;
import org.codehaus.gmaven.adapter.ClosureTarget;
import org.codehaus.gmaven.adapter.ConsoleWindow;
import org.codehaus.gmaven.adapter.GroovyRuntime;
import org.codehaus.gmaven.adapter.MagicContext;
import org.codehaus.gmaven.adapter.ResourceLoader;
import org.codehaus.gmaven.adapter.ScriptExecutor;
import org.codehaus.gmaven.adapter.ShellRunner;
import org.codehaus.gmaven.adapter.impl.ConsoleWindowImpl;
import org.codehaus.gmaven.adapter.impl.ScriptExecutorImpl;
import org.codehaus.gmaven.adapter.impl.ShellRunnerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyRuntimeImpl
implements GroovyRuntime {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ScriptExecutor createScriptExecutor() {
        return new ScriptExecutorImpl(this);
    }

    public ConsoleWindow createConsoleWindow() {
        return new ConsoleWindowImpl(this);
    }

    public ShellRunner createShellRunner() {
        return new ShellRunnerImpl(this);
    }

    public void cleanup() {
    }

    public GroovyClassLoader createGroovyClassLoader(final ClassLoader classLoader, final ResourceLoader resourceLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

            @Override
            public GroovyClassLoader run() {
                GroovyClassLoader gcl = new GroovyClassLoader(classLoader);
                gcl.setResourceLoader(GroovyRuntimeImpl.this.createGroovyResourceLoader(resourceLoader));
                return gcl;
            }
        });
    }

    public GroovyResourceLoader createGroovyResourceLoader(final ResourceLoader resourceLoader) {
        Preconditions.checkNotNull((Object)resourceLoader);
        return new GroovyResourceLoader(){

            public URL loadGroovySource(String name) throws MalformedURLException {
                return resourceLoader.loadResource(name);
            }
        };
    }

    public GroovyCodeSource createGroovyCodeSource(ClassSource source) throws IOException {
        Preconditions.checkNotNull((Object)source);
        if (source.getUrl() != null) {
            return new GroovyCodeSource(source.getUrl());
        }
        if (source.getFile() != null) {
            return new GroovyCodeSource(source.getFile());
        }
        if (source.getInline() != null) {
            ClassSource.Inline inline = source.getInline();
            return new GroovyCodeSource(inline.getInput(), inline.getName(), inline.getCodeBase());
        }
        throw new Error("Unable to create GroovyCodeSource from: " + source);
    }

    public Closure createClosure(final Object owner, final ClosureTarget target) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)target);
        return new Closure(owner){

            public Object call(Object[] args) {
                try {
                    return target.call(args);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            public String toString() {
                return Closure.class.getSimpleName() + "{owner=" + owner + ", target=" + target + "}";
            }
        };
    }

    public Object createMagicContextValue(MagicContext magic) {
        Preconditions.checkNotNull((Object)magic);
        switch (magic) {
            case ANT_BUILDER: {
                AntBuilder ant = new AntBuilder();
                Object obj = ant.getAntProject().getBuildListeners().elementAt(0);
                if (obj instanceof BuildLogger) {
                    BuildLogger logger = (BuildLogger)obj;
                    logger.setEmacsMode(true);
                }
                return ant;
            }
        }
        throw new Error("Unsupported magic context: " + magic);
    }

    public Binding createBinding(Map<String, Object> context) {
        Binding binding = new Binding();
        this.log.debug("Binding:");
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof ClosureTarget) {
                value = this.createClosure(this, (ClosureTarget)value);
            } else if (value instanceof MagicContext) {
                value = this.createMagicContextValue((MagicContext)value);
            }
            this.log.debug("  {}={}", (Object)key, value);
            binding.setVariable(entry.getKey(), value);
        }
        return binding;
    }
}

