/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.fit.component.initialize.ConfigurationParameterInitializer;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.initializable.Initializable;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.DirectoryDataWriterFactory;
import org.cleartk.ml.jar.EncodingDirectoryDataWriter;
import org.cleartk.util.CleartkInitializationException;
import org.cleartk.util.ReflectionUtil;

public abstract class EncodingDirectoryDataWriterFactory<ENCODED_FEATURES_TYPE, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE>
extends DirectoryDataWriterFactory
implements Initializable {
    public static final String PARAM_LOAD_ENCODERS_FROM_FILE_SYSTEM = "loadEncodersFromFileSystem";
    @ConfigurationParameter(name="loadEncodersFromFileSystem", mandatory=false, description="when true indicates that the FeaturesEncoder and OutcomeEncoder should be loaded from the file system instead of being created by the DataWriterFactory", defaultValue={"false"})
    private boolean loadEncodersFromFileSystem = false;
    protected FeaturesEncoder<ENCODED_FEATURES_TYPE> featuresEncoder = null;
    protected OutcomeEncoder<OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> outcomeEncoder = null;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        ConfigurationParameterInitializer.initialize((Object)this, (UimaContext)context);
        if (this.loadEncodersFromFileSystem) {
            try {
                File encoderFile = new File(this.outputDirectory, "encoders.ser");
                if (!encoderFile.exists()) {
                    throw CleartkInitializationException.fileNotFound((File)encoderFile);
                }
                ObjectInputStream is = new ObjectInputStream(new FileInputStream(encoderFile));
                FeaturesEncoder untypedFeaturesEncoder = (FeaturesEncoder)FeaturesEncoder.class.cast(is.readObject());
                ReflectionUtil.checkTypeParameterIsAssignable(FeaturesEncoder.class, (String)"ENCODED_FEATURES_TYPE", (Object)untypedFeaturesEncoder, EncodingDirectoryDataWriterFactory.class, (String)"ENCODED_FEATURES_TYPE", (Object)this);
                OutcomeEncoder untypedOutcomeEncoder = (OutcomeEncoder)OutcomeEncoder.class.cast(is.readObject());
                ReflectionUtil.checkTypeParameterIsAssignable(OutcomeEncoder.class, (String)"OUTCOME_TYPE", (Object)untypedOutcomeEncoder, EncodingDirectoryDataWriterFactory.class, (String)"OUTCOME_TYPE", (Object)this);
                ReflectionUtil.checkTypeParameterIsAssignable(OutcomeEncoder.class, (String)"ENCODED_OUTCOME_TYPE", (Object)untypedOutcomeEncoder, EncodingDirectoryDataWriterFactory.class, (String)"ENCODED_OUTCOME_TYPE", (Object)this);
                this.featuresEncoder = (FeaturesEncoder)ReflectionUtil.uncheckedCast((Object)untypedFeaturesEncoder);
                this.outcomeEncoder = (OutcomeEncoder)ReflectionUtil.uncheckedCast((Object)untypedOutcomeEncoder);
                is.close();
            }
            catch (Exception e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    protected boolean setEncodersFromFileSystem(EncodingDirectoryDataWriter<?, ?, ENCODED_FEATURES_TYPE, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> dataWriter) {
        if (this.featuresEncoder != null && this.outcomeEncoder != null) {
            dataWriter.setFeaturesEncoder(this.featuresEncoder);
            dataWriter.setOutcomeEncoder(this.outcomeEncoder);
            return true;
        }
        return false;
    }
}

