/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml;

import java.io.Serializable;

public class Feature
implements Serializable {
    private static final long serialVersionUID = -3215288856677656204L;
    protected String name;
    protected Object value;

    public Feature() {
    }

    public Feature(Object value) {
        this.value = value;
    }

    public Feature(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public static Feature createFeature(String namePrefix, Feature feature) {
        return new Feature(Feature.createName(namePrefix, feature.name), feature.value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String createName(String ... names) {
        StringBuffer buffer = new StringBuffer();
        for (String name : names) {
            if (name == null) continue;
            buffer.append(name);
            buffer.append('_');
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public String toString() {
        String className = Feature.class.getSimpleName();
        return String.format("%s(<%s>, <%s>)", className, this.name, this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Feature) {
            Feature other = (Feature)obj;
            boolean nameMatch = this.name == null && other.name == null || this.name != null && this.name.equals(other.name);
            boolean valueMatch = this.value == null && other.value == null || this.value != null && this.value.equals(other.value);
            return nameMatch && valueMatch;
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (this.name == null ? 0 : this.name.hashCode());
        hash = hash * 31 + (this.value == null ? 0 : this.value.hashCode());
        return hash;
    }
}

