/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlUtils {
    private static final Logger logger = LoggerFactory.getLogger(SqlUtils.class);
    public static final String SQL_COMMENT = "--";
    public static final String STMT_ENDING = ";";

    private SqlUtils() {
    }

    public static List<String> createStatementsFromFileResource(Resource sqlResource) {
        return SqlUtils.createStatementsFromFileResource(sqlResource, null);
    }

    public static List<String> createStatementsFromFileResource(Resource sqlResource, LastScriptLineDecorator lineDecorator) {
        BufferedReader reader = null;
        ArrayList<String> stmts = new ArrayList<String>();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Create statements from SQL file: " + sqlResource.getFile().getAbsolutePath());
            }
            reader = new BufferedReader(new InputStreamReader(sqlResource.getInputStream()));
            StringBuilder buffer = new StringBuilder();
            while (reader.ready()) {
                String line = reader.readLine();
                if (line == null || line.trim().startsWith(SQL_COMMENT) || line.trim().isEmpty()) continue;
                if (line.trim().endsWith(SqlUtils.getStatementEndingCharacter(lineDecorator))) {
                    if (lineDecorator != null) {
                        buffer.append(lineDecorator.decorate(line));
                    } else {
                        buffer.append(line);
                    }
                    String stmt = buffer.toString().trim();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found statement: " + stmt);
                    }
                    stmts.add(stmt);
                    buffer.setLength(0);
                    buffer = new StringBuilder();
                    continue;
                }
                buffer.append(line);
                buffer.append("\n");
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Resource could not be found - filename: " + sqlResource, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.warn("Warning: Error while closing reader instance", (Throwable)e);
                }
            }
        }
        return stmts;
    }

    public static String getStatementEndingCharacter(LastScriptLineDecorator lineDecorator) {
        if (lineDecorator != null) {
            return lineDecorator.getStatementEndingCharacter();
        }
        return STMT_ENDING;
    }

    public static interface LastScriptLineDecorator {
        public String decorate(String var1);

        public String getStatementEndingCharacter();
    }
}

