/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.sql.yaml;

import java.util.List;
import javax.sql.DataSource;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.ExecutePLSQLAction;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.springframework.transaction.PlatformTransactionManager;

public class Plsql
implements TestActionBuilder<ExecutePLSQLAction>,
ReferenceResolverAware {
    private final ExecutePLSQLAction.Builder builder = new ExecutePLSQLAction.Builder();
    private String dataSource;
    private String transactionManager;
    private ReferenceResolver referenceResolver;

    public void setDescription(String value) {
        this.builder.description(value);
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
        this.builder.name(String.format("plsql:%s", dataSource));
    }

    public void setStatements(List<Statement> statements) {
        for (Statement statement : statements) {
            if (statement.statement != null) {
                this.builder.statement(statement.statement);
            }
            if (statement.file != null) {
                this.builder.sqlResource(statement.file);
            }
            if (statement.script == null) continue;
            this.builder.sqlScript(statement.script);
        }
    }

    public void setTransaction(Transaction transaction) {
        if (transaction.manager != null) {
            this.transactionManager = transaction.manager;
        }
        if (transaction.isolationLevel != null) {
            this.builder.transactionIsolationLevel(transaction.isolationLevel);
        }
        if (transaction.timeout != null) {
            this.builder.transactionTimeout(transaction.timeout);
        }
    }

    public void setIgnoreErrors(boolean value) {
        this.builder.ignoreErrors(value);
    }

    public ExecutePLSQLAction build() {
        if (this.referenceResolver != null) {
            this.builder.dataSource((DataSource)this.referenceResolver.resolve(this.dataSource, DataSource.class));
            if (this.transactionManager != null) {
                this.builder.transactionManager((PlatformTransactionManager)this.referenceResolver.resolve(this.transactionManager, PlatformTransactionManager.class));
            }
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public static class Statement {
        private String script;
        private String statement;
        protected String file;

        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String value) {
            this.file = value;
        }

        public String getStatement() {
            return this.statement;
        }

        public void setStatement(String statement) {
            this.statement = statement;
        }
    }

    public static class Transaction {
        protected String manager;
        protected String timeout;
        protected String isolationLevel;

        public String getManager() {
            return this.manager;
        }

        public void setManager(String manager) {
            this.manager = manager;
        }

        public String getTimeout() {
            return this.timeout;
        }

        public void setTimeout(String timeout) {
            this.timeout = timeout;
        }

        public String getIsolationLevel() {
            return this.isolationLevel;
        }

        public void setIsolationLevel(String isolationLevel) {
            this.isolationLevel = isolationLevel;
        }
    }
}

