/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.citrusframework.actions.AbstractDatabaseConnectingTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.SqlUtils;
import org.citrusframework.util.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.support.TransactionTemplate;

public class ExecutePLSQLAction
extends AbstractDatabaseConnectingTestAction {
    private final String script;
    private final boolean ignoreErrors;
    public static final String PLSQL_STMT_ENDING = "/";

    public ExecutePLSQLAction(Builder builder) {
        super("plsql", builder);
        this.ignoreErrors = builder.ignoreErrors;
        this.script = builder.script;
    }

    @Override
    public void doExecute(TestContext context) {
        List<String> statementsToUse = StringUtils.hasText((String)this.script) ? this.createStatementsFromScript(context) : (StringUtils.hasText((String)this.sqlResourcePath) ? this.createStatementsFromFileResource(context, new SqlUtils.LastScriptLineDecorator(){

            @Override
            public String getStatementEndingCharacter() {
                return ExecutePLSQLAction.PLSQL_STMT_ENDING;
            }

            @Override
            public String decorate(String line) {
                return line.trim().substring(0, line.trim().length() - 1);
            }
        }) : this.statements);
        if (this.getTransactionManager() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using transaction manager: " + this.getTransactionManager().getClass().getName()));
            }
            TransactionTemplate transactionTemplate = new TransactionTemplate(this.getTransactionManager());
            transactionTemplate.setTimeout(Integer.parseInt(context.replaceDynamicContentInString(this.getTransactionTimeout())));
            transactionTemplate.setIsolationLevelName(context.replaceDynamicContentInString(this.getTransactionIsolationLevel()));
            transactionTemplate.execute(status -> {
                this.executeStatements(statementsToUse, context);
                return null;
            });
        } else {
            this.executeStatements(statementsToUse, context);
        }
    }

    protected void executeStatements(List<String> statements, TestContext context) {
        if (this.getJdbcTemplate() == null) {
            throw new CitrusRuntimeException("No JdbcTemplate configured for sql execution!");
        }
        for (String statement : statements) {
            try {
                String toExecute = context.replaceDynamicContentInString(statement.trim());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Executing PLSQL statement: " + toExecute));
                }
                this.getJdbcTemplate().execute(toExecute);
                this.logger.info((Object)"PLSQL statement execution successful");
            }
            catch (DataAccessException e) {
                if (this.ignoreErrors) {
                    this.logger.warn((Object)("Ignoring error while executing PLSQL statement: " + e.getMessage()));
                    continue;
                }
                throw new CitrusRuntimeException("Failed to execute PLSQL statement", (Throwable)e);
            }
        }
    }

    private List<String> createStatementsFromScript(TestContext context) {
        ArrayList<String> stmts = new ArrayList<String>();
        String resolvedScript = context.replaceDynamicContentInString(this.script);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found inline PLSQL script " + resolvedScript));
        }
        StringTokenizer tok = new StringTokenizer(resolvedScript, PLSQL_STMT_ENDING);
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken().trim();
            if (!StringUtils.hasText((String)next)) continue;
            stmts.add(next);
        }
        return stmts;
    }

    public String getScript() {
        return this.script;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public static final class Builder
    extends AbstractDatabaseConnectingTestAction.Builder<ExecutePLSQLAction, Builder> {
        private boolean ignoreErrors = false;
        private String script;

        public static Builder plsql() {
            return new Builder();
        }

        public static Builder plsql(DataSource dataSource) {
            Builder builder = new Builder();
            builder.dataSource(dataSource);
            return builder;
        }

        public Builder sqlScript(String script) {
            this.script = script;
            return this;
        }

        @Override
        public Builder sqlResource(Resource sqlResource) {
            return this.sqlResource(sqlResource, FileUtils.getDefaultCharset());
        }

        public Builder sqlResource(Resource sqlResource, Charset charset) {
            try {
                this.sqlScript(FileUtils.readToString((Resource)sqlResource, (Charset)charset));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read sql resource", (Throwable)e);
            }
            return this;
        }

        public Builder ignoreErrors(boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        public ExecutePLSQLAction build() {
            return new ExecutePLSQLAction(this);
        }
    }
}

