/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.model;

import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasPaths;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.citrusframework.openapi.model.OpenApiVersion;
import org.citrusframework.openapi.model.v2.Oas20ModelHelper;
import org.citrusframework.openapi.model.v3.Oas30ModelHelper;

public final class OasModelHelper {
    private OasModelHelper() {
    }

    public static boolean isObjectType(OasSchema schema) {
        return "object".equals(schema.type);
    }

    public static boolean isArrayType(OasSchema schema) {
        return "array".equals(schema.type);
    }

    public static boolean isReferenceType(OasSchema schema) {
        return schema.$ref != null;
    }

    public static String getHost(OasDocument openApiDoc) {
        return OasModelHelper.delegate(openApiDoc, Oas20ModelHelper::getHost, Oas30ModelHelper::getHost);
    }

    public static List<String> getSchemes(OasDocument openApiDoc) {
        return OasModelHelper.delegate(openApiDoc, Oas20ModelHelper::getSchemes, Oas30ModelHelper::getSchemes);
    }

    public static String getBasePath(OasDocument openApiDoc) {
        return OasModelHelper.delegate(openApiDoc, Oas20ModelHelper::getBasePath, Oas30ModelHelper::getBasePath);
    }

    public static Map<String, OasSchema> getSchemaDefinitions(OasDocument openApiDoc) {
        return OasModelHelper.delegate(openApiDoc, Oas20ModelHelper::getSchemaDefinitions, Oas30ModelHelper::getSchemaDefinitions);
    }

    public static List<OasPathItem> getPathItems(OasPaths paths) {
        if (paths == null) {
            return Collections.emptyList();
        }
        return paths.getItems();
    }

    public static Map<String, OasOperation> getOperationMap(OasPathItem pathItem) {
        LinkedHashMap<String, OasOperation> operations = new LinkedHashMap<String, OasOperation>();
        if (pathItem.get != null) {
            operations.put("get", pathItem.get);
        }
        if (pathItem.put != null) {
            operations.put("put", pathItem.put);
        }
        if (pathItem.post != null) {
            operations.put("post", pathItem.post);
        }
        if (pathItem.delete != null) {
            operations.put("delete", pathItem.delete);
        }
        if (pathItem.options != null) {
            operations.put("options", pathItem.options);
        }
        if (pathItem.head != null) {
            operations.put("head", pathItem.head);
        }
        if (pathItem.patch != null) {
            operations.put("patch", pathItem.patch);
        }
        return operations;
    }

    public static String getReferenceName(String reference) {
        if (reference != null) {
            return reference.replaceAll("^.*/", "");
        }
        return null;
    }

    public static Optional<OasSchema> getSchema(OasResponse response) {
        return OasModelHelper.delegate(response, Oas20ModelHelper::getSchema, Oas30ModelHelper::getSchema);
    }

    public static Map<String, OasSchema> getRequiredHeaders(OasResponse response) {
        return OasModelHelper.delegate(response, Oas20ModelHelper::getHeaders, Oas30ModelHelper::getRequiredHeaders);
    }

    public static Map<String, OasSchema> getHeaders(OasResponse response) {
        return OasModelHelper.delegate(response, Oas20ModelHelper::getHeaders, Oas30ModelHelper::getHeaders);
    }

    public static Optional<String> getRequestContentType(OasOperation operation) {
        return OasModelHelper.delegate(operation, Oas20ModelHelper::getRequestContentType, Oas30ModelHelper::getRequestContentType);
    }

    public static Optional<OasSchema> getRequestBodySchema(OasDocument openApiDoc, OasOperation operation) {
        return OasModelHelper.delegate(openApiDoc, operation, Oas20ModelHelper::getRequestBodySchema, Oas30ModelHelper::getRequestBodySchema);
    }

    public static Optional<String> getResponseContentType(OasDocument openApiDoc, OasOperation operation) {
        return OasModelHelper.delegate(openApiDoc, operation, Oas20ModelHelper::getResponseContentType, Oas30ModelHelper::getResponseContentType);
    }

    private static <T> T delegate(OasDocument openApiDoc, Function<Oas20Document, T> oas20Function, Function<Oas30Document, T> oas30Function) {
        if (OasModelHelper.isOas20(openApiDoc)) {
            return oas20Function.apply((Oas20Document)openApiDoc);
        }
        if (OasModelHelper.isOas30(openApiDoc)) {
            return oas30Function.apply((Oas30Document)openApiDoc);
        }
        throw new IllegalArgumentException(String.format("Unsupported Open API document type: %s", openApiDoc.getClass()));
    }

    private static <T> T delegate(OasResponse response, Function<Oas20Response, T> oas20Function, Function<Oas30Response, T> oas30Function) {
        if (response instanceof Oas20Response) {
            return oas20Function.apply((Oas20Response)response);
        }
        if (response instanceof Oas30Response) {
            return oas30Function.apply((Oas30Response)response);
        }
        throw new IllegalArgumentException(String.format("Unsupported operation response type: %s", response.getClass()));
    }

    private static <T> T delegate(OasOperation operation, Function<Oas20Operation, T> oas20Function, Function<Oas30Operation, T> oas30Function) {
        if (operation instanceof Oas20Operation) {
            return oas20Function.apply((Oas20Operation)operation);
        }
        if (operation instanceof Oas30Operation) {
            return oas30Function.apply((Oas30Operation)operation);
        }
        throw new IllegalArgumentException(String.format("Unsupported operation type: %s", operation.getClass()));
    }

    private static <T> T delegate(OasDocument openApiDoc, OasOperation operation, BiFunction<Oas20Document, Oas20Operation, T> oas20Function, BiFunction<Oas30Document, Oas30Operation, T> oas30Function) {
        if (OasModelHelper.isOas20(openApiDoc)) {
            return oas20Function.apply((Oas20Document)openApiDoc, (Oas20Operation)operation);
        }
        if (OasModelHelper.isOas30(openApiDoc)) {
            return oas30Function.apply((Oas30Document)openApiDoc, (Oas30Operation)operation);
        }
        throw new IllegalArgumentException(String.format("Unsupported Open API document type: %s", openApiDoc.getClass()));
    }

    private static boolean isOas30(OasDocument openApiDoc) {
        return OpenApiVersion.fromDocumentType(openApiDoc).equals((Object)OpenApiVersion.V3);
    }

    private static boolean isOas20(OasDocument openApiDoc) {
        return OpenApiVersion.fromDocumentType(openApiDoc).equals((Object)OpenApiVersion.V2);
    }
}

