/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasSchema;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpServerResponseActionBuilder;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.OpenApiTestDataGenerator;
import org.citrusframework.openapi.model.OasModelHelper;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

public class OpenApiServerResponseActionBuilder
extends HttpServerResponseActionBuilder {
    public OpenApiServerResponseActionBuilder(OpenApiSpecification openApiSpec, String operationId, String statusCode) {
        this(new HttpMessage(), openApiSpec, operationId, statusCode);
    }

    public OpenApiServerResponseActionBuilder(HttpMessage httpMessage, OpenApiSpecification openApiSpec, String operationId, String statusCode) {
        super((MessageBuilder)new OpenApiServerResponseMessageBuilder(httpMessage, openApiSpec, operationId, statusCode), httpMessage);
    }

    private static class OpenApiServerResponseMessageBuilder
    extends HttpMessageBuilder {
        private final OpenApiSpecification openApiSpec;
        private final String operationId;
        private final String statusCode;
        private final HttpMessage httpMessage;

        public OpenApiServerResponseMessageBuilder(HttpMessage httpMessage, OpenApiSpecification openApiSpec, String operationId, String statusCode) {
            super(httpMessage);
            this.openApiSpec = openApiSpec;
            this.operationId = operationId;
            this.statusCode = statusCode;
            this.httpMessage = httpMessage;
        }

        public Message build(TestContext context, String messageType) {
            OasResponse response;
            OasOperation operation = null;
            OasDocument oasDocument = this.openApiSpec.getOpenApiDoc(context);
            for (OasPathItem path : OasModelHelper.getPathItems(oasDocument.paths)) {
                Optional<Map.Entry> operationEntry = OasModelHelper.getOperationMap(path).entrySet().stream().filter(op -> this.operationId.equals(((OasOperation)op.getValue()).operationId)).findFirst();
                if (!operationEntry.isPresent()) continue;
                operation = (OasOperation)operationEntry.get().getValue();
                break;
            }
            if (operation == null) {
                throw new CitrusRuntimeException("Unable to locate operation with id '%s' in OpenAPI specification %s".formatted(this.operationId, this.openApiSpec.getSpecUrl()));
            }
            if (operation.responses != null && (response = Optional.ofNullable(operation.responses.getItem(this.statusCode)).orElse(operation.responses.default_)) != null) {
                Map<String, OasSchema> requiredHeaders = OasModelHelper.getRequiredHeaders(response);
                for (Map.Entry entry : requiredHeaders.entrySet()) {
                    this.httpMessage.setHeader((String)entry.getKey(), (Object)OpenApiTestDataGenerator.createRandomValueExpression((String)entry.getKey(), (OasSchema)entry.getValue(), OasModelHelper.getSchemaDefinitions(oasDocument), false, this.openApiSpec, context));
                }
                Map<String, OasSchema> headers = OasModelHelper.getHeaders(response);
                for (Map.Entry<String, OasSchema> entry : headers.entrySet()) {
                    if (requiredHeaders.containsKey(entry.getKey()) || !context.getVariables().containsKey(entry.getKey())) continue;
                    this.httpMessage.setHeader(entry.getKey(), (Object)("${" + entry.getKey() + "}"));
                }
                Optional<OasSchema> optional = OasModelHelper.getSchema(response);
                optional.ifPresent(oasSchema -> this.httpMessage.setPayload((Object)OpenApiTestDataGenerator.createOutboundPayload(oasSchema, OasModelHelper.getSchemaDefinitions(oasDocument), this.openApiSpec)));
            }
            OasModelHelper.getResponseContentType(oasDocument, operation).ifPresent(contentType -> this.httpMessage.setHeader("Content-Type", contentType));
            if (Pattern.compile("[0-9]+").matcher(this.statusCode).matches()) {
                this.httpMessage.status((HttpStatusCode)HttpStatus.valueOf((int)Integer.parseInt(this.statusCode)));
            } else {
                this.httpMessage.status((HttpStatusCode)HttpStatus.OK);
            }
            return super.build(context, messageType);
        }
    }
}

