/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.actions.OpenApiClientRequestActionBuilder;
import org.citrusframework.openapi.actions.OpenApiClientResponseActionBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.ObjectHelper;
import org.springframework.http.HttpStatus;

public class OpenApiClientActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private final OpenApiSpecification specification;
    private ReferenceResolver referenceResolver;
    private Endpoint httpClient;
    private String httpClientUri;
    private TestActionBuilder<?> delegate;

    public OpenApiClientActionBuilder(Endpoint httpClient, OpenApiSpecification specification) {
        this.httpClient = httpClient;
        this.specification = specification;
    }

    public OpenApiClientActionBuilder(String httpClientUri, OpenApiSpecification specification) {
        this.httpClientUri = httpClientUri;
        this.specification = specification;
    }

    public OpenApiClientRequestActionBuilder send(String operationId) {
        OpenApiClientRequestActionBuilder builder = new OpenApiClientRequestActionBuilder(this.specification, operationId);
        if (this.httpClient != null) {
            builder.endpoint(this.httpClient);
        } else {
            builder.endpoint(this.httpClientUri);
        }
        builder.name("openapi:send-request");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public OpenApiClientResponseActionBuilder receive(String operationId) {
        return this.receive(operationId, HttpStatus.OK);
    }

    public OpenApiClientResponseActionBuilder receive(String operationId, HttpStatus status) {
        return this.receive(operationId, String.valueOf(status.value()));
    }

    public OpenApiClientResponseActionBuilder receive(String operationId, String statusCode) {
        OpenApiClientResponseActionBuilder builder = new OpenApiClientResponseActionBuilder(this.specification, operationId, statusCode);
        if (this.httpClient != null) {
            builder.endpoint(this.httpClient);
        } else {
            builder.endpoint(this.httpClientUri);
        }
        builder.name("openapi:receive-response");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public OpenApiClientActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        ObjectHelper.assertNotNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }
}

