/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.openapi.models.OasDocument;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.citrusframework.openapi.OpenApiSupport;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.springframework.http.HttpMethod;

public final class OpenApiResourceLoader {
    private OpenApiResourceLoader() {
    }

    public static OasDocument fromFile(String resource) {
        return OpenApiResourceLoader.fromFile(FileUtils.getFileResource((String)resource));
    }

    public static OasDocument fromFile(Resource resource) {
        try {
            return OpenApiResourceLoader.resolve(FileUtils.readToString((Resource)resource));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse Open API specification: " + resource, e);
        }
    }

    public static OasDocument fromWebResource(URL url) {
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod(HttpMethod.GET.name());
            con.setRequestProperty("Accept", "application/json");
            int status = con.getResponseCode();
            if (status > 299) {
                throw new IllegalStateException("Failed to retrieve Open API specification: " + url.toString(), new IOException(FileUtils.readToString((InputStream)con.getErrorStream())));
            }
            OasDocument oasDocument = OpenApiResourceLoader.resolve(FileUtils.readToString((InputStream)con.getInputStream()));
            return oasDocument;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to retrieve Open API specification: " + url.toString(), e);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public static OasDocument fromSecuredWebResource(URL url) {
        Objects.requireNonNull(url);
        HttpURLConnection con = null;
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE).build();
            HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod(HttpMethod.GET.name());
            con.setRequestProperty("Accept", "application/json");
            int status = con.getResponseCode();
            if (status > 299) {
                throw new IllegalStateException("Failed to retrieve Open API specification: " + url.toString(), new IOException(FileUtils.readToString((InputStream)con.getErrorStream())));
            }
            OasDocument oasDocument = OpenApiResourceLoader.resolve(FileUtils.readToString((InputStream)con.getInputStream()));
            return oasDocument;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to create https client for ssl connection", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to retrieve Open API specification: " + url.toString(), e);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    private static OasDocument resolve(String specification) {
        if (OpenApiResourceLoader.isJsonSpec(specification)) {
            return (OasDocument)Library.readDocumentFromJSONString((String)specification);
        }
        JsonNode node = (JsonNode)OpenApiSupport.json().convertValue(OpenApiSupport.yaml().load(specification), JsonNode.class);
        return (OasDocument)Library.readDocument((Object)node);
    }

    private static boolean isJsonSpec(String specification) {
        return specification.trim().startsWith("{");
    }
}

