/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jbang.yaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.jbang.actions.JBangAction;
import org.citrusframework.yaml.SchemaProperty;

public class JBang
implements TestActionBuilder<JBangAction> {
    private final JBangAction.Builder builder = new JBangAction.Builder();
    private List<Argument> arguments;
    private List<SystemProperty> systemProperties;

    @SchemaProperty(advanced=true, description="Test action description printed when the action is executed.")
    public void setDescription(String value) {
        this.builder.description(value);
    }

    @SchemaProperty
    public void setApp(String name) {
        this.builder.app(name);
    }

    @SchemaProperty
    public void setCommand(String command) {
        this.builder.command(command);
    }

    @SchemaProperty
    public void setFile(String path) {
        this.builder.file(path);
    }

    @SchemaProperty
    public void setExitCode(String codes) {
        this.builder.exitCodes(Arrays.stream(codes.split(",")).map(String::trim).map(Integer::parseInt).mapToInt(Integer::intValue).toArray());
    }

    @SchemaProperty
    public void setPrintOutput(boolean enabled) {
        this.builder.printOutput(enabled);
    }

    @SchemaProperty
    public void setOutput(String expected) {
        this.builder.verifyOutput(expected);
    }

    @SchemaProperty
    public void setSavePid(String variable) {
        this.builder.savePid(variable);
    }

    @SchemaProperty
    public void setSaveOutput(String variable) {
        this.builder.saveOutput(variable);
    }

    public List<Argument> getArguments() {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Argument>();
        }
        return this.arguments;
    }

    @SchemaProperty
    public void setArgs(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public List<SystemProperty> getSystemProperties() {
        if (this.systemProperties == null) {
            this.systemProperties = new ArrayList<SystemProperty>();
        }
        return this.systemProperties;
    }

    @SchemaProperty
    public void setSystemProperties(List<SystemProperty> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public JBangAction build() {
        for (Argument argument : this.getArguments()) {
            if (argument.getName() != null) {
                this.builder.arg(argument.getName(), argument.getValue());
                continue;
            }
            this.builder.arg(argument.getValue());
        }
        for (SystemProperty sysProp : this.getSystemProperties()) {
            this.builder.systemProperty(sysProp.getName(), sysProp.getValue());
        }
        return this.builder.build();
    }

    public static class Argument {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        @SchemaProperty(required=true)
        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        @SchemaProperty(required=true)
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class SystemProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        @SchemaProperty(required=true)
        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        @SchemaProperty(required=true)
        public void setValue(String value) {
            this.value = value;
        }
    }
}

