/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jbang;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class JBangSettings {
    private static final String JBANG_PROPERTY_PREFIX = "citrus.jbang.";
    private static final String JBANG_ENV_PREFIX = "CITRUS_JBANG_";
    private static final String TRUST_URLS_PROPERTY = "citrus.jbang.trust.urls";
    private static final String TRUST_URLS_ENV = "CITRUS_JBANG_TRUST_URLS";
    private static final String JBANG_AUTO_DOWNLOAD_PROPERTY = "citrus.jbang.auto.download";
    private static final String JBANG_AUTO_DOWNLOAD_ENV = "CITRUS_JBANG_AUTO_DOWNLOAD";
    private static final String JBANG_AUTO_DOWNLOAD_DEFAULT = "true";
    private static final String JBANG_DOWNLOAD_URL_PROPERTY = "citrus.jbang.download.url";
    private static final String JBANG_DOWNLOAD_URL_ENV = "CITRUS_JBANG_DOWNLOAD_URL";
    private static final String JBANG_DOWNLOAD_URL_DEFAULT = "https://jbang.dev/releases/latest/download/jbang.zip";
    private static final String JBANG_AUTO_TRUST_PROPERTY = "citrus.jbang.auto.trust";
    private static final String JBANG_AUTO_TRUST_ENV = "CITRUS_JBANG_AUTO_TRUST";
    private static final String JBANG_AUTO_TRUST_DEFAULT = "true";
    private static final String JBANG_CITRUS_TRUST_URL_PROPERTY = "citrus.jbang.trust.url";
    private static final String JBANG_CITRUS_TRUST_URL_ENV = "CITRUS_JBANG_TRUST_URL";
    private static final String JBANG_CITRUS_TRUST_URL_DEFAULT = "https://github.com/citrusframework/citrus/";
    private static final String WORK_DIR_PROPERTY = "citrus.jbang.work.dir";
    private static final String WORK_DIR_ENV = "CITRUS_JBANG_WORK_DIR";
    private static final String WORK_DIR_DEFAULT = ".citrus-jbang";
    private static final String DUMP_PROCESS_OUTPUT_PROPERTY = "citrus.jbang.dump.process.output";
    private static final String DUMP_PROCESS_OUTPUT_ENV = "CITRUS_JBANG_DUMP_PROCESS_OUTPUT";
    private static final String DUMP_PROCESS_OUTPUT_DEFAULT = "false";
    private static final String APP_PROPERTY = "citrus.jbang.app";
    private static final String APP_ENV = "CITRUS_JBANG_APP";
    private static final String APP_DEFAULT = "citrus@citrusframework/citrus";

    private JBangSettings() {
    }

    public static String getJBangDownloadUrl() {
        return System.getProperty(JBANG_DOWNLOAD_URL_PROPERTY, System.getenv(JBANG_DOWNLOAD_URL_ENV) != null ? System.getenv(JBANG_DOWNLOAD_URL_ENV) : JBANG_DOWNLOAD_URL_DEFAULT);
    }

    public static String getCitrusTrustUrl() {
        return System.getProperty(JBANG_CITRUS_TRUST_URL_PROPERTY, System.getenv(JBANG_CITRUS_TRUST_URL_ENV) != null ? System.getenv(JBANG_CITRUS_TRUST_URL_ENV) : JBANG_CITRUS_TRUST_URL_DEFAULT);
    }

    public static Path getWorkDir() {
        String workDir = Optional.ofNullable(System.getProperty(WORK_DIR_PROPERTY, System.getenv(WORK_DIR_ENV))).orElse(WORK_DIR_DEFAULT);
        Path path = Paths.get(workDir, new String[0]);
        if (path.isAbsolute()) {
            return path.toAbsolutePath();
        }
        return Paths.get("", new String[0]).toAbsolutePath().resolve(workDir).toAbsolutePath();
    }

    public static String[] getTrustUrls() {
        List trustUrls = Optional.ofNullable(System.getProperty(TRUST_URLS_PROPERTY, System.getenv(TRUST_URLS_ENV))).map(urls -> urls.split(",")).map(Arrays::asList).orElseGet(ArrayList::new);
        if (JBangSettings.isAutoTrust() && !trustUrls.contains(JBangSettings.getCitrusTrustUrl())) {
            trustUrls.add(JBangSettings.getCitrusTrustUrl());
        }
        return trustUrls.toArray(new String[0]);
    }

    public static boolean isAutoTrust() {
        return Boolean.parseBoolean(System.getProperty(JBANG_AUTO_TRUST_PROPERTY, System.getenv(JBANG_AUTO_TRUST_ENV) != null ? System.getenv(JBANG_AUTO_TRUST_ENV) : "true"));
    }

    public static boolean isAutoDownload() {
        return Boolean.parseBoolean(System.getProperty(JBANG_AUTO_DOWNLOAD_PROPERTY, System.getenv(JBANG_AUTO_DOWNLOAD_ENV) != null ? System.getenv(JBANG_AUTO_DOWNLOAD_ENV) : "true"));
    }

    public static boolean isDumpProcessOutput() {
        return Boolean.parseBoolean(System.getProperty(DUMP_PROCESS_OUTPUT_PROPERTY, System.getenv(DUMP_PROCESS_OUTPUT_ENV) != null ? System.getenv(DUMP_PROCESS_OUTPUT_ENV) : DUMP_PROCESS_OUTPUT_DEFAULT));
    }

    public static String getApp() {
        return System.getProperty(APP_PROPERTY, System.getenv(APP_ENV) != null ? System.getenv(APP_ENV) : APP_DEFAULT);
    }
}

