/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jbang.xml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.jbang.actions.JBangAction;

@XmlRootElement(name="jbang")
public class JBang
implements TestActionBuilder<JBangAction> {
    private final JBangAction.Builder builder = new JBangAction.Builder();

    @XmlElement
    public JBang setDescription(String value) {
        this.builder.description(value);
        return this;
    }

    @XmlAttribute
    public JBang setApp(String name) {
        this.builder.app(name);
        return this;
    }

    @XmlAttribute
    public JBang setCommand(String command) {
        this.builder.command(command);
        return this;
    }

    @XmlAttribute
    public JBang setFile(String path) {
        this.builder.file(path);
        return this;
    }

    @XmlAttribute
    public JBang setArgs(String args) {
        this.builder.args(args.split(","));
        return this;
    }

    @XmlAttribute(name="exit-code")
    public JBang setExitCode(String codes) {
        this.builder.exitCodes(Arrays.stream(codes.split(",")).map(String::trim).map(Integer::parseInt).mapToInt(Integer::intValue).toArray());
        return this;
    }

    @XmlAttribute(name="print-output")
    public JBang setPrintOutput(boolean enabled) {
        this.builder.printOutput(enabled);
        return this;
    }

    @XmlElement
    public JBang setOutput(String expected) {
        this.builder.verifyOutput(expected);
        return this;
    }

    @XmlAttribute(name="save-pid")
    public JBang setSavePid(String variable) {
        this.builder.savePid(variable);
        return this;
    }

    @XmlAttribute(name="save-output")
    public JBang setSaveOutput(String variable) {
        this.builder.saveOutput(variable);
        return this;
    }

    @XmlElement(name="args")
    public JBang setArguments(Arguments arguments) {
        for (Arguments.Argument argument : arguments.getArguments()) {
            if (argument.getName() != null) {
                this.builder.arg(argument.getName(), argument.getValue());
                continue;
            }
            this.builder.arg(argument.getValue());
        }
        return this;
    }

    @XmlElement(name="system-properties")
    public JBang setSystemProperties(SystemProperties systemProperties) {
        for (SystemProperties.SystemProperty sysProp : systemProperties.getSystemProperties()) {
            this.builder.systemProperty(sysProp.getName(), sysProp.getValue());
        }
        return this;
    }

    public JBangAction build() {
        return this.builder.build();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"arguments"})
    public static class Arguments {
        @XmlElement(name="arg")
        private List<Argument> arguments;

        public List<Argument> getArguments() {
            if (this.arguments == null) {
                this.arguments = new ArrayList<Argument>();
            }
            return this.arguments;
        }

        public void setArguments(List<Argument> arguments) {
            this.arguments = arguments;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Argument {
            @XmlAttribute
            private String name;
            @XmlAttribute(required=true)
            private String value;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"systemProperties"})
    public static class SystemProperties {
        @XmlElement(name="system-property")
        private List<SystemProperty> systemProperties;

        public List<SystemProperty> getSystemProperties() {
            if (this.systemProperties == null) {
                this.systemProperties = new ArrayList<SystemProperty>();
            }
            return this.systemProperties;
        }

        public void setSystemProperties(List<SystemProperty> systemProperties) {
            this.systemProperties = systemProperties;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class SystemProperty {
            @XmlAttribute(required=true)
            private String name;
            @XmlAttribute(required=true)
            private String value;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

